package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: SelectSpeciesForBenthosBatchAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/SelectSpeciesForBenthosBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUIModel;

import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n.t;

/**
 * Enable to select a species to the species selected in the protocol.
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class SelectSpeciesForBenthosBatchAction extends AbstractTuttiAction<CreateBenthosBatchUIModel, CreateBenthosBatchUI, CreateBenthosBatchUIHandler> {

    protected List<Species> allSpecies;

    protected List<Species> referentSpecies;

    protected Species selectedSpecies;

    public SelectSpeciesForBenthosBatchAction(CreateBenthosBatchUIHandler handler) {
        super(handler, false);

        allSpecies = getDataContext().getSpecies();
        referentSpecies = getDataContext().getReferentSpecies();
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        if (canContinue) {

            CreateBenthosBatchUIModel model = getModel();

            List<Species> species = Lists.newArrayList(allSpecies);
            species.removeAll(model.getAvailableSpecies());

            selectedSpecies = getHandler().openAddSpeciesDialog(
                    t("tutti.selectSpecies.title"), species);
            canContinue = selectedSpecies != null;
        }
        return canContinue;
    }

    @Override
    public void doAction() throws Exception {

        CreateBenthosBatchUIModel model = getModel();

        List<Species> availableSpecies = Lists.newArrayList(model.getAvailableSpecies());

        if (!selectedSpecies.isReferenceTaxon()) {
            String decoratedSynonym = decorate(selectedSpecies, DecoratorService.FROM_PROTOCOL);
            List<Species> referents = referentSpecies;
            Map<String, Species> referentsById = TuttiEntities.splitByTaxonId(referents);
            String taxonId = String.valueOf(selectedSpecies.getReferenceTaxonId());
            selectedSpecies = referentsById.get(taxonId);
            String decoratedReferent = decorate(selectedSpecies, DecoratorService.FROM_PROTOCOL);
            sendMessage(t("tutti.flash.info.species.replaced", decoratedSynonym, decoratedReferent));
        }

        if (!availableSpecies.contains(selectedSpecies)) {
            availableSpecies.add(selectedSpecies);
        }
        model.setAvailableSpecies(availableSpecies);
        model.setSpecies(selectedSpecies);

    }

}
