/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.export.sumatra.CatchesSumatraExportServiceV2;
import fr.ifremer.tutti.ui.swing.action.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.io.File;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;

public class ExportCruiseForSumatraV2Action
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ExportCruiseForSumatraV2Action.class);
    protected File file;

    public ExportCruiseForSumatraV2Action(MainUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction && !this.getDataContext().isProtocolFilled()) {
            this.displayWarningMessage(I18n.t((String)"tutti.exportCruiseForSumatraV2.title.required.protocol", (Object[])new Object[0]), I18n.t((String)"tutti.exportCruiseForSumatraV2.message.required.protocol", (Object[])new Object[0]));
            doAction = false;
        }
        if (doAction) {
            String date = DateUtil.formatDate((Date)new Date(), (String)"dd-MM-yyyy");
            this.file = this.saveFile(String.format("sumatra_v2_%s_%s", this.getDataContext().getCruise().getName(), date), "csv", I18n.t((String)"tutti.exportCruiseForSumatraV2.title.choose.exportFile", (Object[])new Object[0]), I18n.t((String)"tutti.exportCruiseForSumatraV2.action.chooseFile", (Object[])new Object[0]), new String[]{"^.+\\.csv$", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = this.getDataContext().getCruise();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cruise " + cruise.getId() + " to file: " + this.file));
        }
        ProgressionModel pm = new ProgressionModel();
        pm.setTotal(3);
        this.setProgressionModel(pm);
        CatchesSumatraExportServiceV2 service = this.getContext().getCatchesSumatraExportServiceV2();
        service.exportCruiseForSumatra(this.file, cruise.getId(), pm);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.exportCruiseForSumatraV2.action.success", (Object[])new Object[]{this.file}));
    }
}

