/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.sumatra;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.ExportBatchEntry;
import fr.ifremer.tutti.service.export.sumatra.CatchRowV2;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.i18n.I18n;

public class CatchRowModelV2
extends TuttiCsvUtil.AbstractTuttiImportExportModel<CatchRowV2> {
    public CatchRowModelV2(char separator) {
        super(separator);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.year", (Object[])new Object[0]), "gearShootingStartDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.station", (Object[])new Object[0]), "stationNumber");
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.multirigAggregation", (Object[])new Object[0]), "multirigAggregation");
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.species", (Object[])new Object[0]), "species", TuttiCsvUtil.SPECIES_SURVEY_CODE_FORMATTER);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.sign", (Object[])new Object[0]), "sign");
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.sortedWeight", (Object[])new Object[0]), "sortedWeight", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.totalWeight", (Object[])new Object[0]), "totalWeight", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.averageWeight", (Object[])new Object[0]), "averageWeight", TuttiCsvUtil.NUMBER_OR_NA);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.averageSize", (Object[])new Object[0]), "averageSize", TuttiCsvUtil.NUMBER_OR_NA);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.number", (Object[])new Object[0]), "number", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport(I18n.t((String)"tutti.service.exportSumatraV2.header.moule", (Object[])new Object[0]), "moule", TuttiCsvUtil.NUMBER_OR_NA);
    }

    public CatchRowV2 newEmptyInstance() {
        return new CatchRowV2();
    }

    public CatchRowV2 newRow(FishingOperation operation, ExportBatchEntry entry) {
        CatchRowV2 row = this.newEmptyInstance();
        row.setFishingOperation(operation);
        row.setSpecies(entry.getBatch().getSpecies());
        row.setSortedWeight(Float.valueOf(entry.getSortedWeight()));
        float totalWeight = entry.getTotalWeight();
        int number = entry.getTotalNumber();
        row.setNumber(number);
        row.setTotalWeight(Float.valueOf(totalWeight));
        row.setAverageSize(entry.getAverageFrequency());
        row.setAverageWeight(number == 0 ? null : Float.valueOf(totalWeight / (float)number));
        row.setMoule(totalWeight == 0.0f ? null : Float.valueOf((float)number / totalWeight));
        return row;
    }
}

