// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.sample;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


/**
 * <p>
 * Un prélèvement représente un (et un seul) support, prélevé au
 * cours d'une opération de peche, d'un échantillonnage au
 * débarquement ou d'une vente. Il s'agit de la partie qui est
 * recueillie pour analyse ou dénombrement.
 * </p>
 * <p>
 * Un prélèvement est rattaché à une opération de peche ou un
 * groupe d'opérations, un débarquement ou à une vente. Il peut
 * être en plus rattaché à un des lots échantillonnés (le lot de
 * provenance).
 * </p>
 * <p>
 * Dans le cas des marées observées en mer, un prlèvement
 * correspond à un individu, dont le support est, par exemple :
 * </p>
 * <p>
 * - crustacé (crevette...)
 * </p>
 * <p>
 * - poisson (merlu, sardine...)
 * </p>
 * <p>
 * - gastéropode (bigorneau, littorine...)
 * </p>
 * <p>
 * - echinoderme (oursin...)
 * </p>
 * <p>
 * - etc.
 * </p>
 * <p>
 * Le nombre d'individu, généralement égal à 1, permet de
 * constituer des prélèvement de plusieurs individu (dès lors qu'il
 * sont ne meme anture). Chaque résultat de mesure
 * (SampleMeasurement) pourra identifié l'individu concerné par la
 * mesure, par une numéro din'dividu.
 * </p>
 * <p>
 * Un mnémonique, représentant généralement l'étiquette collée sur
 * le sachet contenant le prélèvement, permet d"identifier le
 * prélèvement de manière simple, notamment en laboratoire pour la
 * saisie des lectures d'age, etc..
 * </p>
 * <p>
 * Par exemple de prélèvement :
 * </p>
 * <p>
 * - un poisson, d'une espèce donnée, sur lequel est prélevé un
 * otholithe, et/ou des écailes afin de réaliser une lecture d'age.
 * </p>
 * <p>
 * - un cétacé, issu d'un lot, sur lesquels doit être effectué des
 * analyses d'age, de taille,
 * </p>
 * <p>
 * - etc.
 * </p>
 */
public abstract class Sample
    implements java.io.Serializable
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -4679812335657343627L;

    private java.lang.Integer id;

    /**
     * <p>
     * Identifiant de l'échantillon. Généré par le système.
     * </p>
     */
    public java.lang.Integer getId()
    {
        return this.id;
    }

    public void setId(java.lang.Integer id)
    {
        this.id = id;
    }

    private java.lang.String label;

    /**
     * <p>
     * Mnémonique du prélèvement. Par exemple, il peut s'agir d'un code
     * propre à chaque programme : pour les marées observée, par
     * exemple, il s'agira d'une étiquette permettant d'identifier
     * l'échantillon sur le terrain puis en laboratoire.
     * </p>
     * <p>
     * Autant que possible, le mnémonique devra etre unique pour tous
     * le système, ou à défaut unique au sein de la marée, du
     * débarquement, de la vente ou de la campagne.
     * </p>
     * <p>
     * Nomenclature retenue à l'issu des spécifications Allegro V3 :
     * <date>_<initiales>_<lieu>_<G|S>_<numéro>
     * </p>
     * <p>
     * Avec :
     * </p>
     * <p>
     * - <date> : date de l’observation au format AAAMMJJ. La date est
     * issue (suivant la donnée mère rattachée) :
     * </p>
     * <p>
     * * de la date de début de l’opération de pêche ou du groupe
     * d’opérations (si période du groupe d’opération n’a pas été
     * renseigné : prendre la date de début de la marée)
     * </p>
     * <p>
     * * ou de la date de débarquement,
     * </p>
     * <p>
     * * ou de la date de la vente.
     * </p>
     * <p>
     * - <initiales> : il s’agit des initiales déjà saisit par
     * l’utilisateur (cf variante précédente).
     * </p>
     * <p>
     * - <lieu> : mnémonique du lieu d’observation, si présent, ou
     * libellé sinon. Le lieu d’observation est issu (suivant la donnée
     * mère rattachée) :
     * </p>
     * <p>
     * * pour une opération de pêche ou un groupe d’opérations, il
     * s’agit du port de départ de la marée,
     * </p>
     * <p>
     * * pour un débarquement, du lieu de débarquement
     * </p>
     * <p>
     * * pour une vente, du lieu de la vente
     * </p>
     * <p>
     * - <G|S> : suivant la donnée mère rattachée :
     * </p>
     * <p>
     * * ‘G’ (=Ground) si donnée mère rattachée est un débarquement ou
     * une vente ;
     * </p>
     * <p>
     * * ‘S’ (=Sea) si donnée mère rattachée est une opération de pêche
     * ou à une groupe d’opérations.
     * </p>
     * <p>
     * - <numéro> : Il s’agit d’un numéro au format NNN (sur trois
     * caractère. Exemple : « 001 »), auto-incrémentée (valeur maximale
     * connue + 1) de manière à être unique au sein de (suivant la
     * donnée mère rattachée) :
     * </p>
     * <p>
     * * la marée, si la donnée mère rattachée est une opération de
     * pêche ou un groupe d’opérations
     * </p>
     * <p>
     * * ou du débarquement,
     * </p>
     * <p>
     * * ou de la vente
     * </p>
     */
    public java.lang.String getLabel()
    {
        return this.label;
    }

    public void setLabel(java.lang.String label)
    {
        this.label = label;
    }

    private java.util.Date sampleDate;

    /**
     * <p>
     * Jour du prélèvement (heure optionnelle).
     * </p>
     */
    public java.util.Date getSampleDate()
    {
        return this.sampleDate;
    }

    public void setSampleDate(java.util.Date sampleDate)
    {
        this.sampleDate = sampleDate;
    }

    private java.lang.Short individualCount;

    /**
     * <p>
     * Nombre d'individus constituant l'échantillon.
     * </p>
     */
    public java.lang.Short getIndividualCount()
    {
        return this.individualCount;
    }

    public void setIndividualCount(java.lang.Short individualCount)
    {
        this.individualCount = individualCount;
    }

    private java.lang.Float size;

    /**
     * <p>
     * La taille de l'échantillon peut représenter une surface ou un
     * volume suivant les cas. Il peut aussi s'agir du nombre
     * d'individus entrant dans l'homogénat.
     * </p>
     */
    public java.lang.Float getSize()
    {
        return this.size;
    }

    public void setSize(java.lang.Float size)
    {
        this.size = size;
    }

    private java.lang.String synchronizationStatus;

    /**
     * <p>
     * Etat de synchronisation (en cours, terminé, en attente de
     * synchro, supprimé). Seulement visible dans la base locale.
     * </p>
     */
    public java.lang.String getSynchronizationStatus()
    {
        return this.synchronizationStatus;
    }

    public void setSynchronizationStatus(java.lang.String synchronizationStatus)
    {
        this.synchronizationStatus = synchronizationStatus;
    }

    private java.lang.String comments;

    /**
     * <p>
     * Commentaire libre concernant l'échantillon.
     * </p>
     */
    public java.lang.String getComments()
    {
        return this.comments;
    }

    public void setComments(java.lang.String comments)
    {
        this.comments = comments;
    }

    private java.util.Date creationDate;

    /**
     * 
     */
    public java.util.Date getCreationDate()
    {
        return this.creationDate;
    }

    public void setCreationDate(java.util.Date creationDate)
    {
        this.creationDate = creationDate;
    }

    private java.util.Date controlDate;

    /**
     * 
     */
    public java.util.Date getControlDate()
    {
        return this.controlDate;
    }

    public void setControlDate(java.util.Date controlDate)
    {
        this.controlDate = controlDate;
    }

    private java.util.Date validationDate;

    /**
     * 
     */
    public java.util.Date getValidationDate()
    {
        return this.validationDate;
    }

    public void setValidationDate(java.util.Date validationDate)
    {
        this.validationDate = validationDate;
    }

    private java.util.Date qualificationDate;

    /**
     * 
     */
    public java.util.Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    public void setQualificationDate(java.util.Date qualificationDate)
    {
        this.qualificationDate = qualificationDate;
    }

    private java.lang.String qualificationComments;

    /**
     * 
     */
    public java.lang.String getQualificationComments()
    {
        return this.qualificationComments;
    }

    public void setQualificationComments(java.lang.String qualificationComments)
    {
        this.qualificationComments = qualificationComments;
    }

    private java.sql.Timestamp updateDate;

    /**
     * 
     */
    public java.sql.Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    public void setUpdateDate(java.sql.Timestamp updateDate)
    {
        this.updateDate = updateDate;
    }


    private fr.ifremer.adagio.core.dao.referential.pmfm.Matrix matrix;

    /**
     * <p>
     * Support de l'échantillon.
     * </p>
     */
    public fr.ifremer.adagio.core.dao.referential.pmfm.Matrix getMatrix()
    {
        return this.matrix;
    }

    public void setMatrix(fr.ifremer.adagio.core.dao.referential.pmfm.Matrix matrix)
    {
        this.matrix = matrix;
    }


    private fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon referenceTaxon;

    /**
     * <p>
     * Taxon (espèce scientifique) caractéristant l'échantillon
     * (optionnel)
     * </p>
     */
    public fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon getReferenceTaxon()
    {
        return this.referenceTaxon;
    }

    public void setReferenceTaxon(fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon referenceTaxon)
    {
        this.referenceTaxon = referenceTaxon;
    }


    private fr.ifremer.adagio.core.dao.administration.user.Department recorderDepartment;

    /**
     * 
     */
    public fr.ifremer.adagio.core.dao.administration.user.Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    public void setRecorderDepartment(fr.ifremer.adagio.core.dao.administration.user.Department recorderDepartment)
    {
        this.recorderDepartment = recorderDepartment;
    }


    private fr.ifremer.adagio.core.dao.administration.programStrategy.Program program;

    /**
     * 
     */
    public fr.ifremer.adagio.core.dao.administration.programStrategy.Program getProgram()
    {
        return this.program;
    }

    public void setProgram(fr.ifremer.adagio.core.dao.administration.programStrategy.Program program)
    {
        this.program = program;
    }


    private fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup taxonGroup;

    /**
     * <p>
     * Groupe de taxon (généralement espèce commerciale) caractéristant
     * l'échantillon (optionnel)
     * </p>
     */
    public fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup getTaxonGroup()
    {
        return this.taxonGroup;
    }

    public void setTaxonGroup(fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup taxonGroup)
    {
        this.taxonGroup = taxonGroup;
    }


    private fr.ifremer.adagio.core.dao.data.batch.Batch batch;

    /**
     * <p>
     * Lot auquel appartient l'échantillon analysé (optionnel).
     * </p>
     */
    public fr.ifremer.adagio.core.dao.data.batch.Batch getBatch()
    {
        return this.batch;
    }

    public void setBatch(fr.ifremer.adagio.core.dao.data.batch.Batch batch)
    {
        this.batch = batch;
    }


    private fr.ifremer.adagio.core.dao.administration.user.Person recorderPerson;

    /**
     * 
     */
    public fr.ifremer.adagio.core.dao.administration.user.Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    public void setRecorderPerson(fr.ifremer.adagio.core.dao.administration.user.Person recorderPerson)
    {
        this.recorderPerson = recorderPerson;
    }


    private fr.ifremer.adagio.core.dao.referential.QualityFlag qualityFlag;

    /**
     * <p>
     * Niveau de qualité de la donnée.
     * </p>
     * <p>
     * "Non qualifiée" par défaut
     * </p>
     */
    public fr.ifremer.adagio.core.dao.referential.QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    public void setQualityFlag(fr.ifremer.adagio.core.dao.referential.QualityFlag qualityFlag)
    {
        this.qualityFlag = qualityFlag;
    }


    private fr.ifremer.adagio.core.dao.data.sample.Sample parentSample;

    /**
     * <p>
     * Parent sample. Use in MerluMed.
     * </p>
     * <p>
     * Ex : un poisson peut avoir dans sont estomac plusieurs autres
     * poissons.
     * </p>
     */
    public fr.ifremer.adagio.core.dao.data.sample.Sample getParentSample()
    {
        return this.parentSample;
    }

    public void setParentSample(fr.ifremer.adagio.core.dao.data.sample.Sample parentSample)
    {
        this.parentSample = parentSample;
    }


    private java.util.Collection<fr.ifremer.adagio.core.dao.data.sample.Sample> childSamples = new java.util.HashSet<fr.ifremer.adagio.core.dao.data.sample.Sample>();

    /**
     * 
     */
    public java.util.Collection<fr.ifremer.adagio.core.dao.data.sample.Sample> getChildSamples()
    {
        return this.childSamples;
    }

    public void setChildSamples(java.util.Collection<fr.ifremer.adagio.core.dao.data.sample.Sample> childSamples)
    {
        this.childSamples = childSamples;
    }


    private fr.ifremer.adagio.core.dao.referential.pmfm.Unit sizeUnit;

    /**
     * <p>
     * Unité associée à la valeur de la taille du prélèvement.
     * </p>
     */
    public fr.ifremer.adagio.core.dao.referential.pmfm.Unit getSizeUnit()
    {
        return this.sizeUnit;
    }

    public void setSizeUnit(fr.ifremer.adagio.core.dao.referential.pmfm.Unit sizeUnit)
    {
        this.sizeUnit = sizeUnit;
    }


    private fr.ifremer.adagio.core.dao.data.operation.FishingOperation fishingOperation;

    /**
     * <p>
     * Opération de prélèvement à laquelle est rattaché l'échantillon
     * analysé.
     * </p>
     */
    public fr.ifremer.adagio.core.dao.data.operation.FishingOperation getFishingOperation()
    {
        return this.fishingOperation;
    }

    public void setFishingOperation(fr.ifremer.adagio.core.dao.data.operation.FishingOperation fishingOperation)
    {
        this.fishingOperation = fishingOperation;
    }


    private java.util.Collection<fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea> fishingAreas = new java.util.HashSet<fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea>();

    /**
     * <p>
     * Zone de peche du prélèvement (utilisé surtout dans le cas d'un
     * prélèvement hors marée/débarquement ou vente - exemple :
     * prélèvement en poissonnerie)
     * </p>
     */
    public java.util.Collection<fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea> getFishingAreas()
    {
        return this.fishingAreas;
    }

    public void setFishingAreas(java.util.Collection<fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea> fishingAreas)
    {
        this.fishingAreas = fishingAreas;
    }


    private java.util.Collection<fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement> sampleMeasurements = new java.util.HashSet<fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement>();

    /**
     * 
     */
    public java.util.Collection<fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement> getSampleMeasurements()
    {
        return this.sampleMeasurements;
    }

    public void setSampleMeasurements(java.util.Collection<fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement> sampleMeasurements)
    {
        this.sampleMeasurements = sampleMeasurements;
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only return <code>true</code> if the argument reference and <code>this</code>
     * refer to the same object.
     */
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Sample))
        {
            return false;
        }
        final Sample that = (Sample)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (id == null ? 0 : id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link fr.ifremer.adagio.core.dao.data.sample.Sample}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.data.sample.Sample}.
         */
        public static fr.ifremer.adagio.core.dao.data.sample.Sample newInstance()
        {
            final fr.ifremer.adagio.core.dao.data.sample.Sample entity = new fr.ifremer.adagio.core.dao.data.sample.SampleImpl();
			return entity;
        }

        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.data.sample.Sample}, taking all required and/or
         * read-only properties as arguments.
         */
        public static fr.ifremer.adagio.core.dao.data.sample.Sample newInstance(java.lang.String label, java.lang.String synchronizationStatus, java.util.Date creationDate, fr.ifremer.adagio.core.dao.referential.pmfm.Matrix matrix, fr.ifremer.adagio.core.dao.administration.user.Department recorderDepartment, fr.ifremer.adagio.core.dao.administration.programStrategy.Program program, fr.ifremer.adagio.core.dao.referential.QualityFlag qualityFlag)
        {
            final fr.ifremer.adagio.core.dao.data.sample.Sample entity = newInstance();
            entity.setLabel(label);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setCreationDate(creationDate);
            entity.setMatrix(matrix);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.data.sample.Sample}, taking all possible properties
         * (except the identifier(s))as arguments.
         */
        public static fr.ifremer.adagio.core.dao.data.sample.Sample newInstance(java.lang.String label, java.util.Date sampleDate, java.lang.Short individualCount, java.lang.Float size, java.lang.String synchronizationStatus, java.lang.String comments, java.util.Date creationDate, java.util.Date controlDate, java.util.Date validationDate, java.util.Date qualificationDate, java.lang.String qualificationComments, java.sql.Timestamp updateDate, fr.ifremer.adagio.core.dao.referential.pmfm.Matrix matrix, fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon referenceTaxon, fr.ifremer.adagio.core.dao.administration.user.Department recorderDepartment, fr.ifremer.adagio.core.dao.administration.programStrategy.Program program, fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup taxonGroup, fr.ifremer.adagio.core.dao.data.batch.Batch batch, fr.ifremer.adagio.core.dao.administration.user.Person recorderPerson, fr.ifremer.adagio.core.dao.referential.QualityFlag qualityFlag, fr.ifremer.adagio.core.dao.data.sample.Sample parentSample, java.util.Collection<fr.ifremer.adagio.core.dao.data.sample.Sample> childSamples, fr.ifremer.adagio.core.dao.referential.pmfm.Unit sizeUnit, fr.ifremer.adagio.core.dao.data.operation.FishingOperation fishingOperation, java.util.Collection<fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea> fishingAreas, java.util.Collection<fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement> sampleMeasurements)
        {
            final fr.ifremer.adagio.core.dao.data.sample.Sample entity = newInstance();
            entity.setLabel(label);
            entity.setSampleDate(sampleDate);
            entity.setIndividualCount(individualCount);
            entity.setSize(size);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setMatrix(matrix);
            entity.setReferenceTaxon(referenceTaxon);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setTaxonGroup(taxonGroup);
            entity.setBatch(batch);
            entity.setRecorderPerson(recorderPerson);
            entity.setQualityFlag(qualityFlag);
            entity.setParentSample(parentSample);
            entity.setChildSamples(childSamples);
            entity.setSizeUnit(sizeUnit);
            entity.setFishingOperation(fishingOperation);
            entity.setFishingAreas(fishingAreas);
            entity.setSampleMeasurements(sampleMeasurements);
            return entity;
        }
    }
    
// Sample.java merge-point
}