/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.batch;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatchDao;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationException;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.TuttiCatchBatchValidator;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Component;

@Component(value="batchPersistenceHelper")
public class BatchPersistenceHelper
extends AbstractPersistenceService {
    private static final Log log = LogFactory.getLog(BatchPersistenceHelper.class);
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="individualObservationBatchPersistenceService")
    protected IndividualObservationBatchPersistenceService individualObservationBatchPersistenceService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    @Resource(name="sortingBatchDao")
    protected SortingBatchDao sortingBatchDao;
    @Resource(name="scientificCruiseCatchBatchValidator")
    protected TuttiCatchBatchValidator catchBatchValidator;
    @Autowired
    protected MeasurementPersistenceHelper measurementPersistenceHelper;

    @Override
    public void init() {
        super.init();
        this.catchBatchDao.registerCatchBatchValidator((CatchBatchValidator)this.catchBatchValidator);
    }

    @Override
    public void close() {
        this.catchBatchDao.unregisterCatchBatchValidator((CatchBatchValidator)this.catchBatchValidator);
        super.close();
    }

    public fr.ifremer.tutti.persistence.entities.data.CatchBatch createCatchBatch(fr.ifremer.tutti.persistence.entities.data.CatchBatch bean, CatchBatch catchBatch) {
        catchBatch = this.catchBatchDao.create(catchBatch);
        bean.setId(catchBatch.getId());
        return bean;
    }

    public void validateSpecies(SampleCategoryModel sampleCategoryModel, BatchContainer<SpeciesBatch> species) throws InvalidBatchModelException {
        List<CatchBatchValidationError> errors = this.catchBatchValidator.validateSpecies(sampleCategoryModel, species);
        ArrayList errorsStr = Lists.newArrayList();
        for (CatchBatchValidationError error : errors) {
            if (error.getGravity() != 2) continue;
            errorsStr.add(error.getMessage());
        }
        if (!errorsStr.isEmpty()) {
            String join = Joiner.on((String)"<br/>").join((Iterable)errorsStr);
            throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.batch.validation.bad.sample.categories", (Object[])new Object[]{join}));
        }
    }

    public void validateBenthos(SampleCategoryModel sampleCategoryModel, BatchContainer<BenthosBatch> benthos) throws InvalidBatchModelException {
        List<CatchBatchValidationError> errors = this.catchBatchValidator.validateBenthos(sampleCategoryModel, benthos);
        if (CollectionUtils.isNotEmpty(errors)) {
            ArrayList errorsStr = Lists.newArrayList();
            for (CatchBatchValidationError error : errors) {
                if (error.getGravity() != 2) continue;
                errorsStr.add(error.getMessage());
            }
            if (!errorsStr.isEmpty()) {
                String join = Joiner.on((String)"<br/>").join((Iterable)errorsStr);
                throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.batch.validation.bad.sample.categories", (Object[])new Object[]{join}));
            }
        }
    }

    public void deleteCatchBatch(String fishingOperationId, Integer catchBatchId) {
        this.individualObservationBatchPersistenceService.deleteIndividualObservationBatchForFishingOperation(fishingOperationId);
        this.getCurrentSession().flush();
        List ids = this.catchBatchDao.getAllChildrenIds(catchBatchId);
        this.catchBatchDao.remove(catchBatchId);
        this.getCurrentSession().flush();
        this.attachmentPersistenceService.deleteAllAttachment(AttachementObjectTypeEnum.BATCH, ids.toArray(new Integer[ids.size()]));
    }

    public <D extends TuttiEntity> D createSortingBatch(D bean, CatchBatch catchBatch, SortingBatch batch) {
        batch = this.catchBatchDao.createSortingBatch(batch, catchBatch);
        bean.setId(batch.getId());
        return bean;
    }

    public void removeWithChildren(Integer batchId) {
        List ids = this.catchBatchDao.getAllChildrenIds(batchId);
        ids.add(batchId);
        this.catchBatchDao.removeWithChildren(batchId);
        this.attachmentPersistenceService.deleteAllAttachment(AttachementObjectTypeEnum.BATCH, ids.toArray(new Integer[ids.size()]));
    }

    public void removeWithChildren(Integer batchId, CatchBatch parentCatchBatch) {
        List ids = this.catchBatchDao.getAllChildrenIds(batchId);
        ids.add(batchId);
        this.catchBatchDao.removeWithChildren(batchId, parentCatchBatch);
        this.attachmentPersistenceService.deleteAllAttachment(AttachementObjectTypeEnum.BATCH, ids.toArray(new Integer[ids.size()]));
    }

    public void updateSortingBatch(List<SortingBatch> sortingBatchs, CatchBatch parentCatchBatch) {
        this.catchBatchDao.updateSortingBatch(sortingBatchs, parentCatchBatch);
    }

    public SortingBatch loadSortingBatch(Integer sortingBatchId, CatchBatch parentCatchBatch) {
        return this.catchBatchDao.loadSortingBatch(sortingBatchId, parentCatchBatch);
    }

    public void update(CatchBatch catchBatch) {
        this.catchBatchDao.update(catchBatch);
    }

    public void setSortingBatchReferenceTaxon(String batchId, Integer referenceTaxonId) {
        this.catchBatchDao.setSortingBatchReferenceTaxon(batchId, referenceTaxonId);
    }

    public SortingBatch getSortingBatchById(CatchBatch catchBatch, Integer sortingBatchId) {
        return this.catchBatchDao.getSortingBatchById(catchBatch, sortingBatchId);
    }

    public void updateSortingBatch(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
        this.catchBatchDao.updateSortingBatch(sortingBatch, parentCatchBatch);
    }

    public SortingMeasurement getInheritedSortingMeasurement(SortingBatch sortingBatch) {
        return this.catchBatchDao.getInheritedSortingMeasurement(sortingBatch, this.enumeration.PMFM_ID_SORTED_UNSORTED);
    }

    public QuantificationMeasurement setWeightMeasurementQuantificationMeasurement(Batch batch, Float weightValue) {
        return this.catchBatchDao.setQuantificationMeasurement(batch, this.enumeration.PMFM_ID_WEIGHT_MEASURED, this.getRecorderDepartmentId(), weightValue, true);
    }

    public List<SortingBatch> getFrequencyChilds(SampleCategoryModel sampleCategoryModel, SortingBatch sortingBatch) {
        ArrayList result = Lists.newArrayList();
        for (Batch batch : sortingBatch.getChildBatchs()) {
            SortingBatch child = (SortingBatch)batch;
            if (!this.isFrequencyBatch(sampleCategoryModel, child)) continue;
            result.add(child);
        }
        return result;
    }

    public List<SortingBatch> getFrequencies(SampleCategoryModel sampleCategoryModel, String batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Integer sortingBatchId = Integer.valueOf(batchId);
        CatchBatch catchBatch = this.getRootCatchBatchByBatchId(sortingBatchId);
        SortingBatch sortingBatch = this.catchBatchDao.getSortingBatchById(catchBatch, sortingBatchId);
        List<SortingBatch> frequencyChilds = this.getFrequencyChilds(sampleCategoryModel, sortingBatch);
        return frequencyChilds;
    }

    public CatchBatch getRootCatchBatchByFishingOperationId(String fishingOperationId, boolean validate) {
        CatchBatch result;
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(Integer.valueOf(fishingOperationId));
        Preconditions.checkNotNull((Object)catchBatchId);
        if (validate) {
            try {
                result = this.catchBatchDao.loadFullTree(catchBatchId, true, false);
            }
            catch (CatchBatchValidationException e) {
                throw new InvalidBatchModelException("L'arbre d'\u00e9chantillonage n'est pas compatible avec celui de Tutti.", e);
            }
        } else {
            result = this.catchBatchDao.loadFullTree(catchBatchId);
        }
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public boolean isCatchBatchExistsForFishingOperation(Integer fishingOperationId) {
        return this.catchBatchDao.isCatchBatchExistsForFishingOperation(fishingOperationId);
    }

    public Integer getCatchBatchIdByFishingOperationId(Integer fishingOperationId) throws DataRetrievalFailureException {
        return this.catchBatchDao.getIdByFishingOperationId(fishingOperationId);
    }

    public CatchBatch getRootCatchBatchByBatchId(Integer batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(batchId);
        Preconditions.checkNotNull((Object)catchBatchId);
        CatchBatch result = this.catchBatchDao.loadFullTree(catchBatchId);
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public void setSpeciesBatchParents(Integer sampleCategoryId, Serializable sampleCategoryValue, SortingBatch target, String parentBatchIdStr, CatchBatch catchBatch) {
        SortingBatch parentBatch;
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)catchBatch);
        target.setRootBatch(catchBatch);
        if (parentBatchIdStr != null) {
            parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(parentBatchIdStr));
        } else {
            if (!sampleCategoryId.equals(this.enumeration.PMFM_ID_SORTED_UNSORTED)) {
                throw new DataIntegrityViolationException(MessageFormat.format("A species or benthos batch with no parent should have a sampleCategoryType {0} (PMFM.ID={1})", sampleCategoryId, this.enumeration.PMFM_ID_SORTED_UNSORTED));
            }
            Integer qualitativeValueId = this.convertSampleCategoryValueIntoQualitativeId(sampleCategoryValue);
            if (this.enumeration.QUALITATIVE_VRAC_ID.equals(qualitativeValueId)) {
                parentBatch = this.getSortingBatch((Batch)catchBatch, "Vrac > Species > Alive Itemized", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED);
                if (parentBatch == null) {
                    SortingBatch vracSpeciesBatch;
                    SortingBatch vracBatch = this.getSortingBatch((Batch)catchBatch, "Vrac", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID);
                    if (vracBatch == null) {
                        vracBatch = this.getOrCreateVracBatch(catchBatch, null, null);
                    }
                    if ((vracSpeciesBatch = this.getSortingBatch((Batch)vracBatch, "Vrac > Species", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES)) == null) {
                        vracSpeciesBatch = this.getOrCreateSpeciesVracRootBatch(catchBatch, vracBatch, null);
                    }
                    parentBatch = this.getOrCreateSpeciesVracAliveItemizeRootBatch(catchBatch, vracSpeciesBatch);
                }
            } else if (this.enumeration.QUALITATIVE_HORS_VRAC_ID.equals(qualitativeValueId)) {
                parentBatch = this.getSortingBatch((Batch)catchBatch, "Hors vrac > Species", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
                if (parentBatch == null) {
                    SortingBatch horsVracBatch = this.getOrCreateHorsVracBatch(catchBatch);
                    parentBatch = this.getOrCreateSpeciesHorsVracRootBatch(catchBatch, horsVracBatch);
                }
            } else {
                throw new DataIntegrityViolationException("Should have Vrac / Hor Vrac qualitative value, but had: " + qualitativeValueId);
            }
        }
        Preconditions.checkNotNull((Object)parentBatch);
        target.setParentBatch((Batch)parentBatch);
    }

    public void setBenthosBatchParents(Integer sampleCategoryType, Serializable sampleCategoryValue, SortingBatch target, String parentBatchIdStr, CatchBatch catchBatch) {
        SortingBatch parentBatch;
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)catchBatch);
        target.setRootBatch(catchBatch);
        if (parentBatchIdStr != null) {
            parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(parentBatchIdStr));
        } else {
            if (!sampleCategoryType.equals(this.enumeration.PMFM_ID_SORTED_UNSORTED)) {
                throw new DataIntegrityViolationException(MessageFormat.format("A species or benthos batch with no parent should have a sampleCategoryType {0} (PMFM.ID={1})", sampleCategoryType, this.enumeration.PMFM_ID_SORTED_UNSORTED));
            }
            Integer qualitativeValueId = this.convertSampleCategoryValueIntoQualitativeId(sampleCategoryValue);
            if (this.enumeration.QUALITATIVE_VRAC_ID.equals(qualitativeValueId)) {
                parentBatch = this.getSortingBatch((Batch)catchBatch, "Vrac > Species > Alive Itemized", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED);
                if (parentBatch == null) {
                    SortingBatch vracBenthosBatch;
                    SortingBatch vracBatch = this.getSortingBatch((Batch)catchBatch, "Vrac", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID);
                    if (vracBatch == null) {
                        vracBatch = this.getOrCreateVracBatch(catchBatch, null, null);
                    }
                    if ((vracBenthosBatch = this.getSortingBatch((Batch)vracBatch, "Vrac > Benthos", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS)) == null) {
                        vracBenthosBatch = this.getOrCreateBenthosVracRootBatch(catchBatch, vracBatch, null);
                    }
                    parentBatch = this.getOrCreateBenthosVracAliveItemizeRootBatch(catchBatch, vracBenthosBatch);
                }
            } else if (this.enumeration.QUALITATIVE_HORS_VRAC_ID.equals(qualitativeValueId)) {
                parentBatch = this.getSortingBatch((Batch)catchBatch, "Hors vrac > Benthos", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS);
                if (parentBatch == null) {
                    SortingBatch horsVracBatch = this.getOrCreateHorsVracBatch(catchBatch);
                    parentBatch = this.getOrCreateBenthosHorsVracRootBatch(catchBatch, horsVracBatch);
                }
            } else {
                throw new DataIntegrityViolationException("Should have Vrac / Hors Vrac qualitative value, but had: " + qualitativeValueId);
            }
        }
        Preconditions.checkNotNull((Object)parentBatch);
        target.setParentBatch((Batch)parentBatch);
    }

    public Integer convertSampleCategoryValueIntoQualitativeId(Serializable value) {
        if (value == null) {
            return null;
        }
        Integer qualitativeValueId = null;
        if (value instanceof CaracteristicQualitativeValue) {
            CaracteristicQualitativeValue cqValue = (CaracteristicQualitativeValue)value;
            qualitativeValueId = cqValue.getIdAsInt();
        } else if (value instanceof String) {
            qualitativeValueId = Integer.valueOf((String)((Object)value));
        }
        return qualitativeValueId;
    }

    public SortingBatch getSortingBatch(Batch source, String debugMessage, Integer ... ids) {
        return this.getSortingBatch(source.getChildBatchs(), debugMessage, ids);
    }

    public SortingBatch getSortingBatch(Collection<Batch> childs, String debugMessage, Integer ... ids) {
        int nbParams = ids.length / 2;
        Object[] params = new Object[nbParams * 3];
        for (int i = 0; i < nbParams; ++i) {
            Integer sortingPmfmId = ids[2 * i];
            Integer sortingQualitativeValueId = ids[2 * i + 1];
            params[3 * i] = "pmfmId";
            params[3 * i + 1] = sortingPmfmId;
            params[3 * i + 2] = sortingQualitativeValueId;
        }
        SortingBatch result = this.catchBatchDao.getSortingBatch(childs, params);
        if (result != null && debugMessage != null && log.isDebugEnabled()) {
            log.debug((Object)("Loaded " + debugMessage + ": " + result.getId()));
        }
        return result;
    }

    public SortingBatch getVracBatch(CatchBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID);
    }

    public SortingBatch getOrCreateVracBatch(CatchBatch batch, Float weight, Float weightBeforeSampling) {
        return this.getOrCreate(batch, (Batch)batch, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, weight, weightBeforeSampling, (short)1);
    }

    public SortingBatch getSpeciesVracRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
    }

    public SortingBatch getOrCreateSpeciesVracRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES, totalWeight, (short)1);
    }

    public SortingBatch getSpeciesVracAliveNotItemizeRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED);
    }

    public SortingBatch getOrCreateSpeciesVracAliveNotItemizeRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED, totalWeight, (short)1);
    }

    public SortingBatch getSpeciesVracInertRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT);
    }

    public SortingBatch getOrCreateSpeciesVracInertRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT, totalWeight, (short)2);
    }

    public SortingBatch getSpeciesVracAliveItemizeRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED);
    }

    public SortingBatch getOrCreateSpeciesVracAliveItemizeRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED, null, (short)3);
    }

    public SortingBatch getBenthosVracRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS);
    }

    public SortingBatch getOrCreateBenthosVracRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS, totalWeight, (short)2);
    }

    public SortingBatch getBenthosVracAliveNotItemizeRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED);
    }

    public SortingBatch getOrCreateBenthosVracAliveNotItemizeRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED, totalWeight, (short)1);
    }

    public SortingBatch getBenthosVracInertRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT);
    }

    public SortingBatch getOrCreateBenthosVracInertRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT, totalWeight, (short)2);
    }

    public SortingBatch getBenthosVracAliveItemizeRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED);
    }

    public SortingBatch getOrCreateBenthosVracAliveItemizeRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED, null, (short)3);
    }

    public SortingBatch getHorsVracBatch(CatchBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID);
    }

    public SortingBatch getOrCreateHorsVracBatch(CatchBatch batch) {
        return this.getOrCreate(batch, (Batch)batch, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, null, (short)2);
    }

    public SortingBatch getSpeciesHorsVracRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
    }

    public SortingBatch getOrCreateSpeciesHorsVracRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES, null, (short)1);
    }

    public SortingBatch getBenthosHorsVracRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS);
    }

    public SortingBatch getOrCreateBenthosHorsVracRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS, null, (short)2);
    }

    public SortingBatch getMarineLitterRootBatch(SortingBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_MARINE_LITTER);
    }

    public SortingBatch getOrCreateMarineLitterRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_MARINE_LITTER, totalWeight, (short)3);
    }

    public SortingBatch getRejectedBatch(CatchBatch batch) {
        return this.get((Batch)batch, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID);
    }

    public SortingBatch getOrCreateRejectedBatch(CatchBatch batch, Float weight) {
        return this.getOrCreate(batch, (Batch)batch, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID, weight, (short)3);
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer pmfmId, Serializable value) {
        Preconditions.checkNotNull((Object)pmfmId);
        Preconditions.checkNotNull((Object)value);
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.catchBatchDao.getSortingMeasurement(sortingBatch, pmfmId, this.getRecorderDepartmentId(), true);
        this.measurementPersistenceHelper.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }

    public Serializable getSampleCategoryQualitative(Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (numericalvalue != null) {
            return numericalvalue;
        }
        if (alphanumericalValue != null) {
            return alphanumericalValue;
        }
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        if (caracteristic == null || caracteristic.getCaracteristicType() != CaracteristicType.QUALITATIVE) {
            return null;
        }
        CaracteristicQualitativeValue value = null;
        for (CaracteristicQualitativeValue qv : caracteristic.getQualitativeValue()) {
            if (!qualitativeValueId.equals(qv.getIdAsInt())) continue;
            value = qv;
            break;
        }
        return value;
    }

    protected Integer getRecorderDepartmentId() {
        return this.enumeration.DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT;
    }

    public boolean isFrequencyBatch(SampleCategoryModel sampleCategoryModel, SortingBatch sortingBatch) {
        boolean result = false;
        if (sortingBatch.getSortingMeasurements().size() == 1) {
            SortingMeasurement sm = (SortingMeasurement)sortingBatch.getSortingMeasurements().iterator().next();
            Pmfm pmfm = sm.getPmfm();
            result = sortingBatch.getIndividualCount() != null && !sampleCategoryModel.containsCategoryId(pmfm.getId());
        }
        return result;
    }

    protected SortingBatch getOrCreate(CatchBatch target, Batch batch, Integer pmfmId, Integer pmfmValue, Float totalWeight, short rankOrder) {
        return this.getOrCreate(target, batch, pmfmId, pmfmValue, totalWeight, null, rankOrder);
    }

    protected SortingBatch getOrCreate(CatchBatch rootBatch, Batch parentBatch, Integer sortingPmfmId, Integer sortingQualitativeValueId, Float weight, Float weightBeforeSampling, short rankOrder) {
        SortingBatch result = this.get(parentBatch, sortingPmfmId, sortingQualitativeValueId);
        if (result == null) {
            result = SortingBatch.Factory.newInstance();
            if (parentBatch.getChildBatchs() == null) {
                parentBatch.setChildBatchs((Collection)Sets.newHashSet());
            }
            parentBatch.getChildBatchs().add(result);
            Collection sortingMeasurements = result.getSortingMeasurements();
            HashSet notChangedSortingMeasurements = Sets.newHashSet();
            if (sortingMeasurements != null) {
                notChangedSortingMeasurements.addAll(sortingMeasurements);
            }
            QualityFlagImpl qualityFlag = this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED));
            result.setQualityFlag((QualityFlag)qualityFlag);
            result.setRootBatch(rootBatch);
            result.setParentBatch(parentBatch);
            result.setExhaustiveInventory(Boolean.valueOf(true));
            result.setReferenceTaxon(null);
            result.setTaxonGroup(null);
            result.setRankOrder(Short.valueOf(rankOrder));
            if (sortingPmfmId != null && sortingQualitativeValueId != null) {
                SortingMeasurement sm = this.setSortingMeasurement(result, sortingPmfmId, sortingQualitativeValueId);
                notChangedSortingMeasurements.remove(sm);
            }
            if (sortingMeasurements != null) {
                sortingMeasurements.removeAll(notChangedSortingMeasurements);
            }
            this.catchBatchDao.createSortingBatch(result, rootBatch);
        }
        Collection quantificationMeasurements = result.getQuantificationMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        if (weightBeforeSampling == null || weight == null) {
            result.setSamplingRatio(null);
            result.setSamplingRatioText(null);
        } else {
            String samplingRatioText = weight + "/" + weightBeforeSampling;
            samplingRatioText = samplingRatioText.replaceAll(",", ".");
            result.setSamplingRatioText(samplingRatioText);
            result.setSamplingRatio(Float.valueOf(weight.floatValue() / weightBeforeSampling.floatValue()));
        }
        if (weightBeforeSampling != null || weight != null) {
            Float batchReferenceWeight = weight;
            if (batchReferenceWeight == null) {
                batchReferenceWeight = weightBeforeSampling;
            }
            QuantificationMeasurement quantificationMeasurement = this.setWeightMeasurementQuantificationMeasurement((Batch)result, batchReferenceWeight);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        return result;
    }

    protected SortingBatch get(Batch parentBatch, Integer sortingPmfmId, Integer sortingQualitativeValueId) {
        SortingBatch result = this.getSortingBatch(parentBatch, null, sortingPmfmId, sortingQualitativeValueId);
        return result;
    }
}

