/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.rmi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.nuiton.util.rmi.RemoteMethodExecutor;

public class RemoteMethodExecutorImpl<T>
implements RemoteMethodExecutor {
    protected T service;

    public RemoteMethodExecutorImpl(T service) {
        if (service == null) {
            throw new NullPointerException("Service cannot be null");
        }
        this.service = service;
    }

    @Override
    public Object execute(String methodName, Class<?>[] parametersType, Object[] args) throws RemoteException {
        Object result;
        try {
            Method method = this.service.getClass().getMethod(methodName, parametersType);
            result = method.invoke(this.service, args);
        }
        catch (InvocationTargetException ite) {
            Throwable targetException = ite.getTargetException();
            throw new RemoteException("Business exception occurred", targetException);
        }
        catch (NoSuchMethodException nsme) {
            throw new RemoteException("Delegate method not found", nsme);
        }
        catch (IllegalAccessException iae) {
            throw new RemoteException("Delegate method not accessible", iae);
        }
        return result;
    }
}

