/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.structure.Column;
import liquibase.database.structure.Table;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddDefaultValueGenerator;
import liquibase.statement.core.AddDefaultValueStatement;

public class AddDefaultValueGeneratorInformix
extends AddDefaultValueGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(AddDefaultValueStatement statement, Database database) {
        return database instanceof InformixDatabase;
    }

    public ValidationErrors validate(AddDefaultValueStatement addDefaultValueStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = super.validate(addDefaultValueStatement, database, sqlGeneratorChain);
        if (addDefaultValueStatement.getColumnDataType() == null) {
            validationErrors.checkRequiredField("columnDataType", addDefaultValueStatement.getColumnDataType());
        }
        return validationErrors;
    }

    public Sql[] generateSql(AddDefaultValueStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Column column = new Column().setTable(new Table(statement.getTableName()).setSchema(statement.getSchemaName())).setName(statement.getColumnName());
        Object defaultValue = statement.getDefaultValue();
        StringBuffer sql = new StringBuffer("ALTER TABLE ");
        sql.append(database.escapeTableName(statement.getSchemaName(), statement.getTableName()));
        sql.append(" MODIFY (");
        sql.append(database.escapeColumnName(statement.getSchemaName(), statement.getTableName(), statement.getColumnName()));
        sql.append(" ");
        sql.append(TypeConverterFactory.getInstance().findTypeConverter(database).getDataType(statement.getColumnDataType(), false));
        sql.append(" DEFAULT ");
        sql.append(TypeConverterFactory.getInstance().findTypeConverter(database).getDataType(defaultValue).convertObjectToString(defaultValue, database));
        sql.append(")");
        UnparsedSql unparsedSql = new UnparsedSql(sql.toString(), column);
        return new Sql[]{unparsedSql};
    }
}

