/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.util.Locale;
import liquibase.database.Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.structure.type.BlobType;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.ClobType;
import liquibase.database.structure.type.CurrencyType;
import liquibase.database.structure.type.CustomType;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.structure.type.FloatType;
import liquibase.database.structure.type.IntType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;

public class SQLiteTypeConverter
extends AbstractTypeConverter {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof SQLiteDatabase;
    }

    public DataType getDataType(String columnTypeString, Boolean autoIncrement) {
        DataType type = columnTypeString.equals("INTEGER") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("int") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("bit") ? new IntType("INTEGER") : (columnTypeString.equals("TEXT") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("uuid") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("uniqueidentifier") || columnTypeString.toLowerCase(Locale.ENGLISH).equals("uniqueidentifier") || columnTypeString.toLowerCase(Locale.ENGLISH).equals("datetime") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("timestamp") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("char") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("clob") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("text") ? new CustomType("TEXT", 0, 0) : (columnTypeString.equals("REAL") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("float") ? new FloatType("REAL") : (columnTypeString.toLowerCase(Locale.ENGLISH).contains("blob") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("binary") ? new BlobType("BLOB") : (columnTypeString.toLowerCase(Locale.ENGLISH).contains("boolean") || columnTypeString.toLowerCase(Locale.ENGLISH).contains("binary") ? new BooleanType("BOOLEAN") : super.getDataType(columnTypeString, autoIncrement)))));
        return type;
    }

    public BooleanType getBooleanType() {
        return new BooleanType(){

            public String getFalseBooleanValue() {
                return "0";
            }

            public String getTrueBooleanValue() {
                return "1";
            }
        };
    }

    public ClobType getClobType() {
        return new ClobType("TEXT");
    }

    public CurrencyType getCurrencyType() {
        return new CurrencyType("REAL");
    }

    public DateTimeType getDateTimeType() {
        return new DateTimeType("TEXT");
    }
}

