/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.database.Database;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogParameters {
    private List<ChangeLogParameter> changeLogParameters = new ArrayList<ChangeLogParameter>();
    private ExpressionExpander expressionExpander;
    private Database currentDatabase;
    private List<String> currentContexts;

    public ChangeLogParameters() {
        this(null);
    }

    public ChangeLogParameters(Database currentDatabase) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            this.changeLogParameters.add(new ChangeLogParameter(entry.getKey().toString(), entry.getValue()));
        }
        this.expressionExpander = new ExpressionExpander(this);
        this.currentDatabase = currentDatabase;
        this.currentContexts = new ArrayList<String>();
    }

    public void addContext(String context) {
        this.currentContexts.add(context);
    }

    public void setContexts(Collection<String> contexts) {
        this.currentContexts = new ArrayList<String>();
        if (contexts != null) {
            this.currentContexts.addAll(contexts);
        }
    }

    public void set(String paramter, Object value) {
        this.changeLogParameters.add(new ChangeLogParameter(paramter, value));
    }

    public void set(String key, String value, String contexts, String databases) {
        this.changeLogParameters.add(new ChangeLogParameter(key, (Object)value, contexts, databases));
    }

    public Object getValue(String key) {
        ChangeLogParameter parameter = this.findParameter(key);
        return parameter != null ? parameter.getValue() : null;
    }

    private ChangeLogParameter findParameter(String key) {
        for (ChangeLogParameter param : this.changeLogParameters) {
            if (!param.getKey().equalsIgnoreCase(key) || !param.isValid()) continue;
            return param;
        }
        return null;
    }

    public boolean hasValue(String key) {
        return this.findParameter(key) != null;
    }

    public String expandExpressions(String string) {
        return this.expressionExpander.expandExpressions(string);
    }

    protected static class ExpressionExpander {
        private ChangeLogParameters changeLogParameters;

        public ExpressionExpander(ChangeLogParameters changeLogParameters) {
            this.changeLogParameters = changeLogParameters;
        }

        public String expandExpressions(String text) {
            if (text == null) {
                return null;
            }
            Pattern expressionPattern = Pattern.compile("(\\$\\{[^\\}]+\\})");
            Matcher matcher = expressionPattern.matcher(text);
            String originalText = text;
            while (matcher.find()) {
                String expressionString = originalText.substring(matcher.start(), matcher.end());
                String valueTolookup = expressionString.replaceFirst("\\$\\{", "").replaceFirst("\\}$", "");
                int dotIndex = valueTolookup.indexOf(46);
                Object value = this.changeLogParameters.getValue(valueTolookup);
                if (value == null) continue;
                text = text.replace(expressionString, value.toString());
            }
            return text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChangeLogParameter {
        private String key;
        private Object value;
        private List<String> validContexts;
        private List<String> validDatabases;

        public ChangeLogParameter(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public ChangeLogParameter(String key, Object value, String validContexts, String validDatabases) {
            this(key, value, StringUtils.splitAndTrim(validContexts, ","), StringUtils.splitAndTrim(validDatabases, ","));
        }

        public ChangeLogParameter(String key, Object value, List<String> validContexts, List<String> validDatabases) {
            this.key = key;
            this.value = value;
            this.validContexts = validContexts;
            this.validDatabases = validDatabases;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public List<String> getValidDatabases() {
            return this.validDatabases;
        }

        public List<String> getValidContexts() {
            return this.validContexts;
        }

        public String toString() {
            return this.getValue().toString();
        }

        public boolean isValid() {
            boolean isValid = true;
            if (this.validContexts != null && this.validContexts.size() > 0 && ChangeLogParameters.this.currentContexts != null && ChangeLogParameters.this.currentContexts.size() > 0) {
                isValid = false;
                for (String currentContext : ChangeLogParameters.this.currentContexts) {
                    if (!this.validContexts.contains(currentContext)) continue;
                    isValid = true;
                }
            }
            if (isValid && this.validDatabases != null && this.validDatabases.size() > 0) {
                isValid = this.validDatabases.contains(ChangeLogParameters.this.currentDatabase.getTypeName());
            }
            return isValid;
        }
    }
}

