/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.Date;
import liquibase.change.AbstractChange;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.structure.Index;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropDefaultValueStatement;
import liquibase.util.StringUtils;

public class DropDefaultValueChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnDataType;

    public DropDefaultValueChange() {
        super("dropDefaultValue", "Drop Default Value", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropDefaultValueStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), this.getColumnName(), this.getColumnDataType())};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                if (column.getName().equals(DropDefaultValueChange.this.getColumnName())) {
                    column.setDefaultValue(null);
                    column.setDefaultValueBoolean(null);
                    column.setDefaultValueDate((Date)null);
                    column.setDefaultValueNumeric((Number)null);
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    public String getConfirmationMessage() {
        return "Default value dropped from " + this.getTableName() + "." + this.getColumnName();
    }
}

