/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.change.TextNode;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.util.StringUtils;

public class DeleteDataChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    @TextNode(nodeName="where")
    private String whereClause;

    public DeleteDataChange() {
        super("delete", "Delete Data", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public SqlStatement[] generateStatements(Database database) {
        DeleteStatement statement = new DeleteStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName());
        statement.setWhereClause(this.whereClause);
        return new SqlStatement[]{statement};
    }

    public String getConfirmationMessage() {
        return "Data deleted from " + this.getTableName();
    }
}

