/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.util;

import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.component.impl.CurveFittingImpl;
import org.eclipse.birt.chart.model.component.impl.DialRegionImpl;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.component.impl.MarkerLineImpl;
import org.eclipse.birt.chart.model.component.impl.MarkerRangeImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.impl.DialChartImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.BubbleSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.DifferenceSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.GanttSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.StockSeriesImpl;

public class DefaultValueProvider {
    private static final ChartWithAxes defChartWithAxes = DefaultValueProvider.createChartWithAxes();
    private static final TitleBlock defTitleBlock = DefaultValueProvider.getTitleBlock(defChartWithAxes);
    private static final Plot defPlot = DefaultValueProvider.getPlot(defChartWithAxes);
    private static final Legend defLegend = DefaultValueProvider.getLegend(defChartWithAxes);
    private static final Series defSeries = SeriesImpl.create();
    private static final GanttSeries defGanttSeries = (GanttSeries)GanttSeriesImpl.create();
    private static final ScatterSeries defScatterSeries = (ScatterSeries)ScatterSeriesImpl.create();
    private static final DialSeries defDialSeries = (DialSeries)DialSeriesImpl.create();
    private static final PieSeries defPieSeries;
    private static final DifferenceSeries defDifferenceSeries;
    private static final StockSeries defStockSeries;
    private static final LineSeries defLineSeries;
    private static final AreaSeries defAreaSeries;
    private static final BarSeries defBarSeries;
    private static final BubbleSeries defBubbleSeries;
    private static final Axis defBaseAxis;
    private static final Axis defOrthAxis;
    private static final Axis defAncillaryAxis;
    private static final Insets defLabelInsets;
    private static final Label defLabel;
    private static final DefSeriesDefinitionPool defSeriesDefinitions;
    private static ChartWithoutAxes defChartWithoutAxes;
    private static DialChart defDialChart;
    private static JavaNumberFormatSpecifier percentileValueFS;

    static {
        defDialSeries.getDial().getDialRegions().add((Object)DialRegionImpl.create());
        defPieSeries = (PieSeries)PieSeriesImpl.create();
        defDifferenceSeries = (DifferenceSeries)DifferenceSeriesImpl.create();
        defStockSeries = (StockSeries)StockSeriesImpl.create();
        defLineSeries = (LineSeries)LineSeriesImpl.create();
        defAreaSeries = (AreaSeries)AreaSeriesImpl.create();
        defBarSeries = (BarSeries)BarSeriesImpl.create();
        defBubbleSeries = (BubbleSeries)BubbleSeriesImpl.create();
        defSeries.setCurveFitting(CurveFittingImpl.create());
        defGanttSeries.setCurveFitting(CurveFittingImpl.create());
        defScatterSeries.setCurveFitting(CurveFittingImpl.create());
        defStockSeries.setCurveFitting(CurveFittingImpl.create());
        defLineSeries.setCurveFitting(CurveFittingImpl.create());
        defAreaSeries.setCurveFitting(CurveFittingImpl.create());
        defBarSeries.setCurveFitting(CurveFittingImpl.create());
        defBubbleSeries.setCurveFitting(CurveFittingImpl.create());
        defBaseAxis = (Axis)defChartWithAxes.getAxes().get(0);
        defOrthAxis = (Axis)defBaseAxis.getAssociatedAxes().get(0);
        defAncillaryAxis = (Axis)defBaseAxis.getAncillaryAxes().get(0);
        defLabelInsets = InsetsImpl.create(0.0, 2.0, 0.0, 3.0);
        defLabel = LabelImpl.create();
        defSeriesDefinitions = new DefSeriesDefinitionPool();
        defChartWithoutAxes = DefaultValueProvider.createChartWithoutAxes();
        defDialChart = DefaultValueProvider.createDialChart();
        percentileValueFS = JavaNumberFormatSpecifierImpl.create("##.##%");
    }

    public static ChartWithAxes defChartWithAxes() {
        return defChartWithAxes;
    }

    public static ChartWithoutAxes defChartWithoutAxes() {
        return defChartWithoutAxes;
    }

    public static DialChart defDialChart() {
        return defDialChart;
    }

    public static TitleBlock defTitleBlock() {
        return defTitleBlock;
    }

    public static Plot defPlot() {
        return defPlot;
    }

    public static Legend defLegend() {
        return defLegend;
    }

    public static SeriesDefinition defSeriesDefinition(int id) {
        return defSeriesDefinitions.get(id);
    }

    public static Series defSeries() {
        return defSeries;
    }

    public static Axis defBaseAxis() {
        return defBaseAxis;
    }

    public static Axis defOrthogonalAxis() {
        return defOrthAxis;
    }

    public static Axis defAncillaryAxis() {
        return defAncillaryAxis;
    }

    public static GanttSeries defGanttSeries() {
        return defGanttSeries;
    }

    public static ScatterSeries defScatterSeries() {
        return defScatterSeries;
    }

    public static DialSeries defDialSeries() {
        return defDialSeries;
    }

    public static PieSeries defPieSeries() {
        return defPieSeries;
    }

    public static DifferenceSeries defDifferenceSeries() {
        return defDifferenceSeries;
    }

    public static StockSeries defStockSeries() {
        return defStockSeries;
    }

    public static LineSeries defLineSeries() {
        return defLineSeries;
    }

    public static AreaSeries defAreaSeries() {
        return defAreaSeries;
    }

    public static BarSeries defBarSeries() {
        return defBarSeries;
    }

    public static BubbleSeries defBubbleSeries() {
        return defBubbleSeries;
    }

    private static ChartWithAxes createChartWithAxes() {
        ChartWithAxes newChart = ChartWithAxesImpl.create();
        newChart.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        newChart.setOrientation(Orientation.VERTICAL_LITERAL);
        newChart.getTitle().getLabel().getCaption().setValue(Messages.getString("DefaultValueProvider_ChartTitle"));
        Axis axBase = (Axis)newChart.getAxes().get(0);
        axBase.getMarkerLines().add((Object)MarkerLineImpl.create(axBase, null));
        axBase.getMarkerRanges().add((Object)MarkerRangeImpl.create(axBase, null, null, ColorDefinitionImpl.TRANSPARENT(), ColorDefinitionImpl.RED()));
        axBase.setCategoryAxis(true);
        axBase.getSeriesDefinitions().add((Object)DefaultValueProvider.createSeriesDefinition(0));
        axBase.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
        Axis axOrth = (Axis)axBase.getAssociatedAxes().get(0);
        axOrth.getMarkerLines().add((Object)MarkerLineImpl.create(axOrth, null));
        axOrth.getMarkerRanges().add((Object)MarkerRangeImpl.create(axOrth, null, null, ColorDefinitionImpl.TRANSPARENT(), ColorDefinitionImpl.RED()));
        axOrth.getSeriesDefinitions().add((Object)DefaultValueProvider.createSeriesDefinition(0));
        axOrth.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
        DefaultValueProvider.createAncillaryAxis(newChart);
        return newChart;
    }

    private static Axis createAncillaryAxis(ChartWithAxes chart) {
        chart.setRotation(Rotation3DImpl.create(new Angle3D[]{Angle3DImpl.create(-20.0, 45.0, 0.0)}));
        chart.setUnitSpacing(50.0);
        Axis zAxisAncillary = AxisImpl.create(3);
        zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
        zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
        zAxisAncillary.getTitle().setVisible(false);
        zAxisAncillary.setPrimaryAxis(true);
        zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
        zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
        zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        zAxisAncillary.getOrigin().setValue(NumberDataElementImpl.create(0.0));
        zAxisAncillary.setType(AxisType.TEXT_LITERAL);
        chart.getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
        SeriesDefinition sdZ = SeriesDefinitionImpl.create();
        sdZ.getSeriesPalette().shift(0);
        sdZ.getSeries().add((Object)SeriesImpl.create());
        zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
        return zAxisAncillary;
    }

    public static Insets defLabelInsets() {
        return defLabelInsets;
    }

    public static Label defLabel() {
        return defLabel;
    }

    private static ChartWithoutAxes createChartWithoutAxes() {
        ChartWithoutAxes newChart = ChartWithoutAxesImpl.create();
        newChart.setSubType(Messages.getString("DefaultValueProvider_ChartSubType.Standard"));
        newChart.getTitle().getLabel().getCaption().setValue(Messages.getString("DefaultValueProvider_ChartTitle"));
        SeriesDefinition sdX = DefaultValueProvider.createSeriesDefinition(0);
        sdX.getQuery().setDefinition(Messages.getString("DefaultValueProvider_BaseSeries"));
        SeriesDefinition sdY = DefaultValueProvider.createSeriesDefinition(0);
        sdX.getSeriesDefinitions().add((Object)sdY);
        newChart.getSeriesDefinitions().add((Object)sdX);
        return newChart;
    }

    private static DialChart createDialChart() {
        DialChart newChart = (DialChart)DialChartImpl.create();
        newChart.setSubType(Messages.getString("DefaultValueProvider_ChartSubType.StandardMeterChart"));
        newChart.setUnits(Messages.getString("DefaultValueProvider_ChartUnits.Points"));
        newChart.setDialSuperimposition(false);
        newChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
        SeriesDefinition sdX = DefaultValueProvider.createSeriesDefinition(0);
        sdX.getQuery().setDefinition(Messages.getString("DefaultValueProvider_BaseSeries"));
        SeriesDefinition sdY = DefaultValueProvider.createSeriesDefinition(0);
        sdX.getSeriesDefinitions().add((Object)sdY);
        newChart.getSeriesDefinitions().add((Object)sdX);
        return newChart;
    }

    private static TitleBlock getTitleBlock(Chart chart) {
        for (Block b : chart.getBlock().getChildren()) {
            if (!(b instanceof TitleBlock)) continue;
            return (TitleBlock)b;
        }
        return null;
    }

    private static Plot getPlot(Chart chart) {
        for (Block b : chart.getBlock().getChildren()) {
            if (!(b instanceof Plot)) continue;
            return (Plot)b;
        }
        return null;
    }

    private static Legend getLegend(Chart chart) {
        for (Block b : chart.getBlock().getChildren()) {
            if (!(b instanceof Legend)) continue;
            return (Legend)b;
        }
        return null;
    }

    protected static SeriesDefinition createSeriesDefinition(int paletteShift) {
        SeriesDefinition sd = SeriesDefinitionImpl.create();
        sd.getSeries().add((Object)SeriesImpl.create());
        sd.getSeriesPalette().shift(paletteShift);
        return sd;
    }

    public static FormatSpecifier defPercentileValueFormatSpecifier() {
        return percentileValueFS;
    }

    public static class DefSeriesDefinitionPool {
        protected int size = 8;
        protected SeriesDefinition[] pool = new SeriesDefinition[]{DefaultValueProvider.createSeriesDefinition(0), DefaultValueProvider.createSeriesDefinition(-1), DefaultValueProvider.createSeriesDefinition(-2), DefaultValueProvider.createSeriesDefinition(-3), DefaultValueProvider.createSeriesDefinition(-4), DefaultValueProvider.createSeriesDefinition(-5), DefaultValueProvider.createSeriesDefinition(-6), DefaultValueProvider.createSeriesDefinition(-7)};

        public SeriesDefinition get(int id) {
            if (id >= this.size) {
                int sizeNew = (id / 4 + 1) * 4;
                SeriesDefinition[] poolNew = new SeriesDefinition[sizeNew];
                System.arraycopy(this.pool, 0, poolNew, 0, this.size);
                int i = this.size;
                while (i < sizeNew) {
                    poolNew[i] = DefaultValueProvider.createSeriesDefinition(-i);
                    ++i;
                }
                this.pool = poolNew;
                this.size = sizeNew;
            }
            return this.pool[id];
        }
    }
}

