package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split;

/*
 * #%L
 * Tutti :: UI
 * $Id: SplitBenthosBatchTableModel.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.2.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/split/SplitBenthosBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SelectedCategoryAble;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n;

/**
 * Table model of sample categories values.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class SplitBenthosBatchTableModel
        extends AbstractApplicationTableModel<SplitBenthosBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<SplitBenthosBatchRowModel> SELECTED = ColumnIdentifier.newId(
            SplitBenthosBatchRowModel.PROPERTY_SELECTED,
            n("tutti.splitBenthosBatch.table.header.selected"),
            n("tutti.splitBenthosBatch.table.header.selected"));

    public static final ColumnIdentifier<SplitBenthosBatchRowModel> EDITABLE_CATEGORY_VALUE = ColumnIdentifier.newId(
            SplitBenthosBatchRowModel.PROPERTY_CATEGORY_VALUE,
            n("tutti.splitBenthosBatch.table.header.category"),
            n("tutti.splitBenthosBatch.table.header.category"));

    public static final ColumnIdentifier<SplitBenthosBatchRowModel> READ_ONLY_CATEGORY_VALUE = ColumnIdentifier.newId(
            SplitBenthosBatchRowModel.PROPERTY_CATEGORY_VALUE,
            n("tutti.splitBenthosBatch.table.header.category"),
            n("tutti.splitBenthosBatch.table.header.category"));

    public static final ColumnIdentifier<SplitBenthosBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            SplitBenthosBatchRowModel.PROPERTY_WEIGHT,
            n("tutti.splitBenthosBatch.table.header.weight"),
            n("tutti.splitBenthosBatch.table.header.weight"));

    private final SelectedCategoryAble uiModel;

    /**
     * Is the table is in split mode?
     *
     * @since 2.6
     */
    private final boolean splitMode;

    public SplitBenthosBatchTableModel(TableColumnModelExt columnModel,
                                       SelectedCategoryAble uiModel,
                                       boolean createEmptyRowIsEmpty,
                                       boolean splitMode) {
        super(columnModel, createEmptyRowIsEmpty, createEmptyRowIsEmpty);
        this.uiModel = uiModel;
        this.splitMode = splitMode;
        setNoneEditableCols(READ_ONLY_CATEGORY_VALUE);
    }

    @Override
    public SplitBenthosBatchRowModel createNewRow() {
        SplitBenthosBatchRowModel result = new SplitBenthosBatchRowModel();
        result.setCategoryType(uiModel.getSelectedCategory());
        result.setValid(false);
        result.setEditable(true);
        return result;
    }

    @Override
    protected boolean isCellEditable(int rowIndex,
                                     int columnIndex,
                                     ColumnIdentifier<SplitBenthosBatchRowModel> propertyName) {

        boolean result = super.isCellEditable(rowIndex,
                                              columnIndex,
                                              propertyName);
        if (result && !splitMode) {
            // if editable and on edit mode, use editable property on row
            SplitBenthosBatchRowModel entry = getEntry(rowIndex);
            result = entry.isEditable();
        }
        return result;
    }
}