package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCruiseFishingOperationAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.2.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/EditCruiseFishingOperationAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import org.nuiton.validator.NuitonValidatorResult;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * To edit the given fishing operation.
 *
 * @author kmorin <morin@codelutin.com>
 * @since 1.4
 */
public class EditCruiseFishingOperationAction extends AbstractTuttiAction<ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {

    /** Validation service. */
    private final ValidateCruiseOperationsService validationService;

    /**
     * The incoming fishing operation to edit.
     * <p/>
     * Can be null (means do not edit any fishing operation), or with no id
     * (means create a ne fishing operation), or with an id (means edit an
     * existing fishing operation).
     */
    protected FishingOperation fishingOperation;

    protected final PropertyChangeListener editFishingOperationModelListener = new PropertyChangeListener() {

        protected final List<String> propertiesToIgnore = Lists.newArrayList(
                EditFishingOperationUIModel.PROPERTY_MODIFY,
                EditFishingOperationUIModel.PROPERTY_VALID,
                EditFishingOperationUIModel.PROPERTY_PERSISTED
        );

        @Override
        public void propertyChange(PropertyChangeEvent evt) {

            EditFishingOperationUIModel model = (EditFishingOperationUIModel) evt.getSource();

            if (!model.isLoadingData()
                && model.getFishingOperation() != null
                && !propertiesToIgnore.contains(evt.getPropertyName())) {

                model.convertGearShootingCoordinatesToDD();

                FishingOperation operation = model.toBean();
                NuitonValidatorResult validationResult = validationService.validateCruiseOperation(operation);

                ValidateCruiseUIModel uiModel = getModel();
                uiModel.getValidator().put(uiModel.getSelectedFishingOperation(), validationResult);

                getHandler().updateCurrentOperationNode(validationResult);

            }
        }
    };

    protected final PropertyChangeListener editCatchesModelListener = new PropertyChangeListener() {

        protected final List<String> propertiesToIgnore = Lists.newArrayList(
                EditCatchesUIModel.PROPERTY_MODIFY,
                EditCatchesUIModel.PROPERTY_VALID,
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_UNSORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_CATCH_TOTAL_REJECTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_UNSORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_INERT_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_UNSORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_INERT_COMPUTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_COMPUTED_WEIGHT
        );

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditCatchesUIModel model = (EditCatchesUIModel) evt.getSource();

            if (!model.isLoadingData()
                && model.getFishingOperation() != null
                && !propertiesToIgnore.contains(evt.getPropertyName())) {

                CatchBatch catchBatch = model.toBean();
                NuitonValidatorResult validationResult = validationService.validateCruiseOperation(catchBatch);

                ValidateCruiseUIModel uiModel = getModel();
                uiModel.getValidator().put(uiModel.getSelectedFishingOperation(), validationResult);

                getHandler().updateCurrentOperationNode(validationResult);
            }
        }
    };

    public EditCruiseFishingOperationAction(ValidateCruiseUIHandler handler) {
        super(handler, true);
        setActionDescription(t("tutti.editFishingOperation.action.editFishingOperation.tip"));
        validationService = getContext().getValidateCruiseOperationsService();
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    @Override
    public boolean prepareAction() throws Exception {
        FishingOperationsUI operationPanel = getUI().getOperationPanel();
        operationPanel.getFishingOperationTabContent().getModel().
                removePropertyChangeListener(editFishingOperationModelListener);
        operationPanel.getCatchesTabContent().getModel().
                removePropertyChangeListener(editCatchesModelListener);

        return super.prepareAction();
    }

    @Override
    public void doAction() throws Exception {
        getUI().getOperationPanel().getModel().setSelectedFishingOperation(fishingOperation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        FishingOperationsUI operationPanel = getUI().getOperationPanel();
        operationPanel.getFishingOperationTabContent().getModel().addPropertyChangeListener(editFishingOperationModelListener);
        operationPanel.getCatchesTabContent().getModel().addPropertyChangeListener(editCatchesModelListener);
    }

    @Override
    public void releaseAction() {
        super.releaseAction();
        fishingOperation = null;
    }
}
