/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.Writer;
import java.util.Date;
import liquibase.Liquibase;
import liquibase.integration.ant.BaseLiquibaseTask;
import org.apache.tools.ant.BuildException;

public class DatabaseRollbackTask
extends BaseLiquibaseTask {
    private Date rollbackDate;
    private String rollbackTag;
    private Integer rollbackCount;

    public Date getRollbackDate() {
        if (this.rollbackDate == null) {
            return null;
        }
        return (Date)this.rollbackDate.clone();
    }

    public void setRollbackDate(Date rollbackDate) {
        if (rollbackDate != null) {
            this.rollbackDate = new Date(rollbackDate.getTime());
        }
    }

    public String getRollbackTag() {
        return this.rollbackTag;
    }

    public void setRollbackTag(String rollbackTag) {
        this.rollbackTag = rollbackTag;
    }

    public Integer getRollbackCount() {
        return this.rollbackCount;
    }

    public void setRollbackCount(Integer rollbackCount) {
        this.rollbackCount = rollbackCount;
    }

    @Override
    public void executeWithLiquibaseClassloader() throws BuildException {
        if (this.getRollbackDate() == null && this.getRollbackCount() == null && this.getRollbackTag() == null) {
            throw new BuildException("rollbackDatabase requires rollbackTag, rollbackDate, or rollbackCount to be set");
        }
        if (!this.shouldRun()) {
            return;
        }
        Liquibase liquibase = null;
        try {
            try {
                liquibase = this.createLiquibase();
                Writer writer = this.createOutputWriter();
                if (this.getRollbackCount() != null) {
                    if (writer == null) {
                        liquibase.rollback((int)this.getRollbackCount(), this.getContexts());
                    } else {
                        liquibase.rollback((int)this.getRollbackCount(), this.getContexts(), writer);
                    }
                } else if (this.getRollbackDate() != null) {
                    if (writer == null) {
                        liquibase.rollback(this.getRollbackDate(), this.getContexts());
                    } else {
                        liquibase.rollback(this.getRollbackDate(), this.getContexts(), writer);
                    }
                } else if (this.getRollbackTag() != null) {
                    if (writer == null) {
                        liquibase.rollback(this.getRollbackTag(), this.getContexts());
                    } else {
                        liquibase.rollback(this.getRollbackTag(), this.getContexts(), writer);
                    }
                } else {
                    throw new BuildException("Must specify rollbackCount, rollbackDate, or rollbackTag");
                }
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }
}

