/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.bean;

import com.google.common.base.Predicate;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanDoubleListModel;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import jaxx.runtime.swing.model.JaxxFilterableListModel;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.swing.renderer.FilteredDecoratorListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.util.beans.BeanUtil;

public class BeanDoubleListHandler<O>
implements PropertyChangeListener {
    private static final Log log = LogFactory.getLog(BeanDoubleListHandler.class);
    protected Method mutator;
    protected BeanDoubleList<O> ui;
    protected MultiJXPathDecorator<O> decorator;
    private final BeanUIUtil.PopupHandler popupHandler = new BeanUIUtil.PopupHandler(){

        @Override
        public JPopupMenu getPopup() {
            return BeanDoubleListHandler.this.ui.getPopup();
        }

        @Override
        public JComponent getInvoker() {
            return BeanDoubleListHandler.this.ui.getChangeDecorator();
        }
    };

    public BeanDoubleListHandler(BeanDoubleList<O> ui) {
        this.ui = ui;
    }

    public JPopupMenu getSelectedListPopup(boolean showIt) {
        JPopupMenu result = showIt ? this.ui.getSelectedListPopup() : null;
        return result;
    }

    public void init(JXPathDecorator<O> decorator, List<O> universe, List<O> selected) {
        this.init(decorator, decorator, universe, selected);
    }

    public void init(JXPathDecorator<O> decorator, JXPathDecorator<O> decorator2, List<O> universe, List<O> selected) {
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null (for type " + this.ui.getBeanType() + ")");
        }
        this.decorator = BeanUIUtil.createDecorator(decorator);
        this.ui.getModel().setUseMultiSelect(this.ui.getUseMultiSelect());
        this.ui.getModel().setUniverse(universe);
        this.ui.getModel().setSelected(selected);
        JList universeList = this.ui.getUniverseList();
        JList selectedList = this.ui.getSelectedList();
        final FilteredDecoratorListCellRenderer universeListCellRenderer = new FilteredDecoratorListCellRenderer(this.decorator);
        universeList.setCellRenderer(universeListCellRenderer);
        decorator2 = decorator2 != null ? BeanUIUtil.createDecorator(decorator2) : this.decorator;
        selectedList.setCellRenderer(new DecoratorListCellRenderer(decorator2));
        universeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                BeanDoubleListHandler.this.ui.getModel().setAddEnabled(!source.isSelectionEmpty());
            }
        });
        selectedList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                BeanDoubleListModel model = BeanDoubleListHandler.this.ui.getModel();
                if (!e.getValueIsAdjusting()) {
                    boolean removeEnabled = !source.isSelectionEmpty();
                    model.setRemoveEnabled(removeEnabled);
                    int minSelectionIndex = source.getMinSelectionIndex();
                    int maxSelectionIndex = source.getMaxSelectionIndex();
                    boolean oneSelection = minSelectionIndex == maxSelectionIndex;
                    boolean upEnabled = removeEnabled && oneSelection && minSelectionIndex > 0;
                    model.setSelectedUpEnabled(upEnabled);
                    boolean downEnabled = removeEnabled && oneSelection && minSelectionIndex + 1 < model.getSelectedListSize();
                    model.setSelectedDownEnabled(downEnabled);
                }
            }
        });
        selectedList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                BeanDoubleListHandler.this.fireSelectionUpdate();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                BeanDoubleListHandler.this.fireSelectionUpdate();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                BeanDoubleListHandler.this.fireSelectionUpdate();
            }
        });
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.popupHandler.preparePopup(null, null, this.ui.getI18nPrefix(), null, (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), this.ui.getSortUp(), this.ui.getSortDown(), this.decorator);
        this.ui.addPropertyChangeListener(this);
        final JaxxFilterableListModel filterModel = (JaxxFilterableListModel)this.ui.getModel().getUniverseModel();
        filterModel.setDecorator(this.decorator);
        this.ui.getFilterField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text = BeanDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String text = BeanDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String text = BeanDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }
        });
        indexes.setSelectedButton((Object)this.ui.getIndex());
        this.sortData();
        this.ui.processDataBinding("selectedList.componentPopupMenu");
    }

    public void setUniverse(List<O> selection) {
        this.ui.getModel().setUniverse(selection);
        this.sortData();
    }

    public void setSelected(List<O> selection) {
        this.ui.getModel().setSelected(selection);
        this.sortData();
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public void sortData() {
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
    }

    public void moveUpSelected(O item) {
        this.ui.getModel().moveUpSelected(item);
        this.ui.getSelectedList().setSelectedValue(item, true);
    }

    public void moveDownSelected(O item) {
        this.ui.getModel().moveDownSelected(item);
        this.ui.getSelectedList().setSelectedValue(item, true);
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        AbstractButton button;
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        if ((button = this.ui.getIndexes().getButton((Object)newValue)) != null) {
            button.setSelected(true);
        }
        this.updateUI(newValue, this.ui.isReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        this.updateUI(this.ui.getIndex(), newValue);
    }

    protected void setHighlightFilterText(Boolean newValue) {
        FilteredDecoratorListCellRenderer universeListCellRenderer = (FilteredDecoratorListCellRenderer)this.ui.getUniverseList().getCellRenderer();
        universeListCellRenderer.setHighlightFilterText(newValue.booleanValue());
        this.ui.getUniverseList().repaint();
    }

    protected void updateUI(int index, boolean reversesort) {
        this.decorator.setContextIndex(index);
        List<Object> data = Arrays.asList(((JaxxDefaultListModel)this.ui.getModel().getUniverseModel()).toArray());
        try {
            DecoratorUtil.sort(this.decorator, data, (int)index, (boolean)reversesort);
        }
        catch (Exception eee) {
            log.warn((Object)eee.getMessage(), (Throwable)eee);
        }
        SwingUtil.fillList((JList)this.ui.getUniverseList(), data, null);
        this.ui.getUniverseList().requestFocus();
    }

    public void onUniverseListClicked(MouseEvent event) {
        JList universeList = this.ui.getUniverseList();
        if (event.getClickCount() == 2) {
            int index = universeList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            Object item = universeList.getModel().getElementAt(index);
            this.ui.getModel().addToSelected(item);
            this.sortData();
        }
    }

    public void onSelectedListClicked(MouseEvent event) {
        JList selectedList = this.ui.getSelectedList();
        if (event.getClickCount() == 2) {
            int index = selectedList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            Object item = selectedList.getModel().getElementAt(index);
            this.ui.getModel().removeFromSelected(item);
            this.sortData();
        }
    }

    public void select() {
        List<Object> selection = Arrays.asList(this.ui.getUniverseList().getSelectedValues());
        this.ui.getModel().addToSelected(selection);
        this.ui.getUniverseList().clearSelection();
        this.sortData();
    }

    public void unselect() {
        List<Object> selection = Arrays.asList(this.ui.getSelectedList().getSelectedValues());
        this.ui.getModel().removeFromSelected(selection);
        this.ui.getSelectedList().clearSelection();
        this.sortData();
    }

    protected void fireSelectionUpdate() {
        if (this.ui.getBean() != null) {
            BeanUIUtil.invokeMethod(this.getMutator(), this.ui.getBean(), this.ui.getModel().getSelected());
        }
    }

    public Method getMutator() {
        if (this.mutator == null && this.ui.getBackground() != null && this.ui.getProperty() != null) {
            this.mutator = BeanUtil.getMutator((Object)this.ui.getBean(), (String)this.ui.getProperty());
        }
        return this.mutator;
    }

    public MultiJXPathDecorator<O> getDecorator() {
        return this.decorator;
    }

    public Class<O> getBeanType() {
        Class<O> result = this.ui.getBeanType();
        if (result == null) {
            result = this.decorator == null ? null : this.decorator.getType();
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("index".equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
        } else if ("reverseSort".equals(propertyName)) {
            this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
        } else if ("highlightFilterText".equals(propertyName)) {
            this.setHighlightFilterText((Boolean)evt.getNewValue());
        } else if ("useMultiSelect".equals(propertyName)) {
            this.ui.getModel().setUseMultiSelect((Boolean)evt.getNewValue());
        }
    }

    public void addFilter(Predicate<O> filter) {
        ((JaxxFilterableListModel)this.ui.getModel().getUniverseModel()).addFilter(filter);
    }

    public void removeFilter(Predicate<O> filter) {
        ((JaxxFilterableListModel)this.ui.getModel().getUniverseModel()).removeFilter(filter);
    }

    public void clearFilters() {
        ((JaxxFilterableListModel)this.ui.getModel().getUniverseModel()).clearFilters();
    }

    public void refreshFilteredElements() {
        ((JaxxFilterableListModel)this.ui.getModel().getUniverseModel()).refreshFilteredElements();
    }

    public void onKeyPressedOnUniverseList(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            int lastIndice = this.ui.getUniverseList().getSelectionModel().getLeadSelectionIndex();
            this.select();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
            } else {
                this.ui.getSelectedList().requestFocus();
            }
        }
    }

    public void onKeyPressedOnSelectedList(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            int lastIndice = this.ui.getSelectedList().getSelectionModel().getLeadSelectionIndex();
            this.unselect();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
                this.ui.getSelectedList().requestFocus();
            }
        }
    }

    public void selectFirstRowIfNoSelection(FocusEvent event) {
        JList list = (JList)event.getSource();
        if (list.isSelectionEmpty()) {
            list.setSelectedIndex(0);
        }
    }
}

