/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential.consumer;

import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.csv.PersonModel;
import fr.ifremer.tutti.service.referential.csv.PersonRow;
import java.nio.file.Path;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class CsvConsumerForTemporaryPerson
extends CsvComsumer<PersonRow, PersonModel> {
    private static final Log log = LogFactory.getLog(CsvConsumerForTemporaryPerson.class);

    public CsvConsumerForTemporaryPerson(Path file, char separator, boolean reportError) {
        super(file, PersonModel.forImport(separator), reportError);
    }

    public void checkRow(ImportRow<PersonRow> row, PersistenceService persistenceService, DecoratorService decoratorService, ReferentialImportRequest<Person, Integer> requestResult) {
        if (row.isValid()) {
            PersonRow bean = (PersonRow)row.getBean();
            Integer id = bean.getIdAsInt();
            boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
            if (id == null) {
                this.checkAdd(bean, requestResult);
            } else {
                Person person = requestResult.getExistingEntityById(id);
                if (person == null) {
                    throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.notExistingId", (Object[])new Object[]{id}));
                }
                if (delete) {
                    this.checkDelete(bean, person, persistenceService, decoratorService, requestResult);
                } else {
                    this.checkUpdate(bean, person, requestResult);
                }
            }
        }
        this.reportError(row);
    }

    public void checkRowForGenericFormatImport(ImportRow<PersonRow> row, ReferentialImportRequest<Person, Integer> requestResult) {
        PersonRow bean = (PersonRow)row.getBean();
        String name = bean.getFullName();
        if (row.isValid()) {
            Integer id = bean.getIdAsInt();
            if (id == null) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.noId", (Object[])new Object[0]))));
            } else if (!Persons.isTemporaryId((Integer)id)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.idNotTemporary", (Object[])new Object[]{id}))));
            } else if (requestResult.isIdAlreadyAdded(id)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.id.alreaydAdded", (Object[])new Object[]{id}))));
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.noName", (Object[])new Object[0]))));
            } else if (requestResult.isNaturalIdAlreadyAdded(name)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.name.alreaydAdded", (Object[])new Object[]{name}))));
            }
        }
        this.reportError(row);
        if (row.isValid()) {
            Person entity = bean.toEntity();
            boolean toAdd = requestResult.addExistingNaturalId(name);
            if (toAdd) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will add person with name: " + name));
                }
                requestResult.addEntityToAdd(entity);
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will link person with name: " + name));
                }
                requestResult.addEntityToLink(entity);
            }
        }
    }

    protected void checkAdd(PersonRow bean, ReferentialImportRequest<Person, Integer> requestResult) {
        String name = bean.getFullName();
        boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
        if (delete) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.cannotDeleteWithoutId", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.noName", (Object[])new Object[0]));
        }
        if (!requestResult.addExistingNaturalId(name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.existingName", (Object[])new Object[]{name}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will add person with name: " + name));
        }
        requestResult.addEntityToAdd(bean.toEntity());
    }

    protected void checkDelete(PersonRow bean, Person person, PersistenceService persistenceService, DecoratorService decoratorService, ReferentialImportRequest<Person, Integer> requestResult) {
        Integer id = bean.getIdAsInt();
        String name = bean.getFullName();
        if (persistenceService.isTemporaryPersonUsed(id)) {
            String personRef = id + " : " + decoratorService.getDecoratorByType(Person.class).toString((Object)person);
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.used", (Object[])new Object[]{personRef}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete person with name: " + name));
        }
        requestResult.addIdToDelete(id);
        requestResult.removeExistingNaturalId(name);
    }

    protected void checkUpdate(PersonRow bean, Person person, ReferentialImportRequest<Person, Integer> requestResult) {
        Integer id = bean.getIdAsInt();
        String name = bean.getFullName();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.noName", (Object[])new Object[]{id}));
        }
        if (!name.equals(person.getName()) && !requestResult.addExistingNaturalId(name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.person.error.existingName", (Object[])new Object[]{name}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will update person with name: " + name));
        }
        requestResult.addEntityToUpdate(bean.toEntity());
    }
}

