/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporarySpecies;
import fr.ifremer.tutti.service.referential.csv.SpeciesRow;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporarySpecies;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialTemporarySpeciesService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialTemporarySpeciesService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public ReferentialImportRequest<Species, Integer> createReferentialImportRequest() {
        List<Species> allSpecies = this.persistenceService.getAllSpecies();
        return new ReferentialImportRequest<Species, Integer>(allSpecies, TuttiEntities.newIdAstIntFunction(), Speciess.GET_NAME);
    }

    public ReferentialImportResult<Species> importTemporarySpecies(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import species from file: " + file));
        }
        ReferentialImportRequest<Species, Integer> requestResult = this.createReferentialImportRequest();
        try (CsvConsumerForTemporarySpecies consumer = new CsvConsumerForTemporarySpecies(file.toPath(), this.getCsvSeparator(), true);){
            for (ImportRow bean : consumer) {
                consumer.checkRow(bean, this.persistenceService, this.decoratorService, requestResult);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.import.species.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        ReferentialImportResult<Species> result = this.executeImportRequest(requestResult);
        return result;
    }

    public ReferentialImportResult<Species> executeImportRequest(ReferentialImportRequest<Species, Integer> requestResult) {
        ReferentialImportResult<Species> result = new ReferentialImportResult<Species>();
        if (requestResult.withEntitiesToDelete()) {
            List<Integer> idsToDelete = requestResult.getIdsToDelete();
            this.persistenceService.deleteTemporarySpecies(idsToDelete);
            result.setNbRefDeleted(idsToDelete.size());
        }
        if (requestResult.withEntitiesToAdd()) {
            List<Species> entitiesToAdd = requestResult.getEntitiesToAdd();
            List<Species> entitiesAdded = this.persistenceService.addTemporarySpecies(entitiesToAdd);
            result.addAllRefsAdded(entitiesAdded);
        }
        if (requestResult.withEntitiesToUpdate()) {
            List<Species> entitiesToUpdate = requestResult.getEntitiesToUpdate();
            List<Species> entitiesUpdated = this.persistenceService.updateTemporarySpecies(entitiesToUpdate);
            result.addAllRefsUpdated(entitiesUpdated);
        }
        if (requestResult.withEntitiesToLink()) {
            List<Species> entitiesToLink = requestResult.getEntitiesToLink();
            List<Species> entitiesLinked = this.persistenceService.linkTemporarySpecies(entitiesToLink);
            result.addAllRefsLinked(entitiesLinked);
        }
        return result;
    }

    public List<Species> getTemporarySpeciess() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all species from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllReferentSpecies());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " species"));
        }
        List<Species> toExport = this.persistenceService.retainTemporarySpeciesList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary species"));
        }
        return toExport;
    }

    public void exportExistingTemporarySpecies(File file) throws IOException {
        List<Species> toExport = this.getTemporarySpeciess();
        this.exportTemporarySpecies(file, toExport);
    }

    public void exportTemporarySpeciesExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Species s = Speciess.newSpecies();
        s.setName("Temporary Species name 1");
        toExport.add(s);
        s = Speciess.newSpecies();
        s.setName("Temporary Species name 2");
        toExport.add(s);
        s = Speciess.newSpecies();
        s.setName("Temporary Species name 3");
        toExport.add(s);
        this.exportTemporarySpecies(file, toExport);
    }

    public void exportTemporarySpecies(File file, List<Species> toExport) throws IOException {
        try (CsvProducerForTemporarySpecies producerForTemporarySpecies = new CsvProducerForTemporarySpecies(file.toPath(), this.getCsvSeparator());){
            List<SpeciesRow> dataToExport = producerForTemporarySpecies.getDataToExport(toExport);
            producerForTemporarySpecies.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.species.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    protected char getCsvSeparator() {
        return ';';
    }
}

