/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ValueParserFormatter;

public class IntegerListParserFormatter
implements ValueParserFormatter<List<Integer>> {
    public String format(List<Integer> value) {
        List decoratedValues = Lists.transform(value, (Function)new Function<Integer, String>(){

            public String apply(Integer input) {
                return input.toString();
            }
        });
        return Joiner.on((char)'|').join((Iterable)decoratedValues);
    }

    public List<Integer> parse(String value) throws ParseException {
        ArrayList result = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] split;
            for (String string : split = value.split("\\s*\\|\\s*")) {
                result.add(Integer.valueOf(string));
            }
        }
        return result;
    }
}

