/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;

public final class TuttiUIUtil
extends ApplicationUIUtil {
    private static final Log log = LogFactory.getLog(TuttiUIUtil.class);
    public static final MouseListener GRAB_FOCUS_ON_ENTER_LISTENER = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            JComponent source = (JComponent)e.getSource();
            source.grabFocus();
        }
    };

    private TuttiUIUtil() {
    }

    public static TuttiUIContext getApplicationContext(JAXXObject ui) {
        return (TuttiUIContext)ApplicationUIUtil.getApplicationContext((JAXXObject)ui);
    }

    public static void setParentUI(JAXXObject ui, TuttiUI<?, ?> parentUI) {
        JAXXUtil.initContext((JAXXObject)ui, parentUI);
        TuttiUIUtil.setApplicationContext((JAXXObject)ui, (ApplicationUIContext)((AbstractTuttiUIHandler)parentUI.getHandler()).getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryToConnectToUpdateUrl(String urlAsString, String badUrlFormatI18nKey, String notReachI18nKey, String notFoundI18nKey) {
        URLConnection urlConnection;
        URL url;
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bad url syntax at " + urlAsString), (Throwable)e);
            }
            throw new ApplicationBusinessException(I18n.t((String)badUrlFormatI18nKey, (Object[])new Object[]{urlAsString}));
        }
        try {
            urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(10000);
            urlConnection.connect();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not connect to " + urlAsString), (Throwable)e);
            }
            throw new ApplicationBusinessException(I18n.t((String)notReachI18nKey, (Object[])new Object[]{urlAsString}));
        }
        try {
            urlConnection.setReadTimeout(1000);
            InputStream inputStream = null;
            try {
                inputStream = urlConnection.getInputStream();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not found file at to " + urlAsString), (Throwable)e);
            }
            throw new ApplicationBusinessException(I18n.t((String)notFoundI18nKey, (Object[])new Object[]{urlAsString}));
        }
    }

    public static ImageIcon getCruiseIcon(Cruise cruise) {
        String iconName = "cruise";
        if (cruise != null) {
            if (Cruises.isDirty((Cruise)cruise)) {
                iconName = "cruise-dirty";
            } else if (Cruises.isReadyToSynch((Cruise)cruise)) {
                iconName = "cruise-ready-to-sync";
            } else if (Cruises.isSynch((Cruise)cruise)) {
                iconName = "cruise-waiting";
            }
        }
        return SwingUtil.createActionIcon((String)iconName);
    }

    public static void openResource(File file) {
        Desktop desktop = TuttiUIUtil.getDesktopForOpen();
        try {
            desktop.open(file);
        }
        catch (Exception e) {
            throw new ApplicationBusinessException(I18n.t((String)"swing.error.cannot.open.file", (Object[])new Object[0]));
        }
    }

    public static int getColorBrightness(Color c) {
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        return (int)Math.sqrt((double)(red * red) * 0.241 + (double)(green * green) * 0.691 + (double)(blue * blue) * 0.068);
    }

    public static void prepareAction(AbstractButton button, Action action, String actionName) {
        action.putValue("SmallIcon", button.getIcon());
        action.putValue("SwingLargeIconKey", button.getIcon());
        action.putValue("ActionCommandKey", actionName);
        action.putValue("Name", button.getText());
        action.putValue("ShortDescription", button.getToolTipText());
        action.putValue("MnemonicKey", button.getMnemonic());
        button.setAction(action);
    }

    public static Action addDelegateAction(AbstractButton button, String actionName) {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionListener[] actionListeners;
                AbstractButton source = (AbstractButton)e.getSource();
                for (ActionListener actionListener : actionListeners = source.getActionListeners()) {
                    if (this == actionListener) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Do actionPerformed on listener: " + actionListener));
                    }
                    actionListener.actionPerformed(e);
                }
            }
        };
        TuttiUIUtil.prepareAction(button, action, actionName);
        return action;
    }
}

