/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.report.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.report.ReportUI;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIHandler;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;

public class SaveReportAction
extends LongActionSupport<ReportUIModel, ReportUI, ReportUIHandler> {
    private static final Log log = LogFactory.getLog(SaveReportAction.class);
    protected File file;

    public SaveReportAction(ReportUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            FishingOperation fishingOperation = ((ReportUIModel)this.getModel()).getFishingOperation();
            Preconditions.checkNotNull((Object)"Can't have a null fishing operation", (Object)fishingOperation);
            Preconditions.checkState((boolean)((ReportUIModel)this.getModel()).isReportDone(), (Object)"Result must be done");
            Decorator decorator = this.getDecorator(FishingOperation.class, null);
            String filename = "rapport-" + decorator.toString((Object)fishingOperation) + ".pdf";
            filename = filename.replaceAll("/", "_").replaceAll("\\s", "");
            if (log.isInfoEnabled()) {
                log.info((Object)("Default save filename: " + filename));
            }
            this.file = this.saveFileWithStartDirectory(this.getConfig().getReportBackupDirectory(), false, filename, null, I18n.t((String)"tutti.report.title.choose.saveReportFile", (Object[])new Object[0]), I18n.t((String)"tutti.report.action.save", (Object[])new Object[0]), new String[]{"^.+\\.pdf$", I18n.t((String)"tutti.common.file.pdf", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        File outputFile = ((ReportUIModel)this.getModel()).getOutputFile();
        ApplicationIOUtil.copyFile((File)outputFile, (File)this.file, (String)("Could not save file to " + this.file));
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.report.saved", (Object[])new Object[]{this.file}));
    }

    protected void releaseAction() {
        super.releaseAction();
        this.file = null;
    }
}

