/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.actions.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.util.CloseableUI;

public class FishingOperationsUIHandler
extends AbstractTuttiTabContainerUIHandler<FishingOperationsUIModel, FishingOperationsUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(FishingOperationsUIHandler.class);
    protected EditFishingOperationAction editFishingOperationAction;

    public void beforeInit(FishingOperationsUI ui) {
        super.beforeInit((ApplicationUI)ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("for " + this.ui));
        }
        FishingOperationsUIModel model = new FishingOperationsUIModel();
        EditCatchesUIModel catchesUIModel = new EditCatchesUIModel(this.getConfig().getSpeciesWeightUnit(), this.getConfig().getBenthosWeightUnit(), this.getConfig().getMarineLitterWeightUnit(), this.getConfig().getIndividualObservationWeightUnit());
        Cruise cruise = this.getDataContext().getCruise();
        PersistenceService persistenceService = this.getPersistenceService();
        if (this.getContext().isProtocolFilled()) {
            TuttiProtocol protocol = persistenceService.getProtocol(this.getContext().getProtocolId());
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading existing protocol: " + protocol));
            }
        }
        ArrayList fishingOperations = Lists.newArrayList((Iterable)persistenceService.getAllFishingOperation(cruise.getId()));
        for (FishingOperation fishingOperation : fishingOperations) {
            fishingOperation.setCruise(cruise);
        }
        model.setFishingOperation(fishingOperations);
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded " + fishingOperations.size() + " fishingOperation(s)."));
        }
        ((FishingOperationsUI)this.ui).setContextValue(model);
        ((FishingOperationsUI)this.ui).setContextValue(catchesUIModel);
    }

    public void afterInit(FishingOperationsUI ui) {
        this.initUI((TuttiUI)this.ui);
        this.editFishingOperationAction = this.getContext().getActionFactory().createLogicAction(this, EditFishingOperationAction.class);
        FishingOperationsUIModel model = (FishingOperationsUIModel)((Object)this.getModel());
        List<FishingOperation> fishingOperations = model.getFishingOperation();
        this.initBeanFilterableComboBox(((FishingOperationsUI)this.ui).getFishingOperationComboBox(), fishingOperations, model.getSelectedFishingOperation());
        model.addPropertyChangeListener("selectedFishingOperation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"propertyChange selectedFishingOperation");
                }
                FishingOperation newValue = (FishingOperation)evt.getNewValue();
                if (!((FishingOperationsUIModel)((Object)FishingOperationsUIHandler.this.getModel())).isEditionAdjusting()) {
                    FishingOperation operation;
                    if (newValue == null) {
                        operation = null;
                    } else {
                        operation = FishingOperationsUIHandler.this.getPersistenceService().getFishingOperation(newValue.getId());
                        Cruise cruise = FishingOperationsUIHandler.this.getDataContext().getCruise();
                        operation.setCruise(cruise);
                    }
                    FishingOperationsUIHandler.this.editFishingOperationAction.setFishingOperation(operation);
                    if (SwingUtilities.isEventDispatchThread()) {
                        FishingOperationsUIHandler.this.getContext().getActionEngine().runAction((AbstractApplicationAction)FishingOperationsUIHandler.this.editFishingOperationAction);
                    } else {
                        FishingOperationsUIHandler.this.getContext().getActionEngine().runInternalAction((AbstractApplicationAction)FishingOperationsUIHandler.this.editFishingOperationAction);
                    }
                }
                String fishingOperationText = FishingOperationsUIHandler.this.getFishingOperationTitle(newValue);
                EditFishingOperationUI efoUI = ((FishingOperationsUI)FishingOperationsUIHandler.this.getUI()).getFishingOperationTabContent();
                efoUI.getTraitGeneralTabPane().setTitle(fishingOperationText);
                efoUI.getVesselUseFeatureTabPane().setTitle(fishingOperationText);
                efoUI.getGearUseFeatureTabPane().setTitle(fishingOperationText);
                EditCatchesUI ecUI = ((FishingOperationsUI)FishingOperationsUIHandler.this.getUI()).getCatchesTabContent();
                ecUI.getCatchesCaracteristicsTabPane().setTitle(fishingOperationText);
                ecUI.getSpeciesTabFishingOperationReminderLabel().setTitle(fishingOperationText);
                ecUI.getBenthosTabFishingOperationReminderLabel().setTitle(fishingOperationText);
                ecUI.getMarineLitterTabFishingOperationReminderLabel().setTitle(fishingOperationText);
                ecUI.getAccidentalTabFishingOperationReminderLabel().setTitle(fishingOperationText);
                ecUI.getIndividualObservationTabFishingOperationReminderLabel().setTitle(fishingOperationText);
            }
        });
        model.addPropertyChangeListener("fishingOperation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"propertyChange fishingOperation");
                }
                ((FishingOperationsUI)FishingOperationsUIHandler.this.ui).getFishingOperationComboBox().setData(null);
                ((FishingOperationsUI)FishingOperationsUIHandler.this.ui).getFishingOperationComboBox().setData((List)evt.getNewValue());
            }
        });
        FishingOperation selectedOperation = null;
        for (FishingOperation fishingOperation : fishingOperations) {
            if (selectedOperation != null && (!fishingOperation.getGearShootingStartDate().after(selectedOperation.getGearShootingStartDate()) || fishingOperation.getFishingOperationNumber() <= selectedOperation.getFishingOperationNumber())) continue;
            selectedOperation = fishingOperation;
        }
        model.setSelectedFishingOperation(selectedOperation);
        this.getContext().addPropertyChangeListener("hideBody", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean hideBody = (Boolean)evt.getNewValue();
                if (hideBody != null && hideBody.booleanValue() && ((FishingOperationsUIModel)((Object)FishingOperationsUIHandler.this.getModel())).getSelectedFishingOperation() == null) {
                    ((FishingOperationsUI)FishingOperationsUIHandler.this.getUI()).getFishingOperationComboBox().requestFocus();
                }
            }
        });
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void onCloseUI() {
        ((FishingOperationsUI)this.ui).getTabPane().setSelectedIndex(0);
        ((FishingOperationsUI)this.ui).getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);
        this.closeUI(((FishingOperationsUI)this.ui).getFishingOperationTabContent());
        this.closeUI(((FishingOperationsUI)this.ui).getCatchesTabContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quitUI() {
        FishingOperation editFishingOperation = ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation();
        this.editFishingOperationAction.setFishingOperation(editFishingOperation);
        this.editFishingOperationAction.setCheckPreviousEdit(true);
        try {
            boolean result;
            boolean bl = result = this.editFishingOperationAction.prepareAction();
            return bl;
        }
        finally {
            this.editFishingOperationAction.releaseAction();
        }
    }

    public SwingValidator<FishingOperationsUIModel> getValidator() {
        return null;
    }

    public JTabbedPane getTabPanel() {
        return ((FishingOperationsUI)this.ui).getTabPane();
    }

    public boolean removeTab(int i) {
        return false;
    }

    public boolean isFishingOperationModified() {
        return ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation() != null && ((FishingOperationsUI)this.getUI()).getFishingOperationTabContent().getModel().isModify();
    }

    public boolean isFishingOperationValid() {
        return ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation() != null && ((FishingOperationsUI)this.getUI()).getFishingOperationTabContent().getModel().isValid();
    }

    public boolean isCatchBatchModified() {
        return ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation() != null && ((FishingOperationsUI)this.getUI()).getCatchesTabContent().getModel().isModify();
    }

    public boolean isCatchBatchValid() {
        return ((FishingOperationsUIModel)((Object)this.getModel())).getEditFishingOperation() != null && ((FishingOperationsUI)this.getUI()).getCatchesTabContent().getModel().isValid();
    }

    public String getFishingOperationTitle(FishingOperation bean) {
        String fishingOperationText = bean == null ? null : (TuttiEntities.isNew((TuttiEntity)bean) ? I18n.t((String)"tutti.editFishingOperation.label.traitReminder", (Object[])new Object[]{I18n.t((String)"tutti.editFishingOperation.label.traitReminder.inCreation", (Object[])new Object[0])}) : I18n.t((String)"tutti.editFishingOperation.label.traitReminder", (Object[])new Object[]{this.decorate((Serializable)bean)}));
        return fishingOperationText;
    }
}

