/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.actions;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.actions.OpenDbScreenAction;
import fr.ifremer.tutti.ui.swing.content.actions.OpenHomeScreenAction;
import fr.ifremer.tutti.ui.swing.content.db.actions.ImportDbAction;
import fr.ifremer.tutti.ui.swing.content.db.actions.InstallDbAction;
import fr.ifremer.tutti.ui.swing.content.db.actions.OpenDbAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;

public class StartAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(StartAction.class);
    protected AbstractMainUITuttiAction delegateAction;

    public StartAction(MainUIHandler handler) {
        super(handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareAction() throws Exception {
        AbstractMainUITuttiAction action;
        File actionfile = this.getConfig().getStartActionFile();
        boolean doAction = actionfile.exists();
        if (doAction) {
            block13: {
                try {
                    String content = ApplicationIOUtil.readContent((File)actionfile, (String)I18n.t((String)"tutti.error.read.startActionFile", (Object[])new Object[]{actionfile}));
                    content = content.trim();
                    if (InstallDbAction.class.getName().equals(content)) {
                        this.delegateAction = this.getContext().getActionFactory().createLogicAction(this.handler, InstallDbAction.class);
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Found install db action");
                        }
                        this.deleteOldDatabaseDirectory();
                        break block13;
                    }
                    if (content.startsWith(ImportDbAction.class.getName())) {
                        action = this.getContext().getActionFactory().createLogicAction(this.handler, ImportDbAction.class);
                        File importFile = new File(content.substring(ImportDbAction.class.getName().length() + 1));
                        ((ImportDbAction)action).setImportFile(importFile);
                        this.delegateAction = action;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Found import db action (with file " + importFile + ")"));
                        }
                        this.deleteOldDatabaseDirectory();
                        break block13;
                    }
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Unknown start action: " + content));
                    }
                    doAction = false;
                }
                catch (Throwable throwable) {
                    ApplicationIOUtil.deleteFile((File)actionfile, (String)I18n.t((String)"tutti.error.delete.startActionFile", (Object[])new Object[]{actionfile}));
                    throw throwable;
                }
            }
            ApplicationIOUtil.deleteFile((File)actionfile, (String)I18n.t((String)"tutti.error.delete.startActionFile", (Object[])new Object[]{actionfile}));
        }
        if (!doAction) {
            TuttiUIContext context = this.getContext();
            if (context.isDbLoaded()) {
                action = this.getContext().getActionFactory().createLogicAction(this.handler, OpenHomeScreenAction.class);
                ((AbstractChangeScreenAction)action).setSkipCheckCurrentScreen(true);
                action.setActionDescription(((MainUI)this.getUI()).getMenuActionSelectCruise().getToolTipText());
                this.delegateAction = action;
            } else if (context.isDbExist()) {
                action = this.getContext().getActionFactory().createLogicAction(this.handler, OpenDbAction.class);
                ((AbstractChangeScreenAction)action).setSkipCheckCurrentScreen(true);
                ((OpenDbAction)action).setUpdateReferentiel(true);
                this.delegateAction = action;
            } else {
                context.clearDbContext();
                action = this.getContext().getActionFactory().createLogicAction(this.handler, OpenDbScreenAction.class);
                ((AbstractChangeScreenAction)action).setSkipCheckCurrentScreen(true);
                this.delegateAction = action;
            }
        }
        this.setActionDescription(this.delegateAction.getActionDescription());
        doAction = this.delegateAction.prepareAction();
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        this.getActionEngine().runInternalAction((AbstractApplicationAction)this.delegateAction);
    }

    protected void releaseAction() {
        this.delegateAction = null;
        super.releaseAction();
    }

    protected void deleteOldDatabaseDirectory() {
        File dbDirectory = this.getConfig().getDbDirectory();
        if (dbDirectory.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete previous database directory: " + dbDirectory));
            }
            ApplicationIOUtil.deleteDirectory((File)dbDirectory, (String)"Could not delete old db directory");
        }
    }
}

