/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.TuttiPersistenceNoDbImpl;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.persistence.service.UpdateSchemaContextSupport;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.util.TimeLog;
import org.nuiton.util.version.Version;

public class PersistenceService
extends AbstractTuttiService
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(PersistenceService.class);
    protected TuttiPersistence driver;
    public static final DateFormat EXPORT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String EXPORT_DIRECTORY_FORMAT = "tutti-%s-%s";
    public static final TimeLog TIME_LOG = new TimeLog(PersistenceService.class);

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.init();
    }

    public void setSampleCategoryModel(SampleCategoryModel sampleCategoryModel) {
        this.context.getDataContext().setSampleCategoryModel(sampleCategoryModel);
    }

    public List<Gear> retainTemporaryGearList(List<Gear> targetList) {
        List<Gear> sourceList = this.retainTemporaryList(Gears.IS_TEMPORARY, targetList);
        return sourceList;
    }

    public List<Person> retainTemporaryPersonList(List<Person> targetList) {
        List<Person> sourceList = this.retainTemporaryList(Persons.IS_TEMPORARY, targetList);
        return sourceList;
    }

    public List<Species> retainTemporarySpeciesList(List<Species> targetList) {
        List<Species> sourceList = this.retainTemporaryList(Speciess.IS_TEMPORARY, targetList);
        return sourceList;
    }

    public List<Vessel> retainTemporaryVesselList(List<Vessel> targetList) {
        List<Vessel> sourceList = this.retainTemporaryList(Vessels.IS_TEMPORARY, targetList);
        return sourceList;
    }

    public <E extends TuttiEntity> List<E> retainTemporaryList(Predicate<E> isTemporaryPredicate, List<E> targetList) {
        ArrayList<TuttiEntity> sourceList = new ArrayList<TuttiEntity>();
        Iterator<E> iterator = targetList.iterator();
        while (iterator.hasNext()) {
            TuttiEntity next = (TuttiEntity)iterator.next();
            if (!isTemporaryPredicate.apply((Object)next)) continue;
            iterator.remove();
            sourceList.add(next);
        }
        return sourceList;
    }

    public FrequencyFunction<SpeciesBatch, SpeciesBatchFrequency> newSpeciesFrequenciesFunction() {
        return new FrequencyFunction<SpeciesBatch, SpeciesBatchFrequency>(){

            public List<SpeciesBatchFrequency> apply(SpeciesBatch input) {
                return PersistenceService.this.getAllSpeciesBatchFrequency(input.getId());
            }
        };
    }

    public FrequencyFunction<BenthosBatch, BenthosBatchFrequency> newBenthosFrequenciesFunction() {
        return new FrequencyFunction<BenthosBatch, BenthosBatchFrequency>(){

            public List<BenthosBatchFrequency> apply(BenthosBatch input) {
                return PersistenceService.this.getAllBenthosBatchFrequency(input.getId());
            }
        };
    }

    public <F extends SpeciesAbleBatchFrequency> Float countFrequenciesWeight(List<F> frequencies, boolean stopIfNullFound) {
        Float result = null;
        for (SpeciesAbleBatchFrequency frequency : frequencies) {
            Float w = frequency.getWeight();
            if (w == null) {
                if (!stopIfNullFound) continue;
                break;
            }
            if (result == null) {
                result = Float.valueOf(0.0f);
            }
            result = Float.valueOf(result.floatValue() + w.floatValue());
        }
        return result;
    }

    public <F extends SpeciesAbleBatchFrequency> Integer countFrequenciesNumber(List<F> frequencies, boolean stopIfNullFound) {
        Integer result = null;
        for (SpeciesAbleBatchFrequency frequency : frequencies) {
            Integer number = frequency.getNumber();
            if (number == null) {
                if (!stopIfNullFound) continue;
                break;
            }
            if (result == null) {
                result = 0;
            }
            result = result + number;
        }
        return result;
    }

    public String getImplementationName() {
        return "Tutti Persistence Service";
    }

    public void lazyInit() {
    }

    public void clearAllCaches() {
        this.driver.clearAllCaches();
    }

    public <V> V invoke(Callable<V> call) {
        return (V)this.driver.invoke(call);
    }

    public <U extends UpdateSchemaContextSupport> void prepareUpdateSchemaContext(U context) {
        this.driver.prepareUpdateSchemaContext(context);
    }

    public Version getSchemaVersion() {
        return this.driver.getSchemaVersion();
    }

    public Version getSchemaVersionIfUpdate() {
        return this.driver.getSchemaVersionIfUpdate();
    }

    public void updateSchema() {
        this.driver.updateSchema();
    }

    public void sanityDb() {
        this.driver.sanityDb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDb(File file) {
        Preconditions.checkState((!this.isDbLoaded() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)file);
        TuttiConfiguration config = this.context.getConfig();
        String directoryName = String.format(EXPORT_DIRECTORY_FORMAT, config.getVersion(), EXPORT_DATE_FORMAT.format(this.context.currentDate()));
        File structureDirectory = new File(config.newTempFile("exportdb"), directoryName);
        try {
            ApplicationIOUtil.forceMkdir((File)structureDirectory, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{structureDirectory}));
            if (log.isInfoEnabled()) {
                log.info((Object)("Export directory: " + structureDirectory));
            }
            ApplicationIOUtil.copyDirectory((File)config.getDbDirectory(), (File)new File(structureDirectory, "db"), (String)I18n.t((String)"tutti.service.persistence.copyDirectory.db.error", (Object[])new Object[0]));
            ApplicationIOUtil.copyDirectory((File)config.getDbAttachmentDirectory(), (File)new File(structureDirectory, "meas_files"), (String)I18n.t((String)"tutti.service.persistence.copyDirectory.attachment.error", (Object[])new Object[0]));
            ApplicationIOUtil.zip((File)structureDirectory, (File)file, (String)I18n.t((String)"tutti.service.persistence.exportDb.zip.error", (Object[])new Object[]{file}));
        }
        catch (Throwable throwable) {
            ApplicationIOUtil.forceDeleteOnExit((File)structureDirectory, (String)I18n.t((String)"tutti.service.persistence.exportDb.deleteTempDir.error", (Object[])new Object[]{structureDirectory}));
            throw throwable;
        }
        ApplicationIOUtil.forceDeleteOnExit((File)structureDirectory, (String)I18n.t((String)"tutti.service.persistence.exportDb.deleteTempDir.error", (Object[])new Object[]{structureDirectory}));
    }

    public ImportStructureType checkImportStructure(File file) {
        ImportStructureType result;
        if (!file.exists()) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.persistence.checkImportstructure.fileNotExist", (Object[])new Object[]{file}));
        }
        FileObject fileObject = ApplicationIOUtil.resolveFile((String)("zip:" + file.getAbsolutePath()), (String)I18n.t((String)"tutti.service.persistence.getArchive.error", (Object[])new Object[]{file}));
        FileObject[] children = ApplicationIOUtil.getChildren((FileObject)fileObject, (String)I18n.t((String)"tutti.service.persistence.openArchive.error", (Object[])new Object[]{file}));
        if (children.length != 1) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.persistence.checkImportstructure.tooManyChildren", (Object[])new Object[]{file}));
        }
        fileObject = children[0];
        children = ApplicationIOUtil.getChildren((FileObject)fileObject, (String)I18n.t((String)"tutti.service.persistence.openArchive.error", (Object[])new Object[]{file}));
        boolean dbDirectoyDetected = false;
        for (FileObject child : children) {
            FileName name = child.getName();
            if (!name.getBaseName().equals("db")) continue;
            dbDirectoyDetected = true;
            break;
        }
        if (dbDirectoyDetected) {
            result = ImportStructureType.NORMAL;
            this.checkArchiveDb(file, fileObject, "db", true);
            this.checkArchiveDb(file, fileObject, "meas_files", false);
        } else {
            result = ImportStructureType.INLINE;
            for (FileObject child : children) {
                FileType type = ApplicationIOUtil.getType((FileObject)child, (String)("Could not get type of " + child));
                if (!FileType.FOLDER.equals((Object)type)) continue;
                throw new ApplicationBusinessException(I18n.t((String)"tutti.service.persistence.checkImportstructure.inlineForbidDirectory", (Object[])new Object[0]));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Database import type: " + (Object)((Object)result)));
        }
        return result;
    }

    protected void checkArchiveDb(File file, FileObject fileObject, String dir, boolean required) {
        FileObject directory = ApplicationIOUtil.getChild((FileObject)fileObject, (String)dir, (String)I18n.t((String)"tutti.service.persistence.getChild.error", (Object[])new Object[]{dir}));
        if (directory == null) {
            String message = I18n.t((String)"tutti.service.persistence.checkArchiveDb.error", (Object[])new Object[]{file, dir});
            if (required) {
                throw new ApplicationBusinessException(message);
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
        }
    }

    public void importDb(ImportStructureType importStructureType, File file) {
        Preconditions.checkState((!this.isDbLoaded() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)file);
        TuttiConfiguration config = this.context.getConfig();
        File target = config.getDataDirectory();
        if (log.isInfoEnabled()) {
            log.info((Object)("Import db to " + target));
        }
        FileObject fileObject = ApplicationIOUtil.resolveFile((String)("zip:" + file.getAbsolutePath()), (String)I18n.t((String)"tutti.service.persistence.getArchive.error", (Object[])new Object[]{file}));
        FileObject[] children = ApplicationIOUtil.getChildren((FileObject)fileObject, (String)I18n.t((String)"tutti.service.persistence.openArchive.error", (Object[])new Object[]{file}));
        fileObject = children[0];
        switch (importStructureType) {
            case NORMAL: {
                break;
            }
            case INLINE: {
                target = new File(target, "db");
                ApplicationIOUtil.forceMkdir((File)target, (String)I18n.t((String)"tutti.service.persistence.createDbDirectory.error", (Object[])new Object[]{file}));
            }
        }
        ApplicationIOUtil.explode((FileObject)fileObject, (File)target, (FileSelector)new AllFileSelector(), (String)I18n.t((String)"tutti.service.persistence.extractArchive.error", (Object[])new Object[]{file}));
    }

    public boolean isDbLoaded() {
        return !(this.driver instanceof TuttiPersistenceNoDbImpl);
    }

    public List<Caracteristic> getDefaultIndividualObservationCaracteristics() {
        ArrayList result;
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null) {
            List individualObservationPmfmId = this.getProtocol().getIndividualObservationPmfmId();
            if (CollectionUtils.isEmpty((Collection)individualObservationPmfmId)) {
                result = Lists.newArrayList();
            } else {
                result = Lists.newArrayListWithCapacity((int)individualObservationPmfmId.size());
                for (String id : individualObservationPmfmId) {
                    Caracteristic caracteristic = this.getCaracteristic(Integer.valueOf(id));
                    result.add(caracteristic);
                }
            }
        } else {
            result = Lists.newArrayList();
        }
        return result;
    }

    public List<Caracteristic> getLengthStepCaracteristics(List<Caracteristic> caracteristics) {
        List<Object> result;
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null) {
            result = Lists.newArrayListWithCapacity((int)protocol.sizeLengthClassesPmfmId());
            Map allCaractericsById = TuttiEntities.splitById(caracteristics);
            if (!protocol.isLengthClassesPmfmIdEmpty()) {
                for (String id : protocol.getLengthClassesPmfmId()) {
                    result.add(allCaractericsById.get(id));
                }
            }
        } else {
            result = Lists.newArrayList();
        }
        result = Collections.unmodifiableList(result);
        return result;
    }

    public SpeciesProtocol getSpeciesProtocol(Species species) {
        return TuttiProtocols.getSpeciesProtocol((Species)species, (List)this.getProtocol().getSpecies());
    }

    public SpeciesProtocol getBenthosProtocol(Species species) {
        return TuttiProtocols.getSpeciesProtocol((Species)species, (List)this.getProtocol().getBenthos());
    }

    public void init() {
        long t0 = TimeLog.getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Opening persistence service...");
        }
        TuttiConfiguration config = this.context.getConfig();
        TuttiConfiguration.setInstance((TuttiConfiguration)config);
        if (config.isDbExists()) {
            String jdbcUrl = config.getJdbcUrl();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using database at " + jdbcUrl));
            }
            this.driver = TuttiPersistenceServiceLocator.getPersistenceService();
            if (config.isSanityDb()) {
                this.driver.sanityDb();
            }
        } else {
            this.driver = new TuttiPersistenceNoDbImpl();
            this.driver.init();
        }
        TIME_LOG.log(t0, "Persistence driver *" + this.driver.getImplementationName() + "* opened.");
    }

    @Override
    public void close() throws IOException {
        long t0 = TimeLog.getTime();
        String driverName = this.driver.getImplementationName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing persistence Service *" + driverName + "*..."));
        }
        IOUtils.closeQuietly((Closeable)this.driver);
        TIME_LOG.log(t0, "Persistence driver *" + driverName + "* closed.");
    }

    public List<Vessel> getAllVessel() {
        ArrayList targetList = Lists.newArrayList(this.getAllFishingVessel());
        targetList.addAll(this.getAllScientificVessel());
        return targetList;
    }

    public List<Vessel> getAllScientificVessel() {
        return this.driver.getAllScientificVessel();
    }

    public List<Vessel> getAllFishingVessel() {
        return this.driver.getAllFishingVessel();
    }

    public List<Species> getAllSpecies() {
        return this.driver.getAllSpecies();
    }

    public List<Species> getAllReferentSpecies() {
        return this.driver.getAllReferentSpecies();
    }

    public Species getSpeciesByReferenceTaxonId(Integer referenceTaxonId) {
        return this.driver.getSpeciesByReferenceTaxonId(referenceTaxonId);
    }

    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer referenceTaxonId) {
        return this.driver.getSpeciesByReferenceTaxonIdWithVernacularCode(referenceTaxonId);
    }

    public List<Caracteristic> getAllCaracteristic() {
        return this.driver.getAllCaracteristic();
    }

    public List<Caracteristic> getAllCaracteristicWithProtected() {
        return this.driver.getAllCaracteristicWithProtected();
    }

    public List<Caracteristic> getAllCaracteristicForSampleCategory() {
        return this.driver.getAllCaracteristicForSampleCategory();
    }

    public List<Caracteristic> getAllNumericCaracteristic() {
        return this.driver.getAllNumericCaracteristic();
    }

    public List<TuttiLocation> getAllProgramZone() {
        return this.driver.getAllProgramZone();
    }

    public List<TuttiLocation> getAllCountry() {
        return this.driver.getAllCountry();
    }

    public List<TuttiLocation> getAllHarbour() {
        return this.driver.getAllHarbour();
    }

    public TuttiLocation getLocation(String id) {
        return this.driver.getLocation(id);
    }

    public List<Gear> getAllGear() {
        ArrayList targetList = Lists.newArrayList(this.getAllScientificGear());
        targetList.addAll(this.getAllFishingGear());
        return targetList;
    }

    public List<Gear> getAllScientificGear() {
        return this.driver.getAllScientificGear();
    }

    public List<Gear> getAllFishingGear() {
        return this.driver.getAllFishingGear();
    }

    public List<Person> getAllPerson() {
        return this.driver.getAllPerson();
    }

    public List<ObjectType> getAllObjectType() {
        return this.driver.getAllObjectType();
    }

    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        return this.driver.getAllFishingOperationStrata(zoneId);
    }

    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        return this.driver.getAllFishingOperationSubStrata(zoneId, strataId);
    }

    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        return this.driver.getAllFishingOperationLocation(zoneId, strataId, subStrataId);
    }

    public Caracteristic getSizeCategoryCaracteristic() {
        return this.driver.getSizeCategoryCaracteristic();
    }

    public Caracteristic getSexCaracteristic() {
        return this.driver.getSexCaracteristic();
    }

    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.driver.getSortedUnsortedCaracteristic();
    }

    public Caracteristic getMaturityCaracteristic() {
        return this.driver.getMaturityCaracteristic();
    }

    public Caracteristic getAgeCaracteristic() {
        return this.driver.getAgeCaracteristic();
    }

    public Caracteristic getMarineLitterCategoryCaracteristic() {
        return this.driver.getMarineLitterCategoryCaracteristic();
    }

    public Caracteristic getMarineLitterSizeCategoryCaracteristic() {
        return this.driver.getMarineLitterSizeCategoryCaracteristic();
    }

    public Caracteristic getVerticalOpeningCaracteristic() {
        return this.driver.getVerticalOpeningCaracteristic();
    }

    public Caracteristic getHorizontalOpeningWingsCaracteristic() {
        return this.driver.getHorizontalOpeningWingsCaracteristic();
    }

    public Caracteristic getHorizontalOpeningDoorCaracteristic() {
        return this.driver.getHorizontalOpeningDoorCaracteristic();
    }

    public Caracteristic getDeadOrAliveCaracteristic() {
        return this.driver.getDeadOrAliveCaracteristic();
    }

    public Caracteristic getPmfmIdCaracteristic() {
        return this.driver.getPmfmIdCaracteristic();
    }

    public Caracteristic getWeightMeasuredCaracteristic() {
        return this.driver.getWeightMeasuredCaracteristic();
    }

    public Caracteristic getCaracteristic(Integer pmfmId) {
        return this.driver.getCaracteristic(pmfmId);
    }

    public boolean isVracBatch(SpeciesAbleBatch speciesBatch) {
        return this.driver.isVracBatch(speciesBatch);
    }

    public boolean isHorsVracBatch(SpeciesAbleBatch speciesBatch) {
        return this.driver.isHorsVracBatch(speciesBatch);
    }

    public Predicate<SpeciesAbleBatch> getVracBatchPredicate() {
        return this.driver.getVracBatchPredicate();
    }

    public boolean isTemporary(TuttiReferentialEntity entity) {
        return this.driver.isTemporary(entity);
    }

    public Vessel getVessel(String vesselCode) {
        return this.driver.getVessel(vesselCode);
    }

    public Person getPerson(Integer personId) {
        return this.driver.getPerson(personId);
    }

    public Gear getGear(Integer gearCode) {
        return this.driver.getGear(gearCode);
    }

    public ObjectType getObjectType(String objectTypeCode) {
        return this.driver.getObjectType(objectTypeCode);
    }

    public List<Gear> addTemporaryGears(List<Gear> gears) {
        return this.driver.addTemporaryGears(gears);
    }

    public List<Person> addTemporaryPersons(List<Person> persons) {
        return this.driver.addTemporaryPersons(persons);
    }

    public List<Species> addTemporarySpecies(List<Species> species) {
        return this.driver.addTemporarySpecies(species);
    }

    public List<Vessel> addTemporaryVessels(List<Vessel> vessels) {
        return this.driver.addTemporaryVessels(vessels);
    }

    public List<Gear> updateTemporaryGears(List<Gear> gears) {
        return this.driver.updateTemporaryGears(gears);
    }

    public List<Person> updateTemporaryPersons(List<Person> persons) {
        return this.driver.updateTemporaryPersons(persons);
    }

    public List<Species> updateTemporarySpecies(List<Species> species) {
        return this.driver.updateTemporarySpecies(species);
    }

    public List<Vessel> updateTemporaryVessels(List<Vessel> vessels) {
        return this.driver.updateTemporaryVessels(vessels);
    }

    public List<Gear> linkTemporaryGears(List<Gear> gears) {
        return this.driver.linkTemporaryGears(gears);
    }

    public List<Person> linkTemporaryPersons(List<Person> persons) {
        return this.driver.linkTemporaryPersons(persons);
    }

    public List<Species> linkTemporarySpecies(List<Species> specieses) {
        return this.driver.linkTemporarySpecies(specieses);
    }

    public List<Vessel> linkTemporaryVessels(List<Vessel> vessels) {
        return this.driver.linkTemporaryVessels(vessels);
    }

    public void replaceGear(Gear source, Gear target, boolean delete) {
        this.driver.replaceGear(source, target, delete);
    }

    public void replacePerson(Person source, Person target, boolean delete) {
        this.driver.replacePerson(source, target, delete);
    }

    public void replaceSpecies(Species source, Species target, boolean delete) {
        this.driver.replaceSpecies(source, target, delete);
    }

    public void replaceVessel(Vessel source, Vessel target, boolean delete) {
        this.driver.replaceVessel(source, target, delete);
    }

    public void deleteTemporaryGear(Integer id) {
        this.driver.deleteTemporaryGear(id);
    }

    public void deleteTemporaryGears(Collection<Integer> id) {
        this.driver.deleteTemporaryGears(id);
    }

    public void deleteTemporarySpecies(Integer referenceTaxonId) {
        this.driver.deleteTemporarySpecies(referenceTaxonId);
    }

    public void deleteTemporarySpecies(Collection<Integer> referenceTaxonIds) {
        this.driver.deleteTemporarySpecies(referenceTaxonIds);
    }

    public void deleteTemporaryPerson(Integer id) {
        this.driver.deleteTemporaryPerson(id);
    }

    public void deleteTemporaryPersons(Collection<Integer> ids) {
        this.driver.deleteTemporaryPersons(ids);
    }

    public void deleteTemporaryVessel(String code) {
        this.driver.deleteTemporaryVessel(code);
    }

    public void deleteTemporaryVessels(Collection<String> codes) {
        this.driver.deleteTemporaryVessels(codes);
    }

    public boolean isTemporaryPersonUsed(Integer id) {
        return this.driver.isTemporaryPersonUsed(id);
    }

    public boolean isTemporarySpeciesUsed(Integer referenceTaxonId) {
        return this.driver.isTemporarySpeciesUsed(referenceTaxonId);
    }

    public boolean isTemporaryGearUsed(Integer id) {
        return this.driver.isTemporaryGearUsed(id);
    }

    public boolean isTemporaryVesselUsed(String code) {
        return this.driver.isTemporaryVesselUsed(code);
    }

    public String getLocationLabelByLatLong(Float latitude, Float longitude) {
        return this.driver.getLocationLabelByLatLong(latitude, longitude);
    }

    public Integer getLocationIdByLatLong(Float latitude, Float longitude) {
        return this.driver.getLocationIdByLatLong(latitude, longitude);
    }

    public List<Attachment> getAllAttachments(ObjectTypeCode objectType, Integer objectId) {
        return this.driver.getAllAttachments(objectType, objectId);
    }

    public File getAttachmentFile(String attachmentId) {
        return this.driver.getAttachmentFile(attachmentId);
    }

    public Attachment createAttachment(Attachment attachment, File file) {
        return this.driver.createAttachment(attachment, file);
    }

    public Attachment saveAttachment(Attachment attachment) {
        return this.driver.saveAttachment(attachment);
    }

    public void deleteAttachment(String attachmentId) {
        this.driver.deleteAttachment(attachmentId);
    }

    public void deleteAllAttachment(ObjectTypeCode objectType, Integer ... objectIds) {
        this.driver.deleteAllAttachment(objectType, objectIds);
    }

    public List<Program> getAllProgram() {
        return this.driver.getAllProgram();
    }

    public Program getProgram(String id) {
        return this.driver.getProgram(id);
    }

    public Program createProgram(Program bean) {
        return this.driver.createProgram(bean);
    }

    public Program saveProgram(Program bean) {
        return this.driver.saveProgram(bean);
    }

    public List<String> getAllCruiseId(String programId) {
        return this.driver.getAllCruiseId(programId);
    }

    public List<Cruise> getAllCruise(String programId) {
        return this.driver.getAllCruise(programId);
    }

    public Cruise getCruise(String id) {
        return this.driver.getCruise(id);
    }

    public Cruise createCruise(Cruise bean) {
        return this.driver.createCruise(bean);
    }

    public Cruise saveCruise(Cruise bean, boolean updateVessel, boolean updateGear) {
        return this.driver.saveCruise(bean, updateVessel, updateGear);
    }

    public void setCruiseReadyToSynch(Integer cruiseId) {
        this.driver.setCruiseReadyToSynch(cruiseId);
    }

    public CaracteristicMap getGearCaracteristics(String cruiseId, String gearId, short rankOrder) {
        return this.driver.getGearCaracteristics(cruiseId, gearId, rankOrder);
    }

    public boolean isOperationUseGears(Integer cruiseId, Collection<Gear> gears) {
        return this.driver.isOperationUseGears(cruiseId, gears);
    }

    public void saveGearCaracteristics(Gear gear, Cruise cruise) {
        this.driver.saveGearCaracteristics(gear, cruise);
    }

    public TuttiProtocol getProtocol() {
        return this.driver.getProtocol();
    }

    public void setProtocol(TuttiProtocol protocol) {
        this.driver.setProtocol(protocol);
    }

    public boolean isProtocolExist(String id) {
        return this.driver.isProtocolExist(id);
    }

    public List<String> getAllProtocolNames() {
        return this.driver.getAllProtocolNames();
    }

    public String getFirstAvailableName(String protocolName) {
        return this.driver.getFirstAvailableName(protocolName);
    }

    public List<TuttiProtocol> getAllProtocol() {
        return this.driver.getAllProtocol();
    }

    public List<String> getAllProtocolId() {
        return this.driver.getAllProtocolId();
    }

    public TuttiProtocol getProtocol(String id) {
        return this.driver.getProtocol(id);
    }

    public TuttiProtocol getProtocolByName(String protocolName) {
        return this.driver.getProtocolByName(protocolName);
    }

    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        return this.driver.createProtocol(bean);
    }

    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        return this.driver.saveProtocol(bean);
    }

    public void deleteProtocol(String id) {
        this.driver.deleteProtocol(id);
    }

    public int getFishingOperationCount(String cruiseId) {
        return this.driver.getFishingOperationCount(cruiseId);
    }

    public List<String> getAllFishingOperationIds(String cruiseId) {
        return this.driver.getAllFishingOperationIds(cruiseId);
    }

    public List<FishingOperation> getAllFishingOperation(String cruiseId) {
        return this.driver.getAllFishingOperation(cruiseId);
    }

    public FishingOperation getFishingOperation(String id) {
        FishingOperation bean = this.driver.getFishingOperation(id);
        if (bean.getGearShootingEndDate() == null) {
            bean.setGearShootingEndDate(bean.getGearShootingStartDate());
        }
        return bean;
    }

    public List<Vessel> getFishingOperationSecondaryVessel(String fishingOperationId) {
        return this.driver.getFishingOperationSecondaryVessel(fishingOperationId);
    }

    public FishingOperation createFishingOperation(FishingOperation bean) {
        if (Objects.equals(bean.getGearShootingStartDate(), bean.getGearShootingEndDate())) {
            bean.setGearShootingEndDate(null);
        }
        return this.driver.createFishingOperation(bean);
    }

    public FishingOperation saveFishingOperation(FishingOperation bean) {
        if (Objects.equals(bean.getGearShootingStartDate(), bean.getGearShootingEndDate())) {
            bean.setGearShootingEndDate(null);
        }
        return this.driver.saveFishingOperation(bean);
    }

    public Collection<FishingOperation> saveFishingOperations(Collection<FishingOperation> beans) {
        return this.driver.saveFishingOperations(beans);
    }

    public void deleteFishingOperation(String id) {
        this.driver.deleteFishingOperation(id);
    }

    public boolean isFishingOperationWithCatchBatch(String operationId) {
        return this.driver.isFishingOperationWithCatchBatch(operationId);
    }

    public CatchBatch getCatchBatchFromFishingOperation(String id) throws InvalidBatchModelException {
        return this.driver.getCatchBatchFromFishingOperation(id);
    }

    public CatchBatch createCatchBatch(CatchBatch bean) {
        return this.driver.createCatchBatch(bean);
    }

    public CatchBatch saveCatchBatch(CatchBatch bean) {
        return this.driver.saveCatchBatch(bean);
    }

    public void deleteCatchBatch(String fishingOperationId) {
        this.driver.deleteCatchBatch(fishingOperationId);
    }

    public void recomputeCatchBatchSampleRatios(String fishingOperationId) {
        this.driver.recomputeCatchBatchSampleRatios(fishingOperationId);
    }

    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String fishingOperationId, boolean validateTree) {
        return this.driver.getRootSpeciesBatch(fishingOperationId, validateTree);
    }

    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        return this.driver.createSpeciesBatch(bean, parentBatchId);
    }

    public Collection<SpeciesBatch> createSpeciesBatches(String fishingOperationId, Collection<SpeciesBatch> beans) {
        return this.driver.createSpeciesBatches(fishingOperationId, beans);
    }

    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.driver.saveSpeciesBatch(bean);
    }

    public void deleteSpeciesBatch(String id) {
        this.driver.deleteSpeciesBatch(id);
    }

    public void deleteSpeciesSubBatch(String id) {
        this.driver.deleteSpeciesSubBatch(id);
    }

    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        this.driver.changeSpeciesBatchSpecies(batchId, species);
    }

    public List<SpeciesBatch> getAllSpeciesBatchToConfirm(String fishingOperationId) throws InvalidBatchModelException {
        return this.driver.getAllSpeciesBatchToConfirm(fishingOperationId);
    }

    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        return this.driver.getAllSpeciesBatchFrequency(speciesBatchId);
    }

    public Multimap<Species, SpeciesBatchFrequency> getAllSpeciesBatchFrequencyForBatch(BatchContainer<SpeciesBatch> batchContainer) {
        return this.driver.getAllSpeciesBatchFrequencyForBatch(batchContainer);
    }

    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.driver.saveSpeciesBatchFrequency(speciesBatchId, frequencies);
    }

    public BatchContainer<BenthosBatch> getRootBenthosBatch(String fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        return this.driver.getRootBenthosBatch(fishingOperationId, validateTree);
    }

    public BenthosBatch createBenthosBatch(BenthosBatch bean, String parentBatchId) {
        return this.driver.createBenthosBatch(bean, parentBatchId);
    }

    public Collection<BenthosBatch> createBenthosBatches(String fishingOperationId, Collection<BenthosBatch> beans) {
        return this.driver.createBenthosBatches(fishingOperationId, beans);
    }

    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        return this.driver.saveBenthosBatch(bean);
    }

    public void deleteBenthosBatch(String id) {
        this.driver.deleteBenthosBatch(id);
    }

    public void deleteBenthosSubBatch(String id) {
        this.driver.deleteBenthosSubBatch(id);
    }

    public void changeBenthosBatchSpecies(String batchId, Species species) {
        this.driver.changeBenthosBatchSpecies(batchId, species);
    }

    public List<BenthosBatch> getAllBenthosBatchToConfirm(String fishingOperationId) throws InvalidBatchModelException {
        return this.driver.getAllBenthosBatchToConfirm(fishingOperationId);
    }

    public List<BenthosBatchFrequency> getAllBenthosBatchFrequency(String benthosBatchId) {
        return this.driver.getAllBenthosBatchFrequency(benthosBatchId);
    }

    public Multimap<Species, BenthosBatchFrequency> getAllBenthosBatchFrequencyForBatch(BatchContainer<BenthosBatch> batchContainer) {
        return this.driver.getAllBenthosBatchFrequencyForBatch(batchContainer);
    }

    public List<BenthosBatchFrequency> saveBenthosBatchFrequency(String benthosBatchId, List<BenthosBatchFrequency> frequencies) {
        return this.driver.saveBenthosBatchFrequency(benthosBatchId, frequencies);
    }

    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch(String fishingOperationId) {
        return this.driver.getRootMarineLitterBatch(fishingOperationId);
    }

    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch bean) {
        return this.driver.createMarineLitterBatch(bean);
    }

    public Collection<MarineLitterBatch> createMarineLitterBatches(String fishingOperationId, Collection<MarineLitterBatch> beans) {
        return this.driver.createMarineLitterBatches(fishingOperationId, beans);
    }

    public MarineLitterBatch saveMarineLitterBatch(MarineLitterBatch bean) {
        return this.driver.saveMarineLitterBatch(bean);
    }

    public void deleteMarineLitterBatch(String id) {
        this.driver.deleteMarineLitterBatch(id);
    }

    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        return this.driver.getAllAccidentalBatch(fishingOperationId);
    }

    public Collection<AccidentalBatch> createAccidentalBatches(String fishingOperationId, Collection<AccidentalBatch> beans) {
        return this.driver.createAccidentalBatches(fishingOperationId, beans);
    }

    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        return this.driver.createAccidentalBatch(bean);
    }

    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        return this.driver.saveAccidentalBatch(bean);
    }

    public void deleteAccidentalBatch(String id) {
        this.driver.deleteAccidentalBatch(id);
    }

    public void deleteAccidentalBatchForFishingOperation(String fishingOperationId) {
        this.driver.deleteAccidentalBatchForFishingOperation(fishingOperationId);
    }

    public List<IndividualObservationBatch> getAllIndividualObservationBatch(String fishingOperationId) {
        return this.driver.getAllIndividualObservationBatch(fishingOperationId);
    }

    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.driver.createIndividualObservationBatch(bean);
    }

    public Collection<IndividualObservationBatch> createIndividualObservationBatches(String fishingOperationId, Collection<IndividualObservationBatch> beans) {
        return this.driver.createIndividualObservationBatches(fishingOperationId, beans);
    }

    public IndividualObservationBatch saveIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.driver.saveIndividualObservationBatch(bean);
    }

    public void deleteIndividualObservationBatch(String id) {
        this.driver.deleteIndividualObservationBatch(id);
    }

    public void deleteIndividualObservationBatchForFishingOperation(String fishingOperationId) {
        this.driver.deleteIndividualObservationBatchForFishingOperation(fishingOperationId);
    }

    public static enum ImportStructureType {
        NORMAL,
        INLINE;

    }

    public static interface FrequencyFunction<S extends SpeciesAbleBatch, F extends SpeciesAbleBatchFrequency>
    extends Function<S, List<F>> {
    }
}

