/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential.actions;

import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryVesselService;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import fr.ifremer.tutti.ui.swing.content.referential.actions.ImportTemporaryActionSupport;
import java.io.File;
import org.nuiton.i18n.I18n;

public class ImportTemporaryVesselAction
extends ImportTemporaryActionSupport<Vessel> {
    public ImportTemporaryVesselAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler);
    }

    @Override
    protected File chooseImportFile() {
        File file = this.chooseFile(I18n.t((String)"tutti.manageTemporaryReferential.title.choose.importTemporaryVesselFile", (Object[])new Object[0]), I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialVesselFile.import", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
        return file;
    }

    @Override
    protected ReferentialImportResult<Vessel> doImport(File file) {
        ReferentialTemporaryVesselService service = this.getContext().getReferentialTemporaryVesselService();
        ReferentialImportResult result = service.importTemporaryVessel(file);
        return result;
    }

    @Override
    protected void postSuccessAction(File file, ReferentialImportResult<Vessel> result) {
        int nbRef = ((ManageTemporaryReferentialUIModel)this.getModel()).getNbTemporaryVessels();
        ((ManageTemporaryReferentialUIModel)this.getModel()).setNbTemporaryVessels(nbRef + result.getNbRefAdded() - result.getNbRefDeleted());
        this.getDataContext().resetVessels();
        this.reloadCruise();
        this.reloadFishingOperation();
        ((ManageTemporaryReferentialUIHandler)this.getHandler()).resetExportVesselsAction();
        String title = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialVesselFile.import.dialog.title", (Object[])new Object[0]);
        String message = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialVesselFile.import.dialog.message", (Object[])new Object[]{result.getNbRefAdded(), result.getNbRefUpdated(), result.getNbRefDeleted()});
        this.displayInfoMessage(title, message);
        this.sendMessage(I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialVesselFile.import.success", (Object[])new Object[]{file}));
    }
}

