/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.catches;

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.catches.EnterWeightUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.nuiton.i18n.I18n;

public class EnterWeightUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, EnterWeightUI> {
    public static final String CANCEL_ACTION = "cancelAction";
    public static final String VALIDATE_ACTION = "validateAction";

    public void onCloseUI() {
    }

    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void afterInit(EnterWeightUI ui) {
        this.initUI(ui);
        AbstractAction cancelAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Float originalWeight = ((EnterWeightUI)EnterWeightUIHandler.this.getUI()).getOriginalWeight();
                ((EnterWeightUI)EnterWeightUIHandler.this.getUI()).editor.getModel().setNumberValue((Number)originalWeight);
                ((EnterWeightUI)EnterWeightUIHandler.this.getUI()).dispose();
            }
        };
        JButton cancelButton = ui.getCancelButton();
        TuttiUIUtil.prepareAction(cancelButton, cancelAction, CANCEL_ACTION);
        AbstractAction validateAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((EnterWeightUI)EnterWeightUIHandler.this.getUI()).dispose();
            }
        };
        JButton validateButton = ui.getValidateButton();
        TuttiUIUtil.prepareAction(validateButton, validateAction, VALIDATE_ACTION);
        JRootPane rootPane = ui.getRootPane();
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_ACTION);
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), VALIDATE_ACTION);
        rootPane.getActionMap().put(CANCEL_ACTION, cancelAction);
        rootPane.getActionMap().put(VALIDATE_ACTION, validateAction);
        ui.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component)e.getSource();
                JAXXUtil.destroy((Component)ui);
            }
        });
        this.initUI(ui);
    }

    protected Float openAndGetWeightValue(String weightLabel, Float weight, WeightUnit weightUnit) {
        ((EnterWeightUI)this.ui).setWeightLabel(weightLabel);
        ((EnterWeightUI)this.ui).setOriginalWeight(weight);
        ((EnterWeightUI)this.ui).setWeightUnit(weightUnit);
        SwingUtil.center((Component)this.getContext().getMainUI(), (Component)((Component)this.ui));
        ((EnterWeightUI)this.ui).pack();
        ((EnterWeightUI)this.ui).getEditor().requestFocusInWindow();
        ((EnterWeightUI)this.ui).setVisible(true);
        Number enteredWeight = ((EnterWeightUI)this.ui).getEditor().getModel().getNumberValue();
        return enteredWeight == null ? null : Float.valueOf(enteredWeight.floatValue());
    }

    protected String getTitle(String weightLabel, WeightUnit weightUnit) {
        return weightUnit.decorateLabel(I18n.t((String)"tutti.catches.enterWeight.title", (Object[])new Object[]{weightLabel}));
    }
}

