/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.actions;

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUI;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUIHandler;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUIModel;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class GenericFormatImportAction
extends AbstractTuttiAction<GenericFormatImportUIModel, GenericFormatImportUI, GenericFormatImportUIHandler> {
    private static final Log log = LogFactory.getLog(GenericFormatImportAction.class);
    public static final DateFormat df = new SimpleDateFormat("yyy-MM-dd-hh-mm");
    private File backupFile;
    private GenericFormatImportResult importResult;

    public GenericFormatImportAction(GenericFormatImportUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            doAction = ((GenericFormatImportUIModel)this.getModel()).isCanValidate();
        }
        if (doAction && !this.getConfig().isGenericFormatImportSkipBackup()) {
            this.backupFile = this.saveFileWithStartDirectory(this.getConfig().getDbBackupDirectory(), false, "tutti-db-" + df.format(new Date()), "zip", I18n.t((String)"tutti.genericFormat.title.choose.dbBackupFile", (Object[])new Object[0]), I18n.t((String)"tutti.genericFormat.action.chooseDbBackupFile", (Object[])new Object[0]), new String[]{"^.+\\.zip$", I18n.t((String)"tutti.common.file.genericFormat", (Object[])new Object[0])});
            if (this.backupFile == null) {
                this.displayWarningMessage(I18n.t((String)"tutti.dbManager.title.backup.db", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.importdb.no.backup.db.choosen", (Object[])new Object[0]));
                doAction = false;
            }
        }
        if (doAction) {
            this.updateResult(null);
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        ((GenericFormatImportUIModel)this.getModel()).setImportReportFile(this.getConfig().newTempFile("genericFormatImportReport", "pdf"));
        GenericFormatImportConfiguration configuration = ((GenericFormatImportUIModel)this.getModel()).toImportConfiguration();
        GenericFormatImportService service = this.getContext().getGenericFormatImportService();
        boolean doBackup = !this.getConfig().isGenericFormatImportSkipBackup() && this.backupFile != null;
        int nbSteps = service.getImportProgramNbSteps(configuration);
        if (doBackup) {
            nbSteps += 3;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Import nb steps: " + nbSteps));
        }
        this.createProgressionModelIfRequired(nbSteps);
        if (doBackup) {
            this.getProgressionModel().increments(I18n.t((String)"tutti.genericFormatImport.step.closeDb", (Object[])new Object[0]));
            this.getContext().closePersistenceService();
            this.getProgressionModel().increments(I18n.t((String)"tutti.genericFormatImport.step.backupDb", (Object[])new Object[]{this.backupFile}));
            this.getContext().getPersistenceService().exportDb(this.backupFile);
            this.getProgressionModel().increments(I18n.t((String)"tutti.genericFormatImport.step.reopenDb", (Object[])new Object[]{this.backupFile}));
            this.getContext().openPersistenceService();
            service = this.getContext().getGenericFormatImportService();
        }
        Program program = ((GenericFormatImportUIModel)this.getModel()).getProgram();
        File importFile = ((GenericFormatImportUIModel)this.getModel()).getImportFile();
        if (log.isInfoEnabled()) {
            log.info((Object)("Do generic format import for program: " + program.getName() + " from file: " + importFile));
        }
        this.importResult = service.importProgram(configuration, this.getProgressionModel());
    }

    public void postSuccessAction() {
        this.updateResult(this.importResult);
    }

    public void releaseAction() {
        this.backupFile = null;
        this.importResult = null;
        super.releaseAction();
    }

    protected void updateResult(GenericFormatImportResult result) {
        ((GenericFormatImportUIModel)this.getModel()).setImportResult(result);
        if (result != null) {
            String tip;
            String text;
            ImageIcon icon;
            if (result.isValid()) {
                icon = SwingUtil.createActionIcon((String)"accept");
                text = I18n.t((String)"tutti.genericFormat.import.success", (Object[])new Object[0]);
                tip = I18n.t((String)"tutti.genericFormat.import.success.tip", (Object[])new Object[0]);
            } else {
                icon = SwingUtil.createActionIcon((String)"cancel");
                text = I18n.t((String)"tutti.genericFormat.import.error", (Object[])new Object[0]);
                tip = I18n.t((String)"tutti.genericFormat.import.error.tip", (Object[])new Object[0]);
            }
            JLabel resultText = ((GenericFormatImportUI)this.getUI()).getImportResultText();
            resultText.setIcon(icon);
            resultText.setText(text);
            resultText.setToolTipText(tip);
        }
    }
}

