/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryGearService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryPersonService;
import fr.ifremer.tutti.service.referential.ReferentialTemporarySpeciesService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryVesselService;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public abstract class GenericFormatServiceSupport
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(GenericFormatServiceSupport.class);
    protected PersistenceService persistenceService;
    protected WeightComputingService weightComputingService;
    protected ReferentialTemporaryGearService referentialTemporaryGearService;
    protected ReferentialTemporaryPersonService referentialTemporaryPersonService;
    protected ReferentialTemporarySpeciesService referentialTemporarySpeciesService;
    protected ReferentialTemporaryVesselService referentialTemporaryVesselService;
    protected ProtocolImportExportService protocolImportExportService;
    protected Decorator<FishingOperation> fishingOperationDecorator;
    protected Decorator<Cruise> cruiseDecorator;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
        this.referentialTemporaryGearService = this.getService(ReferentialTemporaryGearService.class);
        this.referentialTemporaryPersonService = this.getService(ReferentialTemporaryPersonService.class);
        this.referentialTemporarySpeciesService = this.getService(ReferentialTemporarySpeciesService.class);
        this.referentialTemporaryVesselService = this.getService(ReferentialTemporaryVesselService.class);
        this.protocolImportExportService = this.getService(ProtocolImportExportService.class);
        DecoratorService decoratorService = this.getService(DecoratorService.class);
        this.cruiseDecorator = decoratorService.getDecoratorByType(Cruise.class);
        this.fishingOperationDecorator = decoratorService.getDecoratorByType(FishingOperation.class);
    }

    public Set<String> checkFishingOperation(String fishingOperationId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will check operation: " + fishingOperationId));
        }
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        if (!withCatchBatch) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skip fishing operation " + fishingOperationId + " since no catchBatch associated."));
            }
        } else {
            BatchContainer<MarineLitterBatch> rootMarineLitterBatch;
            BatchContainer<BenthosBatch> rootBenthosBatch;
            BatchContainer<SpeciesBatch> rootSpeciesBatch;
            try {
                rootSpeciesBatch = this.weightComputingService.getComputedSpeciesBatches(fishingOperationId);
            }
            catch (ApplicationBusinessException e) {
                errors.add(e.getMessage());
                rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, false);
            }
            try {
                rootBenthosBatch = this.weightComputingService.getComputedBenthosBatches(fishingOperationId);
            }
            catch (ApplicationBusinessException e) {
                errors.add(e.getMessage());
                rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, false);
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(fishingOperationId);
            try {
                Float weight = catchBatch == null ? null : catchBatch.getMarineLitterTotalWeight();
                rootMarineLitterBatch = this.weightComputingService.getComputedMarineLitterBatches(fishingOperationId, weight);
            }
            catch (ApplicationBusinessException e) {
                errors.add(e.getMessage());
                rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
            }
            try {
                if (catchBatch != null) {
                    this.weightComputingService.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, rootMarineLitterBatch);
                }
            }
            catch (ApplicationBusinessException e) {
                errors.add(e.getMessage());
            }
        }
        return errors;
    }
}

