/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.data.oda.excel.ResultSetMetaDataHelper;
import org.eclipse.birt.report.data.oda.excel.impl.i18n.Messages;
import org.eclipse.birt.report.data.oda.excel.impl.util.DataTypes;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSetMetaData
implements IResultSetMetaData {
    private String[] columnNames = null;
    private String[] columnTypeNames = null;
    private Map<String, Integer> columnNameIndexMap = new HashMap<String, Integer>();

    public ResultSetMetaData(String[] columnNames, String[] columnTypeNames) {
        this.columnNames = columnNames;
        this.columnTypeNames = columnTypeNames;
        int i = 0;
        while (i < columnNames.length) {
            this.columnNameIndexMap.put(columnNames[i].toUpperCase(), i + 1);
            ++i;
        }
    }

    public ResultSetMetaData(ResultSetMetaDataHelper rsmdHelper) throws OdaException {
        if (rsmdHelper == null) {
            throw new OdaException(Messages.getString("common_ARGUMENT_CANNOT_BE_NULL"));
        }
        this.columnNames = rsmdHelper.getColumnNames();
        this.columnTypeNames = rsmdHelper.getColumnTypes();
        int i = 0;
        while (i < this.columnNames.length) {
            this.columnNameIndexMap.put(this.columnNames[i].toUpperCase(), i + 1);
            ++i;
        }
    }

    public int getColumnCount() throws OdaException {
        return this.columnNames.length;
    }

    public String getColumnName(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnNames[index - 1].trim();
    }

    private void validateColumnIndex(int index) throws OdaException {
        if (index > this.getColumnCount() || index < 1) {
            throw new OdaException("INVALID_COLUMN_INDEX" + index);
        }
    }

    public String getColumnLabel(int index) throws OdaException {
        return this.getColumnName(index);
    }

    public int getColumnType(int index) throws OdaException {
        this.validateColumnIndex(index);
        return DataTypes.getTypeCode(this.columnTypeNames[index - 1]);
    }

    public String getColumnTypeName(int index) throws OdaException {
        int nativeTypeCode = this.getColumnType(index);
        return DataTypes.getNativeDataTypeName(nativeTypeCode);
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        return 0;
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 2;
    }

    public int findColumn(String columnName) throws OdaException {
        String trimmedColumnName = columnName.trim();
        Integer index = this.columnNameIndexMap.get(trimmedColumnName.toUpperCase());
        if (index == null) {
            throw new OdaException("resultSet_COLUMN_NOT_FOUND " + columnName);
        }
        return index;
    }
}

