package fr.ifremer.tutti.ui.swing.content.genericformat;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class GenericFormatImportUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<GenericFormatImportUIModel, GenericFormatImportUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CHECK_WEIGHTS_CHECK_BOX_SELECTED = "checkWeightsCheckBox.selected";
    public static final String BINDING_CLEAN_WEIGHTS_CHECK_BOX_SELECTED = "cleanWeightsCheckBox.selected";
    public static final String BINDING_IMPORT_BUTTON_ENABLED = "importButton.enabled";
    public static final String BINDING_IMPORT_FILE_SELECTED_FILE = "importFile.selectedFile";
    public static final String BINDING_IMPORT_PANEL_VISIBLE = "importPanel.visible";
    public static final String BINDING_IMPORT_RESULT_PANEL_VISIBLE = "importResultPanel.visible";
    public static final String BINDING_OVERRIDE_DATA_CHECK_BOX_SELECTED = "overrideDataCheckBox.selected";
    public static final String BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM = "programComboBox.selectedItem";
    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";
    public static final String BINDING_VALIDATE_RESULT_PANEL_VISIBLE = "validateResultPanel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(GenericFormatImportUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JCheckBox checkWeightsCheckBox;
    protected JCheckBox cleanWeightsCheckBox;
    protected JButton closeButton;
    protected GenericFormatImportUI genericFormatImportTopPanel = this;
    protected final GenericFormatImportUIHandler handler = createHandler();
    protected JButton importButton;
    @ValidatorField( validatorId = "validator",  propertyName = "importFile",  editorName = "importFile")
    protected FileEditor importFile;
    protected JLabel importFileLabel;
    protected Table importPanel;
    protected JPanel importResultPanel;
    protected JLabel importResultText;
    protected GenericFormatImportUIModel model;
    protected JButton openImportReportButton;
    protected JButton openValidateReportButton;
    protected JCheckBox overrideDataCheckBox;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programComboBox")
    protected BeanFilterableComboBox<Program> programComboBox;
    protected JLabel programLabel;
    protected JButton saveImportReportButton;
    protected JButton saveValidateReportButton;
    protected JButton validateButton;
    protected Table validateFilePanel;
    protected JPanel validateResultPanel;
    protected JLabel validateResultText;
    @Validator( validatorId = "validator")
    protected SwingValidator<GenericFormatImportUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JToolBar $JToolBar0;
    private JToolBar $JToolBar1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public GenericFormatImportUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public GenericFormatImportUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GenericFormatImportUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public GenericFormatImportUI() {
        $initialize();
    }

    public GenericFormatImportUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public GenericFormatImportUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public GenericFormatImportUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public GenericFormatImportUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public GenericFormatImportUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__importFile(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setFile(event, "importFile");
    }

    public void doItemStateChanged__on__checkWeightsCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "checkWeights");
    }

    public void doItemStateChanged__on__cleanWeightsCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "cleanWeights");
    }

    public void doItemStateChanged__on__overrideDataCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "overrideData");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JCheckBox getCheckWeightsCheckBox() {
        return checkWeightsCheckBox;
    }

    public JCheckBox getCleanWeightsCheckBox() {
        return cleanWeightsCheckBox;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public GenericFormatImportUIHandler getHandler() {
        return handler;
    }

    public JButton getImportButton() {
        return importButton;
    }

    public FileEditor getImportFile() {
        return importFile;
    }

    public JLabel getImportFileLabel() {
        return importFileLabel;
    }

    public Table getImportPanel() {
        return importPanel;
    }

    public JPanel getImportResultPanel() {
        return importResultPanel;
    }

    public JLabel getImportResultText() {
        return importResultText;
    }

    public GenericFormatImportUIModel getModel() {
        return model;
    }

    public JButton getOpenImportReportButton() {
        return openImportReportButton;
    }

    public JButton getOpenValidateReportButton() {
        return openValidateReportButton;
    }

    public JCheckBox getOverrideDataCheckBox() {
        return overrideDataCheckBox;
    }

    public BeanFilterableComboBox<Program> getProgramComboBox() {
        return programComboBox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public JButton getSaveImportReportButton() {
        return saveImportReportButton;
    }

    public JButton getSaveValidateReportButton() {
        return saveValidateReportButton;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public Table getValidateFilePanel() {
        return validateFilePanel;
    }

    public JPanel getValidateResultPanel() {
        return validateResultPanel;
    }

    public JLabel getValidateResultText() {
        return validateResultText;
    }

    public SwingValidator<GenericFormatImportUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected JToolBar get$JToolBar1() {
        return $JToolBar1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToGenericFormatImportTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(validateFilePanel, BorderLayout.NORTH);
        add(importPanel, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToImportPanel() {
        if (!allComponentsCreated) {
            return;
        }
        importPanel.add($JPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        importPanel.add($JPanel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
        importPanel.add(importResultPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToImportResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        importResultPanel.add(importResultText, BorderLayout.WEST);
        importResultPanel.add($JToolBar1, BorderLayout.EAST);
    }

    protected void addChildrenToValidateFilePanel() {
        if (!allComponentsCreated) {
            return;
        }
        validateFilePanel.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add(SwingUtil.boxComponentWithJxLayer(programComboBox), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add(importFileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add(SwingUtil.boxComponentWithJxLayer(importFile), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add($JPanel1, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        validateFilePanel.add(validateResultPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidateResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        validateResultPanel.add(validateResultText, BorderLayout.WEST);
        validateResultPanel.add($JToolBar0, BorderLayout.EAST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.genericFormatimport.help"));
    }

    protected void createCheckWeightsCheckBox() {
        $objectMap.put("checkWeightsCheckBox", checkWeightsCheckBox = new JCheckBox());
        
        checkWeightsCheckBox.setName("checkWeightsCheckBox");
        checkWeightsCheckBox.setText(t("tutti.genericFormatImport.field.checkWeights"));
        checkWeightsCheckBox.setToolTipText(t("tutti.genericFormatImport.field.checkWeights.tip"));
        checkWeightsCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__checkWeightsCheckBox"));
        checkWeightsCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.checkWeights.help");
    }

    protected void createCleanWeightsCheckBox() {
        $objectMap.put("cleanWeightsCheckBox", cleanWeightsCheckBox = new JCheckBox());
        
        cleanWeightsCheckBox.setName("cleanWeightsCheckBox");
        cleanWeightsCheckBox.setText(t("tutti.genericFormatImport.field.cleanWeights"));
        cleanWeightsCheckBox.setToolTipText(t("tutti.genericFormatImport.field.cleanWeights.tip"));
        cleanWeightsCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__cleanWeightsCheckBox"));
        cleanWeightsCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.cleanWeights.help");
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.genericFormatImport.action.closeGenericFormatImport"));
        closeButton.setToolTipText(t("tutti.genericFormatImport.action.closeGenericFormatImport.tip"));
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SelectCruiseAction.class);
        closeButton.putClientProperty("help", "tutti.genericFormatImport.action.closeGenericFormatImport.help");
    }

    protected GenericFormatImportUIHandler createHandler() {
        return new GenericFormatImportUIHandler();
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new JButton());
        
        importButton.setName("importButton");
        importButton.setText(t("tutti.genericFormatImport.action.import"));
        importButton.setToolTipText(t("tutti.genericFormatImport.action.import.tip"));
        importButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.GenericFormatImportAction.class);
        importButton.putClientProperty("help", "tutti.genericFormatImport.action.import.help");
    }

    protected void createImportFile() {
        $objectMap.put("importFile", importFile = new FileEditor());
        
        importFile.setName("importFile");
        importFile.setShowReset(true);
        importFile.setAcceptAllFileFilterUsed(false);
        importFile.setDirectoryEnabled(false);
        importFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importFile"));
    }

    protected void createImportFileLabel() {
        $objectMap.put("importFileLabel", importFileLabel = new JLabel());
        
        importFileLabel.setName("importFileLabel");
        importFileLabel.setText(t("tutti.genericFormatImport.field.importFile"));
        importFileLabel.setToolTipText(t("tutti.genericFormatImport.field.importFile.tip"));
    }

    protected void createImportPanel() {
        $objectMap.put("importPanel", importPanel = new Table());
        
        importPanel.setName("importPanel");
    }

    protected void createImportResultPanel() {
        $objectMap.put("importResultPanel", importResultPanel = new JPanel());
        
        importResultPanel.setName("importResultPanel");
        importResultPanel.setLayout(new BorderLayout());
        importResultPanel.putClientProperty("help", "tutti.genericFormatImport.field.importResult.help");
    }

    protected void createImportResultText() {
        $objectMap.put("importResultText", importResultText = new JLabel());
        
        importResultText.setName("importResultText");
        importResultText.putClientProperty("help", "tutti.genericFormatImport.field.importResult.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(GenericFormatImportUIModel.class));
    }

    protected void createOpenImportReportButton() {
        $objectMap.put("openImportReportButton", openImportReportButton = new JButton());
        
        openImportReportButton.setName("openImportReportButton");
        openImportReportButton.setToolTipText(t("tutti.genericFormatImport.action.openImportReport.tip"));
        openImportReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.OpenGenericFormatImportReportAction.class);
        openImportReportButton.putClientProperty("help", "tutti.genericFormatImport.action.openImportReport.help");
    }

    protected void createOpenValidateReportButton() {
        $objectMap.put("openValidateReportButton", openValidateReportButton = new JButton());
        
        openValidateReportButton.setName("openValidateReportButton");
        openValidateReportButton.setToolTipText(t("tutti.genericFormatImport.action.openValidateReport.tip"));
        openValidateReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.OpenGenericFormatValidateReportAction.class);
        openValidateReportButton.putClientProperty("help", "tutti.genericFormatImport.action.openValidateReport.help");
    }

    protected void createOverrideDataCheckBox() {
        $objectMap.put("overrideDataCheckBox", overrideDataCheckBox = new JCheckBox());
        
        overrideDataCheckBox.setName("overrideDataCheckBox");
        overrideDataCheckBox.setText(t("tutti.genericFormatImport.field.overrideData"));
        overrideDataCheckBox.setToolTipText(t("tutti.genericFormatImport.field.overrideData.tip"));
        overrideDataCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__overrideDataCheckBox"));
        overrideDataCheckBox.putClientProperty("help", "tutti.genericFormatImport.field.overrideData.help");
    }

    protected void createProgramComboBox() {
        $objectMap.put("programComboBox", programComboBox = new BeanFilterableComboBox<Program>(this));
        
        programComboBox.setName("programComboBox");
        programComboBox.setProperty("program");
        programComboBox.setShowReset(true);
        programComboBox.putClientProperty("help", "tutti.genericFormatImport.field.program.help");
        programComboBox.putClientProperty("validatorLabel", t("tutti.genericFormatImport.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(t("tutti.genericFormatImport.field.program"));
        programLabel.setToolTipText(t("tutti.genericFormatImport.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.genericFormatImport.field.program.help");
    }

    protected void createSaveImportReportButton() {
        $objectMap.put("saveImportReportButton", saveImportReportButton = new JButton());
        
        saveImportReportButton.setName("saveImportReportButton");
        saveImportReportButton.setToolTipText(t("tutti.genericFormatImport.action.saveImportReport.tip"));
        saveImportReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.SaveGenericFormatImportReportAction.class);
        saveImportReportButton.putClientProperty("help", "tutti.genericFormatImport.action.saveImportReport.help");
    }

    protected void createSaveValidateReportButton() {
        $objectMap.put("saveValidateReportButton", saveValidateReportButton = new JButton());
        
        saveValidateReportButton.setName("saveValidateReportButton");
        saveValidateReportButton.setToolTipText(t("tutti.genericFormatImport.action.saveValidateReport.tip"));
        saveValidateReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.SaveGenericFormatValidateReportAction.class);
        saveValidateReportButton.putClientProperty("help", "tutti.genericFormatValidate.action.saveValidateReport.help");
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("tutti.genericFormatImport.action.validate"));
        validateButton.setToolTipText(t("tutti.genericFormatImport.action.validate.tip"));
        validateButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.genericformat.actions.GenericFormatValidateAction.class);
        validateButton.putClientProperty("help", "tutti.genericFormatImport.action.validate.help");
    }

    protected void createValidateFilePanel() {
        $objectMap.put("validateFilePanel", validateFilePanel = new Table());
        
        validateFilePanel.setName("validateFilePanel");
    }

    protected void createValidateResultPanel() {
        $objectMap.put("validateResultPanel", validateResultPanel = new JPanel());
        
        validateResultPanel.setName("validateResultPanel");
        validateResultPanel.setLayout(new BorderLayout());
        validateResultPanel.putClientProperty("help", "tutti.genericFormatImport.field.validateResult.help");
    }

    protected void createValidateResultText() {
        $objectMap.put("validateResultText", validateResultText = new JLabel());
        
        validateResultText.setName("validateResultText");
        validateResultText.putClientProperty("help", "tutti.genericFormatImport.field.validateResult.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(GenericFormatImportUIModel.class, "edit"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToGenericFormatImportTopPanel();
        addChildrenToValidator();
        addChildrenToValidateFilePanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(overrideDataCheckBox);
        // inline complete setup of $JPanel1
        $JPanel1.add(validateButton);
        addChildrenToValidateResultPanel();
        // inline complete setup of $JToolBar0
        $JToolBar0.add(openValidateReportButton);
        $JToolBar0.add(saveValidateReportButton);
        addChildrenToImportPanel();
        // inline complete setup of $JPanel2
        $JPanel2.add(cleanWeightsCheckBox);
        $JPanel2.add(checkWeightsCheckBox);
        // inline complete setup of $JPanel3
        $JPanel3.add(importButton);
        addChildrenToImportResultPanel();
        // inline complete setup of $JToolBar1
        $JToolBar1.add(openImportReportButton);
        $JToolBar1.add(saveImportReportButton);
        // inline complete setup of $Table0
        $Table0.add($JPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel4
        $JPanel4.add(closeButton);
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 26 property setters
        programComboBox.setBeanType(Program.class);
        validateFilePanel.setBorder(BorderFactory.createTitledBorder(t("tutti.genericFormatImport.validateImport.legend")));
        programLabel.setLabelFor(programComboBox);
        programComboBox.setBean(model);
        importFileLabel.setLabelFor(importFile);
        importFile.setExts(t("tutti.genericFormatImport.importFile.extension"));
        importFile.setExtsDescription(t("tutti.genericFormatImport.importFile.extension.description"));
        validateButton.setIcon(SwingUtil.createActionIcon("validate"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.genericFormatImport.action.validate.mnemonic"),'Z'));
        openValidateReportButton.setIcon(SwingUtil.createActionIcon("open-file"));
        saveValidateReportButton.setIcon(SwingUtil.createActionIcon("save"));
        importPanel.setBorder(BorderFactory.createTitledBorder(t("tutti.genericFormatImport.import.legend")));
        importButton.setIcon(SwingUtil.createActionIcon("import"));
        importButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.genericFormatImport.action.import.mnemonic"),'Z'));
        openImportReportButton.setIcon(SwingUtil.createActionIcon("open-file"));
        saveImportReportButton.setIcon(SwingUtil.createActionIcon("save"));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.genericFormatImport.action.closeGenericFormatImport.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, genericFormatImportTopPanel, "tutti.genericFormatImport.help");
        registerHelpId(_broker, programLabel, "tutti.genericFormatImport.field.program.help");
        registerHelpId(_broker, programComboBox, "tutti.genericFormatImport.field.program.help");
        registerHelpId(_broker, overrideDataCheckBox, "tutti.genericFormatImport.field.overrideData.help");
        registerHelpId(_broker, validateButton, "tutti.genericFormatImport.action.validate.help");
        registerHelpId(_broker, validateResultPanel, "tutti.genericFormatImport.field.validateResult.help");
        registerHelpId(_broker, validateResultText, "tutti.genericFormatImport.field.validateResult.help");
        registerHelpId(_broker, openValidateReportButton, "tutti.genericFormatImport.action.openValidateReport.help");
        registerHelpId(_broker, saveValidateReportButton, "tutti.genericFormatValidate.action.saveValidateReport.help");
        registerHelpId(_broker, cleanWeightsCheckBox, "tutti.genericFormatImport.field.cleanWeights.help");
        registerHelpId(_broker, checkWeightsCheckBox, "tutti.genericFormatImport.field.checkWeights.help");
        registerHelpId(_broker, importButton, "tutti.genericFormatImport.action.import.help");
        registerHelpId(_broker, importResultPanel, "tutti.genericFormatImport.field.importResult.help");
        registerHelpId(_broker, importResultText, "tutti.genericFormatImport.field.importResult.help");
        registerHelpId(_broker, openImportReportButton, "tutti.genericFormatImport.action.openImportReport.help");
        registerHelpId(_broker, saveImportReportButton, "tutti.genericFormatImport.action.saveImportReport.help");
        registerHelpId(_broker, closeButton, "tutti.genericFormatImport.action.closeGenericFormatImport.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("genericFormatImportTopPanel", genericFormatImportTopPanel);
        createModel();
        createBroker();
        createValidator();
        createValidateFilePanel();
        createProgramLabel();
        createProgramComboBox();
        createImportFileLabel();
        createImportFile();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0, 1));
        createOverrideDataCheckBox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createValidateButton();
        createValidateResultPanel();
        createValidateResultText();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        $JToolBar0.setBorderPainted(false);
        createOpenValidateReportButton();
        createSaveValidateReportButton();
        createImportPanel();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(0, 1));
        createCleanWeightsCheckBox();
        createCheckWeightsCheckBox();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1, 0));
        createImportButton();
        createImportResultPanel();
        createImportResultText();
        // inline creation of $JToolBar1
        $objectMap.put("$JToolBar1", $JToolBar1 = new JToolBar());
        
        $JToolBar1.setName("$JToolBar1");
        $JToolBar1.setFloatable(false);
        $JToolBar1.setBorderPainted(false);
        createOpenImportReportButton();
        createSaveImportReportButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1, 0));
        createCloseButton();
        // inline creation of genericFormatImportTopPanel
        setName("genericFormatImportTopPanel");
        setLayout(new BorderLayout());
        genericFormatImportTopPanel.putClientProperty("help", "tutti.genericFormatImport.help");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programComboBox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_FILE_SELECTED_FILE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importFile.setSelectedFile(model.getImportFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OVERRIDE_DATA_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("overrideData", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    overrideDataCheckBox.setSelected(model.isOverrideData());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("overrideData", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canValidate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateButton.setEnabled(model.isCanValidate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canValidate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_RESULT_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("validateResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateResultPanel.setVisible(model.getValidateResult() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("validateResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_PANEL_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("validateDone", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("validateValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importPanel.setVisible(model.isValidateDone() && model.isValidateValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("validateDone", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("validateValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLEAN_WEIGHTS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cleanWeights", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cleanWeightsCheckBox.setSelected(model.isCleanWeights());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cleanWeights", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHECK_WEIGHTS_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("checkWeights", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    checkWeightsCheckBox.setSelected(model.isCheckWeights());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("checkWeights", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canImport", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importButton.setEnabled(model.isCanImport());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canImport", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_RESULT_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importResultPanel.setVisible(model.getImportResult() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importResult", this);
                }
            }
        });
    }

}