/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassificationId;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelId;
import fr.ifremer.adagio.core.service.referential.location.LocationService;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocations;
import fr.ifremer.tutti.persistence.service.referential.LocationPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.ReferentialPersistenceServiceSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.type.IntegerType;
import org.springframework.stereotype.Service;

@Service(value="locationPersistenceService")
public class LocationPersistenceServiceImpl
extends ReferentialPersistenceServiceSupport
implements LocationPersistenceService {
    @Resource(name="locationDao")
    protected LocationExtendDao locationDao;
    @Resource(name="locationService")
    protected LocationService locationService;

    @Override
    public List<TuttiLocation> getAllProgramZone() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.SECTOR.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue());
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllCountry() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.TERRITORIAL.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.PAYS_ISO3.getValue());
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllHarbour() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.TERRITORIAL.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.PORT.getValue());
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue(), Integer.valueOf(zoneId), LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue());
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue();
        } else {
            parentId = zoneId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue();
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(LocationLevelId.SCIENTIFIC_CRUISE_SUB_STRATA.getValue(), Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (subStrataId != null) {
            parentId = subStrataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_SUB_STRATA.getValue();
        } else if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue();
        } else {
            parentId = zoneId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue();
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(LocationLevelId.SCIENTIFIC_CRUISE_LOCALITE.getValue(), Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public TuttiLocation getLocation(String id) {
        Object[] source = this.queryUnique("locationById", "locationId", IntegerType.INSTANCE, Integer.valueOf(id));
        if (source == null) {
            return null;
        }
        TuttiLocation target = this.loadLocation(source);
        return target;
    }

    @Override
    public String getLocationLabelByLatLong(Float latitude, Float longitude) {
        return this.locationService.getLocationLabelByLatLong(latitude, longitude);
    }

    @Override
    public Integer getLocationIdByLatLong(Float latitude, Float longitude) {
        return this.locationService.getLocationIdByLatLong(latitude, longitude);
    }

    protected List<TuttiLocation> getFishingOperationLocationsByParent(Integer locationLevelId, Integer parentId, Integer parentLocationLevelId) {
        Iterator<Object[]> sources = this.queryListWithStatus("allFishingOperationLocationByParent", "parentId", IntegerType.INSTANCE, parentId, "parentLocationLevelId", IntegerType.INSTANCE, parentLocationLevelId, "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.SECTOR.getValue(), "locationLevelId", IntegerType.INSTANCE, locationLevelId);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return result;
    }

    protected TuttiLocation loadLocation(Object[] source) {
        TuttiLocation target = TuttiLocations.newTuttiLocation();
        target.setId((Integer)source[0]);
        target.setLabel((String)source[1]);
        target.setName((String)source[2]);
        this.setStatus((Status)source[3], target);
        return target;
    }
}

