/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.legacy;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.birt.doc.legacy.LegacyLoader;
import org.eclipse.birt.doc.legacy.RomImage;
import org.eclipse.birt.doc.legacy.SpecElement;
import org.eclipse.birt.doc.legacy.SpecProperty;
import org.w3c.dom.Element;

public class RomUpdater {
    RomImage rom;
    LegacyLoader loader;
    SpecElement specElement;
    Element romElement;
    PrintStream log;
    private static final String DESIGN_OBJ = "designClass";
    private static final String STATE_OBJ = "stateClass";
    private static final String SINCE = "since";
    private static final String XML_NAME = "xmlName";
    private static final String RUNTIME_SETTABLE = "runtimeSettable";
    private static final String CAN_INHERIT = "canInherit";
    private static final String IS_LIST = "isList";
    private static final String VALUE_REQUIRED = "valueRequired";
    private static final String CONTEXT = "context";
    private static final String PROPERTY_TYPE = "type";

    public RomUpdater(LegacyLoader theLoader) {
        this.rom = theLoader.getRom();
        this.loader = theLoader;
    }

    public void update() throws TransformException, IOException {
        this.log = new PrintStream(new FileOutputStream("docs/rom-update.log"));
        for (SpecElement this.specElement : this.loader.getElements()) {
            this.applyElementSpec();
        }
        for (SpecElement this.specElement : this.loader.getStructures()) {
            this.applyElementSpec();
        }
        this.log.close();
    }

    private void logNotice(SpecElement element, String action) throws IOException {
        String msg = "Notice: " + element.getTypeName() + " " + element.name + ": " + action;
        this.log.println(msg);
        System.err.println(msg);
        element.addIssue(msg);
    }

    private void logMismatch(SpecElement element, String attrName, String specValue, String romValue) throws IOException {
        String action = String.valueOf(attrName) + ": \"" + specValue + "\" does not match rom.def value \"" + romValue + "\"";
        String msg = String.valueOf(element.getTypeName()) + " " + element.name + "." + action;
        this.log.println("Notice: " + msg);
        System.err.println(msg);
        element.addIssue(action);
    }

    private void logNotice(SpecElement element, SpecProperty prop, String action) throws IOException {
        String msg = String.valueOf(element.getTypeName()) + " Property " + element.name + "." + prop.name + ": " + action;
        this.log.println("Notice: " + msg);
        System.err.println(msg);
        prop.addIssue(action);
    }

    private void logMismatch(SpecElement element, SpecProperty prop, String attrName, String specValue, String romValue) throws IOException {
        String action = String.valueOf(attrName) + ": \"" + specValue + "\" does not match rom.def value \"" + romValue + "\"";
        String msg = String.valueOf(element.getTypeName()) + " Property " + element.name + "." + prop.name + "." + action;
        this.log.println("Notice: " + msg);
        System.err.println(msg);
        prop.addIssue(action);
    }

    private void logNotice(SpecElement element, String attrib, String action) throws IOException {
        String tail = String.valueOf(attrib) + ": " + action;
        String msg = String.valueOf(element.getTypeName()) + " " + element.name + "." + tail;
        this.log.println("Notice: " + msg);
        System.err.println(msg);
        element.addIssue(tail);
    }

    private void logUpdate(SpecElement element, String attrib, String value) throws IOException {
        String msg = String.valueOf(element.getTypeName()) + " " + element.name + "." + attrib + ": Updated to " + value;
        this.log.println(msg);
    }

    private void logUpdate(SpecElement element, SpecProperty prop, String attrName, String value) throws IOException {
        String msg = String.valueOf(element.getTypeName()) + " Property " + element.name + "." + prop.name + "." + attrName + ": Updated to " + value;
        this.log.println(msg);
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    void applyElementSpec() throws TransformException, IOException {
        this.romElement = this.specElement.type == 0 ? this.rom.findElement(this.specElement.name) : this.rom.findStructure(this.specElement.name);
        if (this.romElement == null) {
            this.logNotice(this.specElement, " undefined in rom.def!");
            return;
        }
        this.applyObject(DESIGN_OBJ, this.specElement.designObjName);
        this.applyObject(STATE_OBJ, this.specElement.stateObjName);
        this.applyAttrib(SINCE, this.specElement.since);
        if (this.specElement.type == 0) {
            this.applyAttrib(XML_NAME, this.specElement.xmlElement);
        }
        this.applySpecProperties();
    }

    void applyObject(String attrib, String objName) throws IOException {
        if (this.isBlank(objName)) {
            return;
        }
        String value = this.romElement.getAttribute(attrib);
        if (this.isBlank(value)) {
            Element jsObj = this.rom.findClass(objName);
            if (jsObj == null) {
                this.logNotice(this.specElement, attrib, "Object name \"" + objName + "\" is not defined in rom.def");
            } else {
                this.logUpdate(this.specElement, attrib, objName);
                this.romElement.setAttribute(attrib, objName);
            }
        } else if (!value.equals(objName)) {
            this.logMismatch(this.specElement, objName, objName, value);
        }
    }

    private void applyAttrib(String attrib, String newValue) throws IOException {
        if (this.isBlank(newValue)) {
            return;
        }
        String value = this.romElement.getAttribute(attrib);
        if (this.isBlank(value)) {
            this.logUpdate(this.specElement, attrib, newValue);
            this.romElement.setAttribute(attrib, newValue);
        } else if (!value.equals(newValue)) {
            this.logMismatch(this.specElement, attrib, newValue, value);
        }
    }

    void applySpecProperties() throws IOException {
        for (SpecProperty prop : this.specElement.properties) {
            if (prop.name.equals("style")) continue;
            Element romProp = this.specElement.type == 0 ? this.rom.findProperty(this.romElement, prop.name) : this.rom.findMember(this.romElement, prop.name);
            if (romProp == null) {
                this.logNotice(this.specElement, prop, "Not defined in rom.def!");
                continue;
            }
            this.applyAttrib(prop, romProp, prop.since, SINCE);
            this.applyDefault(prop, romProp);
            this.applyBoolean(prop, romProp, prop.runtimeSettable, RUNTIME_SETTABLE, "true");
            this.applyBoolean(prop, romProp, prop.required, VALUE_REQUIRED, "false");
            this.checkBoolean(prop, romProp, prop.isArray, IS_LIST, "false");
            if (this.specElement.type == 0) {
                this.applyBoolean(prop, romProp, prop.inherited, CAN_INHERIT, "true");
                this.applyContext(prop, romProp);
            }
            this.applyHidden(prop);
        }
    }

    public void applyAttrib(SpecProperty prop, Element romProp, String attribValue, String attrib) throws IOException {
        if (this.isBlank(attribValue)) {
            return;
        }
        String value = romProp.getAttribute(attrib);
        if (this.isBlank(value)) {
            this.logUpdate(this.specElement, prop, attrib, attribValue);
            romProp.setAttribute(attrib, attribValue);
        } else if (!value.equals(prop.since)) {
            this.logMismatch(this.specElement, prop, attrib, attribValue, value);
        }
    }

    public void applyDefault(SpecProperty prop, Element romProp) throws IOException {
        if (this.isBlank(prop.defaultValue)) {
            return;
        }
        String value = this.rom.getDefaultValue(romProp);
        if (prop.defaultValue.equalsIgnoreCase("None")) {
            if (!this.isBlank(value)) {
                this.logNotice(this.specElement, prop, "rom.def has default value \"" + prop.defaultValue + "\" but the spec says None");
            }
        } else if (this.isBlank(value)) {
            this.logUpdate(this.specElement, prop, "Default", prop.since);
            this.rom.setDefaultValue(romProp, prop.defaultValue);
        } else if (!value.equals(prop.defaultValue)) {
            this.logMismatch(this.specElement, prop, "Default", prop.defaultValue, value);
        }
    }

    public void applyBoolean(SpecProperty prop, Element romProp, int attribValue, String attrib, String defaultValue) throws IOException {
        if (attribValue == 0) {
            return;
        }
        String newValue = attribValue == 1 ? "true" : "false";
        String value = romProp.getAttribute(attrib);
        if (this.isBlank(value)) {
            if (!newValue.equals(defaultValue)) {
                this.logUpdate(this.specElement, prop, attrib, newValue);
                romProp.setAttribute(attrib, newValue);
            }
        } else if (!value.equals(newValue)) {
            this.logMismatch(this.specElement, prop, attrib, newValue, value);
        }
    }

    public void checkBoolean(SpecProperty prop, Element romProp, int attribValue, String attrib, String defaultValue) throws IOException {
        if (attribValue == 0) {
            return;
        }
        String newValue = attribValue == 1 ? "true" : "false";
        String value = romProp.getAttribute(attrib);
        if (this.isBlank(value)) {
            value = defaultValue;
        }
        if (!value.equals(newValue)) {
            this.logMismatch(this.specElement, prop, attrib, newValue, value);
        }
    }

    public void applyHidden(SpecProperty prop) throws IOException {
        if (prop.hidden == 0) {
            return;
        }
        String newValue = prop.hidden == 1 ? "hide" : "show";
        Element vis = this.rom.findPropertyVisibility(this.romElement, prop.name);
        if (vis != null) {
            String value = vis.getAttribute("visibility");
            if (!value.equals(newValue)) {
                this.logMismatch(this.specElement, prop, "Visibility", newValue, value);
            }
        } else if (prop.hidden == 1) {
            this.logUpdate(this.specElement, prop, "Visibility", newValue);
            this.rom.setPropertyVisibility(this.romElement, prop.name, newValue);
        }
    }

    public void applyContext(SpecProperty prop, Element romProp) throws IOException {
        if (prop.exprContext == null) {
            return;
        }
        String type = romProp.getAttribute(PROPERTY_TYPE);
        if (type == null || !type.equals("expression")) {
            this.logNotice(this.specElement, prop, "Spec expression context, but ROM propety type is " + type);
            return;
        }
        String newValue = null;
        if (prop.exprContext.equalsIgnoreCase("Factory")) {
            newValue = "factory";
        } else if (prop.exprContext.equalsIgnoreCase("Presentation")) {
            newValue = "presentation";
        } else if (prop.exprContext.equalsIgnoreCase("Element")) {
            newValue = "element";
        } else {
            this.logNotice(this.specElement, prop, "Spec has unknown value for expr context: " + prop.exprContext);
            return;
        }
        this.applyAttrib(prop, romProp, newValue, CONTEXT);
    }

    static class TransformException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TransformException(String msg) {
            super(msg);
        }
    }
}

