package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.util.ActionListCellRenderer;
import static org.nuiton.i18n.I18n.t;

public class SelectCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SelectCruiseUIModel, SelectCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CRUISE_COMBOBOX_ENABLED = "cruiseCombobox.enabled";
    public static final String BINDING_CRUISE_COMBOBOX_SELECTED_ITEM = "cruiseCombobox.selectedItem";
    public static final String BINDING_CRUISE_LABEL_ICON = "cruiseLabel.icon";
    public static final String BINDING_EDIT_CATCHES_BUTTON_ENABLED = "editCatchesButton.enabled";
    public static final String BINDING_EDIT_CRUISE_COMBO_BOX_ENABLED = "editCruiseComboBox.enabled";
    public static final String BINDING_EDIT_PROGRAM_COMBO_BOX_ENABLED = "editProgramComboBox.enabled";
    public static final String BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED = "editProtocolComboBox.enabled";
    public static final String BINDING_NEW_CRUISE_BUTTON_ENABLED = "newCruiseButton.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_ENABLED = "programCombobox.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM = "programCombobox.selectedItem";
    public static final String BINDING_PROTOCOL_COMBOBOX_ENABLED = "protocolCombobox.enabled";
    public static final String BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM = "protocolCombobox.selectedItem";
    public static final String BINDING_VALIDATE_CATCHES_BUTTON_ENABLED = "validateCatchesButton.enabled";
    public static final String BINDING_WARNING_CONTAINER_VISIBLE = "warningContainer.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SelectCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cloneProtocolButton;
    @ValidatorField( validatorId = "validator",  propertyName = "cruise",  editorName = "cruiseCombobox")
    protected BeanFilterableComboBox<Cruise> cruiseCombobox;
    protected JLabel cruiseLabel;
    protected JButton deleteProtocolButton;
    protected JButton editCatchesButton;
    protected JButton editCruiseButton;
    protected JComboBox editCruiseComboBox;
    protected JButton editProgramButton;
    protected JComboBox editProgramComboBox;
    protected JButton editProtocolButton;
    protected JComboBox editProtocolComboBox;
    protected JButton exportCruiseButton;
    protected JButton exportCruiseForSumatraButton;
    protected JButton exportProgramButton;
    protected JButton exportProtocolButton;
    protected final SelectCruiseUIHandler handler = createHandler();
    protected JButton importProtocolButton;
    protected SelectCruiseUIModel model;
    protected JButton newCruiseButton;
    protected JButton newProgramButton;
    protected JButton newProtocolButton;
    protected JComboBox newProtocolComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programCombobox")
    protected BeanFilterableComboBox<Program> programCombobox;
    protected JLabel programLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "protocol",  editorName = "protocolCombobox")
    protected BeanFilterableComboBox<TuttiProtocol> protocolCombobox;
    protected JLabel protocolLabel;
    protected SelectCruiseUI selectCruiseTopPanel = this;
    protected JButton sendCruiseReportButton;
    protected JButton speciesToConfirmReportForCruiseButton;
    protected JButton validateCatchesButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<SelectCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JPanel warningContainer;
    protected JLabel warningLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiUIContext uiContext;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectCruiseUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
                uiContext = TuttiUIUtil.getApplicationContext(parentUI);
            $initialize();
    }

    public SelectCruiseUI() {
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editCruiseComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startEditCruiseAction(event);
    }

    public void doActionPerformed__on__editProgramComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startEditProgramAction(event);
    }

    public void doActionPerformed__on__editProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExistingProtocolAction(event);
    }

    public void doActionPerformed__on__newProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseClicked__on__editCruiseComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editCruiseComboBox.isEnabled()) { handler.startEditCruiseAction(event); }
    }

    public void doMouseClicked__on__editProgramComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProgramComboBox.isEnabled()) { handler.startEditProgramAction(event); }
    }

    public void doMouseClicked__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { handler.startExistingProtocolAction(event); }
    }

    public void doMouseClicked__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseEntered__on__editCruiseComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editCruiseComboBox.isEnabled()) { editCruiseComboBox.showPopup(); }
    }

    public void doMouseEntered__on__editProgramComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProgramComboBox.isEnabled()) { editProgramComboBox.showPopup(); }
    }

    public void doMouseEntered__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { editProtocolComboBox.showPopup(); }
    }

    public void doMouseEntered__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        newProtocolComboBox.showPopup();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloneProtocolButton() {
        return cloneProtocolButton;
    }

    public BeanFilterableComboBox<Cruise> getCruiseCombobox() {
        return cruiseCombobox;
    }

    public JLabel getCruiseLabel() {
        return cruiseLabel;
    }

    public JButton getDeleteProtocolButton() {
        return deleteProtocolButton;
    }

    public JButton getEditCatchesButton() {
        return editCatchesButton;
    }

    public JButton getEditCruiseButton() {
        return editCruiseButton;
    }

    public JComboBox getEditCruiseComboBox() {
        return editCruiseComboBox;
    }

    public JButton getEditProgramButton() {
        return editProgramButton;
    }

    public JComboBox getEditProgramComboBox() {
        return editProgramComboBox;
    }

    public JButton getEditProtocolButton() {
        return editProtocolButton;
    }

    public JComboBox getEditProtocolComboBox() {
        return editProtocolComboBox;
    }

    public JButton getExportCruiseButton() {
        return exportCruiseButton;
    }

    public JButton getExportCruiseForSumatraButton() {
        return exportCruiseForSumatraButton;
    }

    public JButton getExportProgramButton() {
        return exportProgramButton;
    }

    public JButton getExportProtocolButton() {
        return exportProtocolButton;
    }

    public SelectCruiseUIHandler getHandler() {
        return handler;
    }

    public JButton getImportProtocolButton() {
        return importProtocolButton;
    }

    public SelectCruiseUIModel getModel() {
        return model;
    }

    public JButton getNewCruiseButton() {
        return newCruiseButton;
    }

    public JButton getNewProgramButton() {
        return newProgramButton;
    }

    public JButton getNewProtocolButton() {
        return newProtocolButton;
    }

    public JComboBox getNewProtocolComboBox() {
        return newProtocolComboBox;
    }

    public BeanFilterableComboBox<Program> getProgramCombobox() {
        return programCombobox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public BeanFilterableComboBox<TuttiProtocol> getProtocolCombobox() {
        return protocolCombobox;
    }

    public JLabel getProtocolLabel() {
        return protocolLabel;
    }

    public JButton getSendCruiseReportButton() {
        return sendCruiseReportButton;
    }

    public JButton getSpeciesToConfirmReportForCruiseButton() {
        return speciesToConfirmReportForCruiseButton;
    }

    public JButton getValidateCatchesButton() {
        return validateCatchesButton;
    }

    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return validator;
    }

    public JPanel getWarningContainer() {
        return warningContainer;
    }

    public JLabel getWarningLabel() {
        return warningLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(editProgramButton);
        add(exportProgramButton);
        add(editCruiseButton);
        add(exportCruiseButton);
        add(sendCruiseReportButton);
        add(exportCruiseForSumatraButton);
        add(speciesToConfirmReportForCruiseButton);
        add(newProtocolButton);
        add(importProtocolButton);
        add(editProtocolButton);
        add(cloneProtocolButton);
        add(exportProtocolButton);
        add(deleteProtocolButton);
        add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        warningContainer.add(warningLabel, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.selectCruise.help"));
    }

    protected void createCloneProtocolButton() {
        $objectMap.put("cloneProtocolButton", cloneProtocolButton = new JButton());
        
        cloneProtocolButton.setName("cloneProtocolButton");
        cloneProtocolButton.setText(t("tutti.selectCruise.action.cloneProtocol"));
        cloneProtocolButton.setToolTipText(t("tutti.selectCruise.action.cloneProtocol.tip"));
        cloneProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.CloneProtocolAction.class);
        cloneProtocolButton.putClientProperty("help", "tutti.selectCruise.action.cloneProtocol.help");
    }

    protected void createCruiseCombobox() {
        $objectMap.put("cruiseCombobox", cruiseCombobox = new BeanFilterableComboBox<Cruise>(this));
        
        cruiseCombobox.setName("cruiseCombobox");
        cruiseCombobox.setProperty("cruise");
        cruiseCombobox.setShowReset(true);
        cruiseCombobox.putClientProperty("help", "tutti.selectCruise.field.cruise.help");
        cruiseCombobox.putClientProperty("validatorLabel", t("tutti.selectCruise.field.cruise"));
    }

    protected void createCruiseLabel() {
        $objectMap.put("cruiseLabel", cruiseLabel = new JLabel());
        
        cruiseLabel.setName("cruiseLabel");
        cruiseLabel.setText(t("tutti.selectCruise.field.cruise"));
        cruiseLabel.setToolTipText(t("tutti.selectCruise.field.cruise.tip"));
        cruiseLabel.putClientProperty("help", "tutti.selectCruise.field.cruise.help");
    }

    protected void createDeleteProtocolButton() {
        $objectMap.put("deleteProtocolButton", deleteProtocolButton = new JButton());
        
        deleteProtocolButton.setName("deleteProtocolButton");
        deleteProtocolButton.setText(t("tutti.selectCruise.action.deleteProtocol"));
        deleteProtocolButton.setToolTipText(t("tutti.selectCruise.action.deleteProtocol.tip"));
        deleteProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.DeleteProtocolAction.class);
        deleteProtocolButton.putClientProperty("help", "tutti.selectCruise.action.deleteProtocol.help");
    }

    protected void createEditCatchesButton() {
        $objectMap.put("editCatchesButton", editCatchesButton = new JButton());
        
        editCatchesButton.setName("editCatchesButton");
        editCatchesButton.setText(t("tutti.selectCruise.action.editCatches"));
        editCatchesButton.setToolTipText(t("tutti.selectCruise.action.editCatches.tip"));
        editCatchesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditCatchesAction.class);
        editCatchesButton.putClientProperty("help", "tutti.selectCruise.action.editCatches.help");
    }

    protected void createEditCruiseButton() {
        $objectMap.put("editCruiseButton", editCruiseButton = new JButton());
        
        editCruiseButton.setName("editCruiseButton");
        editCruiseButton.setText(t("tutti.selectCruise.action.editCruise"));
        editCruiseButton.setToolTipText(t("tutti.selectCruise.action.editCruise.tip"));
        editCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditCruiseAction.class);
        editCruiseButton.putClientProperty("help", "tutti.selectCruise.action.editCruise.help");
    }

    protected void createEditCruiseComboBox() {
        $objectMap.put("editCruiseComboBox", editCruiseComboBox = new JComboBox());
        
        editCruiseComboBox.setName("editCruiseComboBox");
        editCruiseComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editCruiseComboBox"));
        editCruiseComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editCruiseComboBox"));
        editCruiseComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editCruiseComboBox"));
    }

    protected void createEditProgramButton() {
        $objectMap.put("editProgramButton", editProgramButton = new JButton());
        
        editProgramButton.setName("editProgramButton");
        editProgramButton.setText(t("tutti.selectCruise.action.editProgram"));
        editProgramButton.setToolTipText(t("tutti.selectCruise.action.editProgram.tip"));
        editProgramButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditProgramAction.class);
        editProgramButton.putClientProperty("help", "tutti.selectCruise.action.editProgram.help");
    }

    protected void createEditProgramComboBox() {
        $objectMap.put("editProgramComboBox", editProgramComboBox = new JComboBox());
        
        editProgramComboBox.setName("editProgramComboBox");
        editProgramComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProgramComboBox"));
        editProgramComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editProgramComboBox"));
        editProgramComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editProgramComboBox"));
    }

    protected void createEditProtocolButton() {
        $objectMap.put("editProtocolButton", editProtocolButton = new JButton());
        
        editProtocolButton.setName("editProtocolButton");
        editProtocolButton.setText(t("tutti.selectCruise.action.editProtocol"));
        editProtocolButton.setToolTipText(t("tutti.selectCruise.action.editProtocol.tip"));
        editProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditProtocolAction.class);
        editProtocolButton.putClientProperty("help", "tutti.selectCruise.action.editProtocol.help");
    }

    protected void createEditProtocolComboBox() {
        $objectMap.put("editProtocolComboBox", editProtocolComboBox = new JComboBox());
        
        editProtocolComboBox.setName("editProtocolComboBox");
        editProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editProtocolComboBox"));
    }

    protected void createExportCruiseButton() {
        $objectMap.put("exportCruiseButton", exportCruiseButton = new JButton());
        
        exportCruiseButton.setName("exportCruiseButton");
        exportCruiseButton.setText(t("tutti.selectCruise.action.exportCruise"));
        exportCruiseButton.setToolTipText(t("tutti.selectCruise.action.exportCruise.tip"));
        exportCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportCruiseAction.class);
        exportCruiseButton.putClientProperty("help", "tutti.selectCruise.action.exportCruise.help");
    }

    protected void createExportCruiseForSumatraButton() {
        $objectMap.put("exportCruiseForSumatraButton", exportCruiseForSumatraButton = new JButton());
        
        exportCruiseForSumatraButton.setName("exportCruiseForSumatraButton");
        exportCruiseForSumatraButton.setText(t("tutti.selectCruise.action.exportCruiseForSumatra"));
        exportCruiseForSumatraButton.setToolTipText(t("tutti.selectCruise.action.exportCruiseForSumatra.tip"));
        exportCruiseForSumatraButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportCruiseForSumatraAction.class);
        exportCruiseForSumatraButton.putClientProperty("help", "tutti.selectCruise.action.exportCruiseForSumatra.help");
    }

    protected void createExportProgramButton() {
        $objectMap.put("exportProgramButton", exportProgramButton = new JButton());
        
        exportProgramButton.setName("exportProgramButton");
        exportProgramButton.setText(t("tutti.selectCruise.action.exportProgram"));
        exportProgramButton.setToolTipText(t("tutti.selectCruise.action.exportProgram.tip"));
        exportProgramButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportProgramAction.class);
        exportProgramButton.putClientProperty("help", "tutti.selectCruise.action.exportProgram.help");
    }

    protected void createExportProtocolButton() {
        $objectMap.put("exportProtocolButton", exportProtocolButton = new JButton());
        
        exportProtocolButton.setName("exportProtocolButton");
        exportProtocolButton.setText(t("tutti.selectCruise.action.exportProtocol"));
        exportProtocolButton.setToolTipText(t("tutti.selectCruise.action.exportProtocol.tip"));
        exportProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportProtocolAction.class);
        exportProtocolButton.putClientProperty("help", "tutti.selectCruise.action.exportProtocol.help");
    }

    protected SelectCruiseUIHandler createHandler() {
        return new SelectCruiseUIHandler();
    }

    protected void createImportProtocolButton() {
        $objectMap.put("importProtocolButton", importProtocolButton = new JButton());
        
        importProtocolButton.setName("importProtocolButton");
        importProtocolButton.setText(t("tutti.selectCruise.action.importProtocol"));
        importProtocolButton.setToolTipText(t("tutti.selectCruise.action.importProtocol.tip"));
        importProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportProtocolAction.class);
        importProtocolButton.putClientProperty("help", "tutti.selectCruise.action.importProtocol.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectCruiseUIModel.class));
    }

    protected void createNewCruiseButton() {
        $objectMap.put("newCruiseButton", newCruiseButton = new JButton());
        
        newCruiseButton.setName("newCruiseButton");
        newCruiseButton.setText(t("tutti.selectCruise.action.newCruise"));
        newCruiseButton.setToolTipText(t("tutti.selectCruise.action.newCruise.tip"));
        newCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.NewCruiseAction.class);
        newCruiseButton.putClientProperty("help", "tutti.selectCruise.action.newCruise.help");
    }

    protected void createNewProgramButton() {
        $objectMap.put("newProgramButton", newProgramButton = new JButton());
        
        newProgramButton.setName("newProgramButton");
        newProgramButton.setText(t("tutti.selectCruise.action.newProgram"));
        newProgramButton.setToolTipText(t("tutti.selectCruise.action.newProgram.tip"));
        newProgramButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.NewProgramAction.class);
        newProgramButton.putClientProperty("help", "tutti.selectCruise.action.newProgram.help");
    }

    protected void createNewProtocolButton() {
        $objectMap.put("newProtocolButton", newProtocolButton = new JButton());
        
        newProtocolButton.setName("newProtocolButton");
        newProtocolButton.setText(t("tutti.selectCruise.action.newProtocol"));
        newProtocolButton.setToolTipText(t("tutti.selectCruise.action.newProtocol.tip"));
        newProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.NewProtocolAction.class);
        newProtocolButton.putClientProperty("help", "tutti.selectCruise.action.newProtocol.help");
    }

    protected void createNewProtocolComboBox() {
        $objectMap.put("newProtocolComboBox", newProtocolComboBox = new JComboBox());
        
        newProtocolComboBox.setName("newProtocolComboBox");
        newProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__newProtocolComboBox"));
    }

    protected void createProgramCombobox() {
        $objectMap.put("programCombobox", programCombobox = new BeanFilterableComboBox<Program>(this));
        
        programCombobox.setName("programCombobox");
        programCombobox.setProperty("program");
        programCombobox.setShowReset(true);
        programCombobox.putClientProperty("help", "tutti.selectCruise.field.program.help");
        programCombobox.putClientProperty("validatorLabel", t("tutti.selectCruise.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(t("tutti.selectCruise.field.program"));
        programLabel.setToolTipText(t("tutti.selectCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.selectCruise.field.program.help");
    }

    protected void createProtocolCombobox() {
        $objectMap.put("protocolCombobox", protocolCombobox = new BeanFilterableComboBox<TuttiProtocol>(this));
        
        protocolCombobox.setName("protocolCombobox");
        protocolCombobox.setProperty("protocol");
        protocolCombobox.setShowReset(true);
        protocolCombobox.putClientProperty("help", "tutti.selectCruise.field.protocol.help");
        protocolCombobox.putClientProperty("validatorLabel", t("tutti.selectCruise.field.protocol"));
    }

    protected void createProtocolLabel() {
        $objectMap.put("protocolLabel", protocolLabel = new JLabel());
        
        protocolLabel.setName("protocolLabel");
        protocolLabel.setText(t("tutti.selectCruise.field.protocol"));
        protocolLabel.setToolTipText(t("tutti.selectCruise.field.protocol.tip"));
        protocolLabel.putClientProperty("help", "tutti.selectCruise.field.protocol.help");
    }

    protected void createSendCruiseReportButton() {
        $objectMap.put("sendCruiseReportButton", sendCruiseReportButton = new JButton());
        
        sendCruiseReportButton.setName("sendCruiseReportButton");
        sendCruiseReportButton.setText(t("tutti.selectCruise.action.sendCruiseReport"));
        sendCruiseReportButton.setToolTipText(t("tutti.selectCruise.action.sendCruiseReport.tip"));
        sendCruiseReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SendCruiseReportAction.class);
        sendCruiseReportButton.putClientProperty("help", "tutti.selectCruise.action.sendCruiseReport.help");
    }

    protected void createSpeciesToConfirmReportForCruiseButton() {
        $objectMap.put("speciesToConfirmReportForCruiseButton", speciesToConfirmReportForCruiseButton = new JButton());
        
        speciesToConfirmReportForCruiseButton.setName("speciesToConfirmReportForCruiseButton");
        speciesToConfirmReportForCruiseButton.setText(t("tutti.selectCruise.action.speciesToConfirmReportForCruise"));
        speciesToConfirmReportForCruiseButton.setToolTipText(t("tutti.selectCruise.action.speciesToConfirmReportForCruise.tip"));
        speciesToConfirmReportForCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SpeciesToConfirmReportForCruiseAction.class);
        speciesToConfirmReportForCruiseButton.putClientProperty("help", "tutti.selectCruise.action.speciesToConfirmReportForCruise.help");
    }

    protected void createValidateCatchesButton() {
        $objectMap.put("validateCatchesButton", validateCatchesButton = new JButton());
        
        validateCatchesButton.setName("validateCatchesButton");
        validateCatchesButton.setText(t("tutti.selectCruise.action.validateCatches"));
        validateCatchesButton.setToolTipText(t("tutti.selectCruise.action.validateCatches.tip"));
        validateCatchesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ValidateCatchesAction.class);
        validateCatchesButton.putClientProperty("help", "tutti.selectCruise.action.validateCatches.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SelectCruiseUIModel.class, null));
    }

    protected void createWarningContainer() {
        $objectMap.put("warningContainer", warningContainer = new JPanel());
        
        warningContainer.setName("warningContainer");
        warningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createWarningLabel() {
        $objectMap.put("warningLabel", warningLabel = new JLabel());
        
        warningLabel.setName("warningLabel");
        warningLabel.setText(t("tutti.selectCruise.warn.invalid.selected.data"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSelectCruiseTopPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(warningContainer, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(programLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programCombobox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cruiseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cruiseCombobox), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(protocolLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(protocolCombobox), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToWarningContainer();
        // inline complete setup of $JPanel0
        $JPanel0.add(editProgramComboBox);
        $JPanel0.add(newProgramButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(editCruiseComboBox);
        $JPanel1.add(newCruiseButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(editProtocolComboBox);
        $JPanel2.add(newProtocolComboBox);
        // inline complete setup of $JPanel3
        $JPanel3.add(editCatchesButton);
        $JPanel3.add(validateCatchesButton);
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 46 property setters
        programCombobox.setBeanType(Program.class);
        cruiseCombobox.setBeanType(Cruise.class);
        protocolCombobox.setBeanType(TuttiProtocol.class);
        editProgramButton.setIcon(SwingUtil.createActionIcon("edit"));
        exportProgramButton.setIcon(SwingUtil.createActionIcon("export"));
        editCruiseButton.setIcon(SwingUtil.createActionIcon("edit"));
        exportCruiseButton.setIcon(SwingUtil.createActionIcon("export"));
        sendCruiseReportButton.setIcon(SwingUtil.createActionIcon("email"));
        exportCruiseForSumatraButton.setIcon(SwingUtil.createActionIcon("export"));
        speciesToConfirmReportForCruiseButton.setIcon(SwingUtil.createActionIcon("report"));
        newProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        importProtocolButton.setIcon(SwingUtil.createActionIcon("import"));
        editProtocolButton.setIcon(SwingUtil.createActionIcon("edit"));
        cloneProtocolButton.setIcon(SwingUtil.createActionIcon("copy"));
        exportProtocolButton.setIcon(SwingUtil.createActionIcon("export"));
        deleteProtocolButton.setIcon(SwingUtil.createActionIcon("delete"));
        warningContainer.setBackground(new java.awt.Color(245, 218, 88));
        warningLabel.setIcon(SwingUtil.createActionIcon("warning"));
        warningLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        programLabel.setIcon(SwingUtil.createActionIcon("program"));
        programCombobox.setBean(model);
        editProgramComboBox.setModel(SwingUtil.newComboModel(editProgramButton, exportProgramButton));
        editProgramComboBox.setRenderer(new ActionListCellRenderer());
        newProgramButton.setIcon(SwingUtil.createActionIcon("add"));
        cruiseLabel.setLabelFor(cruiseCombobox);
        cruiseCombobox.setBean(model);
        editCruiseComboBox.setModel(SwingUtil.newComboModel(editCruiseButton, exportCruiseButton, sendCruiseReportButton, exportCruiseForSumatraButton, speciesToConfirmReportForCruiseButton));
        editCruiseComboBox.setRenderer(new ActionListCellRenderer());
        newCruiseButton.setIcon(SwingUtil.createActionIcon("add"));
        protocolLabel.setLabelFor(protocolCombobox);
        protocolLabel.setIcon(SwingUtil.createActionIcon("protocol"));
        protocolCombobox.setBean(model);
        editProtocolComboBox.setModel(SwingUtil.newComboModel(editProtocolButton, cloneProtocolButton, exportProtocolButton, deleteProtocolButton));
        editProtocolComboBox.setRenderer(new ActionListCellRenderer());
        newProtocolComboBox.setModel(SwingUtil.newComboModel(newProtocolButton, importProtocolButton));
        newProtocolComboBox.setRenderer(new ActionListCellRenderer());
        editCatchesButton.setIcon(SwingUtil.createActionIcon("edit"));
        editCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.selectCruise.action.editCatches.mnemonic"),'Z'));
        validateCatchesButton.setIcon(SwingUtil.createActionIcon("validate"));
        validateCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.selectCruise.action.validateCatches.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, selectCruiseTopPanel, "tutti.selectCruise.help");
        registerHelpId(_broker, editProgramButton, "tutti.selectCruise.action.editProgram.help");
        registerHelpId(_broker, exportProgramButton, "tutti.selectCruise.action.exportProgram.help");
        registerHelpId(_broker, editCruiseButton, "tutti.selectCruise.action.editCruise.help");
        registerHelpId(_broker, exportCruiseButton, "tutti.selectCruise.action.exportCruise.help");
        registerHelpId(_broker, sendCruiseReportButton, "tutti.selectCruise.action.sendCruiseReport.help");
        registerHelpId(_broker, exportCruiseForSumatraButton, "tutti.selectCruise.action.exportCruiseForSumatra.help");
        registerHelpId(_broker, speciesToConfirmReportForCruiseButton, "tutti.selectCruise.action.speciesToConfirmReportForCruise.help");
        registerHelpId(_broker, newProtocolButton, "tutti.selectCruise.action.newProtocol.help");
        registerHelpId(_broker, importProtocolButton, "tutti.selectCruise.action.importProtocol.help");
        registerHelpId(_broker, editProtocolButton, "tutti.selectCruise.action.editProtocol.help");
        registerHelpId(_broker, cloneProtocolButton, "tutti.selectCruise.action.cloneProtocol.help");
        registerHelpId(_broker, exportProtocolButton, "tutti.selectCruise.action.exportProtocol.help");
        registerHelpId(_broker, deleteProtocolButton, "tutti.selectCruise.action.deleteProtocol.help");
        registerHelpId(_broker, programLabel, "tutti.selectCruise.field.program.help");
        registerHelpId(_broker, programCombobox, "tutti.selectCruise.field.program.help");
        registerHelpId(_broker, newProgramButton, "tutti.selectCruise.action.newProgram.help");
        registerHelpId(_broker, cruiseLabel, "tutti.selectCruise.field.cruise.help");
        registerHelpId(_broker, cruiseCombobox, "tutti.selectCruise.field.cruise.help");
        registerHelpId(_broker, newCruiseButton, "tutti.selectCruise.action.newCruise.help");
        registerHelpId(_broker, protocolLabel, "tutti.selectCruise.field.protocol.help");
        registerHelpId(_broker, protocolCombobox, "tutti.selectCruise.field.protocol.help");
        registerHelpId(_broker, editCatchesButton, "tutti.selectCruise.action.editCatches.help");
        registerHelpId(_broker, validateCatchesButton, "tutti.selectCruise.action.validateCatches.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("selectCruiseTopPanel", selectCruiseTopPanel);
        createModel();
        createValidator();
        createBroker();
        createEditProgramButton();
        createExportProgramButton();
        createEditCruiseButton();
        createExportCruiseButton();
        createSendCruiseReportButton();
        createExportCruiseForSumatraButton();
        createSpeciesToConfirmReportForCruiseButton();
        createNewProtocolButton();
        createImportProtocolButton();
        createEditProtocolButton();
        createCloneProtocolButton();
        createExportProtocolButton();
        createDeleteProtocolButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createWarningContainer();
        createWarningLabel();
        createProgramLabel();
        createProgramCombobox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createEditProgramComboBox();
        createNewProgramButton();
        createCruiseLabel();
        createCruiseCombobox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createEditCruiseComboBox();
        createNewCruiseButton();
        createProtocolLabel();
        createProtocolCombobox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createEditProtocolComboBox();
        createNewProtocolComboBox();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createEditCatchesButton();
        createValidateCatchesButton();
        // inline creation of selectCruiseTopPanel
        setName("selectCruiseTopPanel");
        setLayout(new BorderLayout());
        selectCruiseTopPanel.putClientProperty("help", "tutti.selectCruise.help");
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_CONTAINER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningContainer.setVisible(!model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (programCombobox != null) {
                    programCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (programCombobox != null) {
                    programCombobox.setEnabled(!programCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (programCombobox != null) {
                    programCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programCombobox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROGRAM_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProgramComboBox.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_LABEL_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseLabel.setIcon(TuttiUIUtil.getCruiseIcon(model.getCruise()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.setEnabled(!cruiseCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseCombobox.setSelectedItem(model.getCruise());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CRUISE_COMBO_BOX_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCruiseComboBox.setEnabled(model.isProgramFound() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_CRUISE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newCruiseButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.setEnabled(!protocolCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocol", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    protocolCombobox.setSelectedItem(model.getProtocol());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocol", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocolFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProtocolComboBox.setEnabled(model.isProtocolFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocolFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCatchesButton.setEnabled(model.isValid() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateCatchesButton.setEnabled(model.isValid() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
    }

}