/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.export.pdf.CatchesPdfExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportFishingOperationReportAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    private static final Log log = LogFactory.getLog(ExportFishingOperationReportAction.class);
    protected File file;

    public ExportFishingOperationReportAction(EditCatchesUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (((EditCatchesUIModel)this.getModel()).isModify()) {
            this.displayWarningMessage(I18n.t((String)"tutti.exportFishingOperationReport.title.model.modified", (Object[])new Object[0]), I18n.t((String)"tutti.exportFishingOperationReport.message.model.modified", (Object[])new Object[0]));
            doAction = false;
        }
        if (doAction) {
            Cruise cruise = this.getDataContext().getCruise();
            FishingOperation fishingOperation = ((EditCatchesUIModel)this.getModel()).getFishingOperation();
            this.file = this.saveFile("exportFishingOperation-" + cruise.getName() + "-" + fishingOperation.getStationNumber(), "pdf", I18n.t((String)"tutti.exportFishingOperationReport.title.choose.exportFile", (Object[])new Object[0]), I18n.t((String)"tutti.exportFishingOperationReport.action.chooseFile", (Object[])new Object[0]), new String[]{"^.+\\.pdf$", I18n.t((String)"tutti.common.file.pdf", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = this.getDataContext().getCruise();
        FishingOperation fishingOperation = ((EditCatchesUIModel)this.getModel()).getFishingOperation();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export fishingOperation " + cruise.getId() + "-" + fishingOperation.getStationNumber() + " to file: " + this.file));
        }
        CatchesPdfExportService service = this.getContext().getGeneratePDFService();
        service.generateFishingOperationPDFFile(this.file, fishingOperation.getId(), this.getConfig().getI18nLocale());
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.exportFishingOperationReport.action.success", (Object[])new Object[]{this.file}));
    }
}

