/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.csv;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.csv.ImportableColumn;

public class ImportToMap
extends Import<Map<String, Object>> {
    public static ImportToMap newImportToMap(ImportModel<Map<String, Object>> model, InputStream inputStream) {
        return new ImportToMap(model, inputStream);
    }

    public static ImportToMap newImportToMap(ImportModel<Map<String, Object>> model, Reader reader) {
        return new ImportToMap(model, reader);
    }

    public static ImportToMap newImportToMap(ImportModel<Map<String, Object>> model, InputStream inputStream, boolean safetySwitch) {
        return new ImportToMap(model, inputStream, safetySwitch);
    }

    public static ImportToMap newImportToMap(ImportModel<Map<String, Object>> model, Reader reader, boolean safetySwitch) {
        return new ImportToMap(model, reader, safetySwitch);
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        this.prepareAndValidate();
        return new Iterator<Map<String, Object>>(){
            boolean hasNext;
            List<ImportableColumn<Map<String, Object>, Object>> columns;
            int lineNumber;
            final Map<String, Object> element;
            {
                this.hasNext = ImportToMap.this.readRow();
                this.columns = ImportToMap.this.getNonIgnoredHeaders();
                this.element = new HashMap<String, Object>();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Map<String, Object> next() throws NoSuchElementException, ImportRuntimeException {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                ++this.lineNumber;
                this.element.clear();
                for (ImportableColumn<Map<String, Object>, Object> field : this.columns) {
                    String value = ImportToMap.this.readValue(field, this.lineNumber);
                    Object parsedValue = ImportToMap.this.parseValue(field, this.lineNumber, value);
                    ImportToMap.this.setValue(field, this.lineNumber, this.element, parsedValue);
                }
                this.hasNext = ImportToMap.this.readRow();
                return this.element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected ImportToMap(ImportModel<Map<String, Object>> mapImportModel, InputStream inputStream) {
        this(mapImportModel, inputStream, true);
    }

    protected ImportToMap(ImportModel<Map<String, Object>> mapImportModel, Reader reader) {
        this(mapImportModel, reader, true);
    }

    protected ImportToMap(ImportModel<Map<String, Object>> mapImportModel, InputStream inputStream, boolean safetySwitch) {
        super(mapImportModel, inputStream);
        this.reader.setSafetySwitch(safetySwitch);
    }

    protected ImportToMap(ImportModel<Map<String, Object>> mapImportModel, Reader reader, boolean safetySwitch) {
        super(mapImportModel, reader);
        this.reader.setSafetySwitch(safetySwitch);
    }
}

