/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.report;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.export.generic.TuttiExportService;
import fr.ifremer.tutti.service.report.ReportGenerationContext;
import fr.ifremer.tutti.service.report.ReportGenerationRequest;
import fr.ifremer.tutti.service.report.ReportGenerationResult;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReportGenerationService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReportGenerationService.class);
    private static final FileFilter REPORT_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".rptdesign");
        }
    };

    public List<File> getAvailableReports() {
        ArrayList result = Lists.newArrayList();
        File reportDirectory = this.context.getConfig().getReportDirectory();
        File[] files = reportDirectory.listFiles(REPORT_FILTER);
        if (files != null) {
            result.addAll(Arrays.asList(files));
        }
        return result;
    }

    public ReportGenerationResult generateReport(ReportGenerationRequest request, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)request.getReport());
        Preconditions.checkState((boolean)request.getReport().exists());
        Preconditions.checkNotNull((Object)request.getCruiseId());
        Preconditions.checkNotNull((Object)request.getFishingOperationId());
        progressionModel.increments(I18n.t((String)"tutti.report.step.load.fishingOperation", (Object[])new Object[0]));
        FishingOperation operation = this.getService(PersistenceService.class).getFishingOperation(request.getFishingOperationId());
        progressionModel.increments(I18n.t((String)"tutti.report.step.export.fishingOperation", (Object[])new Object[0]));
        File exportDirectory = this.getService(TuttiExportService.class).exportFishingOperation(request.getCruiseId(), request.getFishingOperationId());
        File outputFile = this.newOutputFile();
        ReportGenerationContext reportContext = new ReportGenerationContext(request, operation, exportDirectory, outputFile);
        progressionModel.increments(I18n.t((String)"tutti.report.step.generateReport", (Object[])new Object[]{request.getReport().getName()}));
        ReportGenerationResult result = this.generateReport(reportContext);
        return result;
    }

    protected File newOutputFile() {
        return this.context.getConfig().newTempFile("tutti-report", ".pdf");
    }

    protected ReportGenerationResult generateReport(ReportGenerationContext reportContext) {
        Preconditions.checkNotNull((Object)reportContext.getFishingOperation());
        Preconditions.checkNotNull((Object)reportContext.getExportDirectory());
        Preconditions.checkState((boolean)reportContext.getExportDirectory().exists());
        if (log.isInfoEnabled()) {
            log.info((Object)("Will generate report using report " + reportContext.getReport().getName()));
        }
        List<String> arguments = this.prepareCall(reportContext);
        ProcessBuilder pb = new ProcessBuilder(arguments);
        pb.inheritIO();
        if (log.isInfoEnabled()) {
            log.info((Object)("Starts java command: " + arguments));
        }
        try {
            int exitCode = pb.start().waitFor();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit Code: " + exitCode));
            }
            if (exitCode != 0) {
                throw new ApplicationTechnicalException("Report execution failed, see the report log directory " + this.context.getConfig().getReportLogDirectory());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new ApplicationTechnicalException("Could not generate report", (Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Report generated at: " + reportContext.getOutputFile()));
        }
        ReportGenerationResult result = reportContext.toResult();
        return result;
    }

    protected List<String> prepareCall(ReportGenerationContext reportContext) {
        TuttiConfiguration config = this.context.getConfig();
        File reportJarPath = config.getReportJarPath();
        Preconditions.checkState((reportJarPath != null ? 1 : 0) != 0, (Object)"No reportJarPath configured!");
        ArrayList<String> command = new ArrayList<String>();
        command.add(config.getJavaCommandPath());
        command.add("-XX:MaxPermSize=128M");
        command.add("-XX:PermSize=64M");
        command.add("-XX:MaxNewSize=32M");
        command.add("-XX:NewSize=32M");
        command.add("-Xms256m");
        command.add("-Xmx1024m");
        command.add("-jar");
        command.add(reportJarPath.getAbsolutePath());
        command.add(config.getReportHomeDirectory().getAbsolutePath());
        command.add(config.getReportLogDirectory().getAbsolutePath());
        command.add(reportContext.getReport().getAbsolutePath());
        command.add(reportContext.getOutputFile().getAbsolutePath());
        command.add(reportContext.getExportDirectory().getAbsolutePath());
        command.add(reportContext.getFishingOperation().getStationNumber());
        command.add(reportContext.getFishingOperation().getFishingOperationNumber().toString());
        return command;
    }
}

