/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.generic.CatchExportRow;
import fr.ifremer.tutti.service.export.generic.ExportSampleCategory;
import fr.ifremer.tutti.util.Numbers;
import fr.ifremer.tutti.util.Weights;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class CatchExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<CatchExportRow> {
    public static final String WEIGHT_OR_VOL_TYPE = "Poids";
    protected SampleCategoryModel sampleCategoryModel;

    public CatchExportModel(char separator, SampleCategoryModel sampleCategoryModel, DecoratorService decoratorService) {
        super(separator);
        this.sampleCategoryModel = sampleCategoryModel;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newNullableColumnForExport("Engin", "gear.name");
        this.newColumnForExport("Code_station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Code_Taxon", "species.referenceTaxonId", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Code_Espece_Campagne", "species.surveyCode");
        this.newColumnForExport("Nom_scientifique", "species.name");
        this.newColumnForExport("Commentaire", "comment", TuttiCsvUtil.COMMENT_FORMATTER);
        for (SampleCategoryModelEntry entry : sampleCategoryModel.getCategory()) {
            String headerPrefix = entry.getCode();
            int categoryOrder = entry.getOrder();
            String categoryName = "sampleCategory";
            this.newIndexNullableColumnForExport(headerPrefix, categoryName, categoryOrder, "categoryValue", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
            this.newIndexNullableColumnForExport("Num_Ordre_" + headerPrefix + "_H2", categoryName, categoryOrder, "rankOrder", TuttiCsvUtil.INTEGER);
            this.newIndexNullableColumnForExport("Tot_" + headerPrefix, categoryName, categoryOrder, "categoryWeight", TuttiCsvUtil.FLOAT);
            this.newIndexNullableColumnForExport("Ech_" + headerPrefix, categoryName, categoryOrder, "sampleWeight", TuttiCsvUtil.FLOAT);
            this.newIndexNullableColumnForExport("Type_Volume_Poids_" + headerPrefix, categoryName, categoryOrder, "weightOrVolType");
            this.newNullableColumnForExport("Unite_Volume_Poids_" + headerPrefix, "batchWeightUnit");
        }
        this.newNullableColumnForExport("Code_Longueur", "frequency.lengthStepCaracteristic.id");
        this.newNullableColumnForExportByDecorator("Libelle_Longueur", "frequency.lengthStepCaracteristic", decoratorService.getDecoratorByType(Caracteristic.class));
        this.newNullableColumnForExport("Taille", "frequency.lengthStep", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("NumOrdre_Taille_H2", "frequency.rankOrder", TuttiCsvUtil.INTEGER);
        this.newNullableColumnForExport("Poids_Classe_Taille", "frequency.weight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Unite_Taille", "frequency.lengthStepCaracteristic.unit");
        this.newNullableColumnForExport("Precision_Mesure", "frequency.lengthStepCaracteristic.precision", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Nbr", "batchNumber", TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poids_Reference", "referenceWeight", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport("Coef_Elev_Espece_Capture", "raisingFactor", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport("Coef_Final_Elevation", "finalRaisingFactor", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
    }

    public void prepareRows(PersistenceService persistenceService, List<CatchExportRow> rows, Cruise cruise, FishingOperation operation, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch, Float speciesCatchRaisingFactor, Float benthosCatchRaisingFactor) {
        float totalBatchWeight;
        Float batchWeight;
        float raisingFactor;
        CatchExportRow row;
        boolean vracBatch;
        Caracteristic weightMeasuredCaracteristic = persistenceService.getWeightMeasuredCaracteristic();
        String batchWeightUnit = weightMeasuredCaracteristic.getUnit();
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            vracBatch = persistenceService.isVracBatch((SpeciesAbleBatch)speciesBatch);
            row = new CatchExportRow(vracBatch, false);
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(speciesBatch.getSpecies());
            row.setBatchWeightUnit(batchWeightUnit);
            raisingFactor = speciesCatchRaisingFactor.floatValue();
            if (!vracBatch) {
                raisingFactor = 1.0f;
            }
            totalBatchWeight = (batchWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight())) == null ? 0.0f : raisingFactor * batchWeight.floatValue();
            this.addSpeciesBatch(persistenceService, row, rows, speciesBatch, totalBatchWeight);
        }
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            vracBatch = persistenceService.isVracBatch((SpeciesAbleBatch)benthosBatch);
            row = new CatchExportRow(vracBatch, true);
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(benthosBatch.getSpecies());
            row.setBatchWeightUnit(batchWeightUnit);
            raisingFactor = benthosCatchRaisingFactor.floatValue();
            if (!vracBatch) {
                raisingFactor = 1.0f;
            }
            totalBatchWeight = (batchWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight())) == null ? 0.0f : raisingFactor * batchWeight.floatValue();
            this.addBenthosBatch(persistenceService, row, rows, benthosBatch, totalBatchWeight);
        }
        for (CatchExportRow row2 : rows) {
            float finalRaisingFactor = row2.isVrac() ? (row2.isBenthosRow() ? benthosCatchRaisingFactor : speciesCatchRaisingFactor).floatValue() : 1.0f;
            for (ExportSampleCategory exportSampleCategory : row2.getSampleCategory()) {
                float currentRate;
                if (exportSampleCategory == null) continue;
                Float totalWeight = exportSampleCategory.getCategoryWeight();
                Float sampleWeight = (Float)Numbers.getValueOrComputedValue((Number)exportSampleCategory.getSampleWeight(), (Number)exportSampleCategory.getSampleComputedWeight());
                if (totalWeight == null || sampleWeight == null || sampleWeight.floatValue() == 0.0f || !Weights.isNotEqualWeight((float)1.0f, (float)(currentRate = totalWeight.floatValue() / sampleWeight.floatValue()))) continue;
                finalRaisingFactor *= currentRate;
            }
            row2.setFinalRaisingFactor(finalRaisingFactor);
        }
    }

    protected void addSpeciesBatch(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, SpeciesBatch speciesBatch, float totalBatchWeight) {
        currentRow.addComment(speciesBatch.getComment());
        Integer number = (Integer)Numbers.getValueOrComputedValue((Number)speciesBatch.getNumber(), (Number)speciesBatch.getComputedNumber());
        Integer rankOrder = speciesBatch.getRankOrder();
        this.addBatchSampleCategory(currentRow, speciesBatch.getSampleCategoryId(), speciesBatch.getSampleCategoryValue(), speciesBatch.getSampleCategoryWeight(), speciesBatch.getSampleCategoryComputedWeight(), speciesBatch.getWeight(), number, rankOrder);
        if (speciesBatch.isChildBatchsEmpty()) {
            List<SpeciesBatchFrequency> speciesBatchFrequency = persistenceService.getAllSpeciesBatchFrequency(speciesBatch.getId());
            if (CollectionUtils.isEmpty(speciesBatchFrequency)) {
                CatchExportRow row = currentRow.copy();
                Float referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getWeight(), (Number)speciesBatch.getComputedWeight());
                if (referenceWeight == null) {
                    referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight());
                }
                this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                rows.add(row);
            } else {
                boolean withNoWeightOnFrequencies = speciesBatchFrequency.get(0).getWeight() == null;
                Float referenceWeight = null;
                if (withNoWeightOnFrequencies && (referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getWeight(), (Number)speciesBatch.getComputedWeight())) == null) {
                    referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight());
                }
                for (SpeciesBatchFrequency batchFrequency : speciesBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setSpeciesFrequency(batchFrequency);
                    rows.add(row);
                    if (!withNoWeightOnFrequencies) {
                        referenceWeight = batchFrequency.getWeight();
                    }
                    this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                }
            }
        } else {
            int categoryIndex = currentRow.getSampleCategory().size();
            float sampleComputedWeight = 0.0f;
            for (SpeciesBatch childBatch : speciesBatch.getChildBatchs()) {
                CatchExportRow childRow = currentRow.copy();
                this.addSpeciesBatch(persistenceService, childRow, rows, childBatch, totalBatchWeight);
                ExportSampleCategory exportSampleCategory = childRow.getSampleCategory().get(categoryIndex);
                if (exportSampleCategory == null) continue;
                Float categoryWeight = (Float)Numbers.getValueOrComputedValue((Number)exportSampleCategory.getCategoryWeight(), (Number)exportSampleCategory.getComputedWeight());
                if (categoryWeight == null) {
                    throw new ApplicationTechnicalException("Il existe une cat\u00e9gorie de poids non renseign\u00e9e pour l'esp\u00e8ce " + speciesBatch.getSpecies().getSurveyCode());
                }
                sampleComputedWeight += categoryWeight.floatValue();
            }
            currentRow.getSampleCategory().get(categoryIndex - 1).setSampleComputedWeight(Float.valueOf(sampleComputedWeight));
        }
    }

    protected void addBenthosBatch(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, BenthosBatch benthosBatch, float totalBatchWeight) {
        currentRow.addComment(benthosBatch.getComment());
        Integer number = (Integer)Numbers.getValueOrComputedValue((Number)benthosBatch.getNumber(), (Number)benthosBatch.getComputedNumber());
        Integer rankOrder = benthosBatch.getRankOrder();
        if (currentRow.getSampleCategory().isEmpty()) {
            rankOrder = rankOrder + 1000;
        }
        this.addBatchSampleCategory(currentRow, benthosBatch.getSampleCategoryId(), benthosBatch.getSampleCategoryValue(), benthosBatch.getSampleCategoryWeight(), benthosBatch.getSampleCategoryComputedWeight(), benthosBatch.getWeight(), number, rankOrder);
        if (benthosBatch.isChildBatchsEmpty()) {
            List<BenthosBatchFrequency> benthosBatchFrequency = persistenceService.getAllBenthosBatchFrequency(benthosBatch.getId());
            if (CollectionUtils.isEmpty(benthosBatchFrequency)) {
                CatchExportRow row = currentRow.copy();
                Float referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getWeight(), (Number)benthosBatch.getComputedWeight());
                if (referenceWeight == null) {
                    referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
                }
                this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                rows.add(row);
            } else {
                boolean withNoWeightOnFrequencies;
                Float referenceWeight = null;
                boolean bl = withNoWeightOnFrequencies = benthosBatchFrequency.get(0).getWeight() == null;
                if (withNoWeightOnFrequencies && (referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getWeight(), (Number)benthosBatch.getComputedWeight())) == null) {
                    referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
                }
                for (BenthosBatchFrequency batchFrequency : benthosBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setBenthosFrequency(batchFrequency);
                    rows.add(row);
                    if (!withNoWeightOnFrequencies) {
                        referenceWeight = batchFrequency.getWeight();
                    }
                    this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                }
            }
        } else {
            int categoryIndex = currentRow.getSampleCategory().size();
            float sampleComputedWeight = 0.0f;
            for (BenthosBatch childBatch : benthosBatch.getChildBatchs()) {
                CatchExportRow childRow = currentRow.copy();
                this.addBenthosBatch(persistenceService, childRow, rows, childBatch, totalBatchWeight);
                ExportSampleCategory exportSampleCategory = childRow.getSampleCategory().get(categoryIndex);
                Float categoryWeight = (Float)Numbers.getValueOrComputedValue((Number)exportSampleCategory.getCategoryWeight(), (Number)exportSampleCategory.getComputedWeight());
                if (categoryWeight == null) {
                    throw new ApplicationTechnicalException("Il existe une cat\u00e9gorie de poids non renseign\u00e9e pour le benthos " + benthosBatch.getSpecies().getSurveyCode());
                }
                sampleComputedWeight += categoryWeight.floatValue();
            }
            currentRow.getSampleCategory().get(categoryIndex - 1).setSampleComputedWeight(Float.valueOf(sampleComputedWeight));
        }
    }

    protected void setRaisingFactor(CatchExportRow row, float totalBatchWeight, Float referenceWeight) {
        row.setReferenceWeight(referenceWeight);
        row.setRaisingFactor(referenceWeight == null ? 1.0f : totalBatchWeight / referenceWeight.floatValue());
    }

    protected void addBatchSampleCategory(CatchExportRow currentRow, Integer sampleCategoryId, Serializable sampleCategoryValue, Float sampleCategoryWeight, Float sampleCategoryComputedWeight, Float batchWeight, Integer batchNumber, Integer batchRankOrder) {
        currentRow.setBatchNumber(batchNumber);
        ExportSampleCategory sampleCategory = new ExportSampleCategory();
        SampleCategoryModelEntry categoryById = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
        sampleCategory.setCategoryDef(categoryById);
        sampleCategory.setCategoryValue(sampleCategoryValue);
        sampleCategory.setCategoryWeight(sampleCategoryWeight);
        sampleCategory.setSampleWeight(batchWeight);
        sampleCategory.setComputedWeight(sampleCategoryComputedWeight);
        sampleCategory.setWeightOrVolType(WEIGHT_OR_VOL_TYPE);
        sampleCategory.setRankOrder(batchRankOrder);
        currentRow.addSampleCategory(sampleCategory);
    }
}

