// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.pmfm;

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Le support est un composant du milieu sur lequel porte l'investigation. Les supports sont, par
 * exemple :
 * - un engin,
 * - la mer (ou autre environnement),
 * - bivalve (moule, huître, coque...)
 * - crustacé (crevette...)
 * - poisson (merlu, sardine...)
 * - gastéropode (bigorneau, littorine...)
 * - echinoderme	(oursin...)
 * - masse d'eau, eau brute
 * - eau filtrée
 * - ...
 * Le support ne correspond pas au support réellement analysé. En effet, il peut s'agir d'une
 * analyse sur une fraction du support (par exemple, pour le poisson, l'otolite,… ou pour un engin,
 * le bras).
 * Nombre de lignes : 20
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Matrix
    implements Serializable, Comparable<Matrix>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 1171999303343522300L;

    // Generate 5 attributes
    private Integer id;

    /**
     * Identifiant numérique unique du support. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant numérique unique du support. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * Description courte du support.
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Description courte du support.
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String description;

    /**
     * Description longue du support.
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * Description longue du support.
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private Date creationDate;

    /**
     * Date de création système du support. Cette date est renseignée automatiquement.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date de création système du support. Cette date est renseignée automatiquement.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * Date de mise à jour système du support. Cette date est renseignée automatiquement.
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de mise à jour système du support. Cette date est renseignée automatiquement.
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 4 associations
    private Collection<Fraction> fractions = new HashSet<Fraction>();

    /**
     * Une fraction analysée est un composant du support sur lequel porte l'analyse.
     * Les fractions analysées sont généralement des fractions "organiques", au sens d'une
     * classification
     * par partie d'un même organisme,
     * ex : foie, écaille, reins, dents, otolithe...
     * Elles peuvent aussi être un sous ensemble quelconque du support. Par exemple, dans le cas des
     * engins
     * : le bras, …
     * Les fractions dites "systématiques", au sens d'une classification systématique (ex : poisson
     * :
     * Cyprinidae / Cyprinus / Cyprinus carpio...) ne sont pas considérées comme des fractions au
     * sens de
     * l'entité, mais comme une précision apportée sur l'individu. Représentées par les entités
     * "taxon" et
     * "groupe de taxon", elles ne font pas partie de la liste des fractions analysées.
     * Etant une liste de référence, une procédure stricte pour la création de nouvelles fractions
     * analysées pourra être mise en place (On pourra s'inspirer des procédures utilisées dans
     * Quadrige2,
     * qui utilisent le référentiel national du SANDRE).
     * Nombre de lignes : 10
     * @return this.fractions Collection<Fraction>
     */
    public Collection<Fraction> getFractions()
    {
        return this.fractions;
    }

    /**
     * Une fraction analysée est un composant du support sur lequel porte l'analyse.
     * Les fractions analysées sont généralement des fractions "organiques", au sens d'une
     * classification
     * par partie d'un même organisme,
     * ex : foie, écaille, reins, dents, otolithe...
     * Elles peuvent aussi être un sous ensemble quelconque du support. Par exemple, dans le cas des
     * engins
     * : le bras, …
     * Les fractions dites "systématiques", au sens d'une classification systématique (ex : poisson
     * :
     * Cyprinidae / Cyprinus / Cyprinus carpio...) ne sont pas considérées comme des fractions au
     * sens de
     * l'entité, mais comme une précision apportée sur l'individu. Représentées par les entités
     * "taxon" et
     * "groupe de taxon", elles ne font pas partie de la liste des fractions analysées.
     * Etant une liste de référence, une procédure stricte pour la création de nouvelles fractions
     * analysées pourra être mise en place (On pourra s'inspirer des procédures utilisées dans
     * Quadrige2,
     * qui utilisent le référentiel national du SANDRE).
     * Nombre de lignes : 10
     * @param fractionsIn Collection<Fraction>
     */
    public void setFractions(Collection<Fraction> fractionsIn)
    {
        this.fractions = fractionsIn;
    }

    /**
     * Une fraction analysée est un composant du support sur lequel porte l'analyse.
     * Les fractions analysées sont généralement des fractions "organiques", au sens d'une
     * classification
     * par partie d'un même organisme,
     * ex : foie, écaille, reins, dents, otolithe...
     * Elles peuvent aussi être un sous ensemble quelconque du support. Par exemple, dans le cas des
     * engins
     * : le bras, …
     * Les fractions dites "systématiques", au sens d'une classification systématique (ex : poisson
     * :
     * Cyprinidae / Cyprinus / Cyprinus carpio...) ne sont pas considérées comme des fractions au
     * sens de
     * l'entité, mais comme une précision apportée sur l'individu. Représentées par les entités
     * "taxon" et
     * "groupe de taxon", elles ne font pas partie de la liste des fractions analysées.
     * Etant une liste de référence, une procédure stricte pour la création de nouvelles fractions
     * analysées pourra être mise en place (On pourra s'inspirer des procédures utilisées dans
     * Quadrige2,
     * qui utilisent le référentiel national du SANDRE).
     * Nombre de lignes : 10
     * @param elementToAdd Fraction
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFractions(Fraction elementToAdd)
    {
        return this.fractions.add(elementToAdd);
    }

    /**
     * Une fraction analysée est un composant du support sur lequel porte l'analyse.
     * Les fractions analysées sont généralement des fractions "organiques", au sens d'une
     * classification
     * par partie d'un même organisme,
     * ex : foie, écaille, reins, dents, otolithe...
     * Elles peuvent aussi être un sous ensemble quelconque du support. Par exemple, dans le cas des
     * engins
     * : le bras, …
     * Les fractions dites "systématiques", au sens d'une classification systématique (ex : poisson
     * :
     * Cyprinidae / Cyprinus / Cyprinus carpio...) ne sont pas considérées comme des fractions au
     * sens de
     * l'entité, mais comme une précision apportée sur l'individu. Représentées par les entités
     * "taxon" et
     * "groupe de taxon", elles ne font pas partie de la liste des fractions analysées.
     * Etant une liste de référence, une procédure stricte pour la création de nouvelles fractions
     * analysées pourra être mise en place (On pourra s'inspirer des procédures utilisées dans
     * Quadrige2,
     * qui utilisent le référentiel national du SANDRE).
     * Nombre de lignes : 10
     * @param elementToRemove Fraction
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFractions(Fraction elementToRemove)
    {
        return this.fractions.remove(elementToRemove);
    }

    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an Matrix instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Matrix))
        {
            return false;
        }
        final Matrix that = (Matrix)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Matrix}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Matrix}.
         * @return new MatrixImpl()
         */
        public static Matrix newInstance()
        {
            return new MatrixImpl();
        }

        /**
         * Constructs a new instance of {@link Matrix}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param creationDate Date
         * @param fractions Collection<Fraction>
         * @param status Status
         * @return newInstance
         */
        public static Matrix newInstance(String name, Date creationDate, Collection<Fraction> fractions, Status status)
        {
            final Matrix entity = new MatrixImpl();
            entity.setName(name);
            entity.setCreationDate(creationDate);
            entity.setFractions(fractions);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Matrix}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param description String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param fractions Collection<Fraction>
         * @param status Status
         * @return newInstance Matrix
         */
        public static Matrix newInstance(String name, String description, Date creationDate, Timestamp updateDate, Collection<Fraction> fractions, Status status)
        {
            final Matrix entity = new MatrixImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setFractions(fractions);
            entity.setStatus(status);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Matrix o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Matrix.java merge-point
}