/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PdfGeneratorService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(PdfGeneratorService.class);
    protected Configuration freemarkerConfiguration;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.freemarkerConfiguration = new Configuration();
        this.freemarkerConfiguration.setEncoding(Locale.getDefault(), "UTF-8");
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(this.getClass(), "/ftl");
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new BeansWrapper());
    }

    public void generatePdf(File targetFile, Locale locale, String templateName, Object model) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will generate pdf from template " + templateName + " at " + targetFile));
        }
        try {
            Template mapTemplate = this.freemarkerConfiguration.getTemplate(templateName, locale);
            StringWriter out = new StringWriter();
            mapTemplate.process(model, (Writer)out);
            ((Writer)out).flush();
            try (FileOutputStream os = new FileOutputStream(targetFile);){
                ITextRenderer renderer = new ITextRenderer();
                renderer.setDocumentFromString(((Object)out).toString());
                renderer.layout();
                renderer.createPDF((OutputStream)os);
                ((OutputStream)os).close();
            }
        }
        catch (Exception ex) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.exportPdf.error", (Object[])new Object[0]), (Throwable)ex);
        }
    }
}

