/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.type.Type;

public abstract class AbstractPersistenceService
implements TuttiPersistenceServiceImplementor {
    private static final Log log = LogFactory.getLog(AbstractPersistenceService.class);
    @Resource
    protected SessionFactory sessionFactory;
    @Resource(name="tuttiConfiguration")
    protected TuttiConfiguration config;
    private boolean init;
    private Calendar calendar = new GregorianCalendar();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lazyInit() {
        if (!this.init) {
            try {
                this.init();
            }
            finally {
                this.init = true;
            }
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
        this.init = false;
    }

    public void setConfig(TuttiConfiguration config) {
        this.config = config;
    }

    protected final SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected final Session getCurrentSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    protected Object[] queryUnique(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Object result = query.uniqueResult();
        return (Object[])result;
    }

    protected <T> T queryUniqueTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Object result = query.uniqueResult();
        return (T)result;
    }

    protected Iterator<Object[]> queryList(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Iterator result = query.iterate();
        return result;
    }

    protected <T> Iterator<T> queryListTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Iterator result = query.iterate();
        return result;
    }

    protected <T> List<T> queryList2Typed(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        List result = query.list();
        return result;
    }

    protected Query createQuery(String queryName, Object ... params) {
        Query query = this.getCurrentSession().getNamedQuery(queryName);
        if (params.length > 0) {
            Preconditions.checkArgument((params.length % 3 == 0 ? 1 : 0) != 0, (Object)"Params must be tuple (paramName, paramType, paramValue)");
            int nbParams = params.length / 3;
            for (int i = 0; i < nbParams; ++i) {
                String paramName = (String)params[3 * i];
                Type paramType = (Type)params[3 * i + 1];
                Object paramValue = params[3 * i + 2];
                if (paramValue != null && Collection.class.isAssignableFrom(paramValue.getClass())) {
                    query.setParameterList(paramName, (Collection)paramValue, paramType);
                } else {
                    query.setParameter(paramName, paramValue, paramType);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("query [" + queryName + "] (param " + i + " [" + paramName + '=' + paramValue + "])"));
            }
        }
        return query;
    }

    protected <T extends Serializable> T load(Class<? extends T> clazz, Serializable id) {
        Serializable load = (Serializable)this.getCurrentSession().load(clazz, id);
        return (T)load;
    }

    protected <T extends Serializable> T get(Class<? extends T> clazz, Serializable id) {
        Serializable load = (Serializable)this.getCurrentSession().get(clazz, id);
        return (T)load;
    }

    protected int queryUpdate(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        int result = query.executeUpdate();
        if (log.isInfoEnabled()) {
            log.info((Object)(queryName + ": " + result));
        }
        return result;
    }

    protected Date newCreateDate() {
        return this.dateWithNoTime(new Date());
    }

    protected Date dateWithNoTime(Date date) {
        this.calendar.setTime(date);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    protected Date dateWithNoMiliSecond(Date date) {
        this.calendar.setTime(date);
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    protected Date dateWithNoSecondAndMiliSecond(Date date) {
        this.calendar.setTime(date);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    protected Date dateWithNoSecondAndOneMiliSecond(Date date) {
        this.calendar.setTime(date);
        this.calendar.add(13, 0);
        this.calendar.add(14, 1);
        return this.calendar.getTime();
    }

    protected Date dateWithOneMiliSecond(Date date) {
        this.calendar.setTime(date);
        this.calendar.add(14, 1);
        return this.calendar.getTime();
    }

    protected Date dateOfYearWithOneMiliSecond(int year) {
        this.calendar.setTimeInMillis(0L);
        this.calendar.set(1, year);
        this.calendar.set(14, 1);
        return this.calendar.getTime();
    }

    protected long dateOfYearWithOneMiliSecondInMili(int year) {
        this.calendar.setTimeInMillis(0L);
        this.calendar.set(1, year);
        this.calendar.set(14, 1);
        return this.calendar.getTimeInMillis();
    }

    protected Date convertDatabase2UI(Timestamp databaseValue) {
        Date result;
        if (databaseValue == null) {
            result = null;
        } else {
            this.calendar.setTimeInMillis(databaseValue.getTime());
            result = this.calendar.get(14) != 0 ? null : this.calendar.getTime();
        }
        return result;
    }

    protected Date convertUI2DatabaseMandatoryDate(Date uiValue, Date defaultNotEmptyDate, boolean addOneSecondToDefaultDate) {
        Date result;
        if (uiValue == null) {
            Preconditions.checkState((defaultNotEmptyDate != null ? 1 : 0) != 0, (Object)"'defaultNotEmptyDate' could not be null.");
            this.calendar.setTime(defaultNotEmptyDate);
            if (addOneSecondToDefaultDate) {
                this.calendar.add(13, 1);
            }
            this.calendar.set(14, 1);
            result = this.calendar.getTime();
        } else {
            result = this.dateWithNoMiliSecond(uiValue);
        }
        return result;
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.config.getSampleCategoryModel();
    }
}

