/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.query.internal;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.query.SynchroQueryName;
import fr.ifremer.adagio.synchro.query.internal.SynchroInsertQuery;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class SynchroUpdateQuery
extends SynchroInsertQuery {
    public SynchroUpdateQuery(SynchroQueryName queryName, String tableName, List<String> columnNames) {
        super(queryName, tableName, columnNames);
        this.setAllowWhereClause(true);
    }

    public SynchroUpdateQuery(SynchroQueryName queryName, String tableName, List<String> columnNames, List<String> columnValues) {
        super(queryName, tableName, columnNames, columnValues);
        this.setAllowWhereClause(true);
    }

    public SynchroUpdateQuery(SynchroQueryName queryName, String tableName) {
        super(queryName, tableName);
        this.setAllowWhereClause(true);
    }

    @Override
    public String toSql() {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)this.columnNames));
        StringBuilder updateParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            updateParams.append(", ").append(columnName);
            String value = (String)this.columnValues.get(columnName);
            if (value != null) {
                updateParams.append(" = ").append(value);
                continue;
            }
            updateParams.append(" = ?");
        }
        String sql = String.format("UPDATE %s SET %s%s", this.tableName, updateParams.substring(2), this.getSqlWhereClause());
        return sql;
    }
}

