/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import java.util.Collection;
import java.util.List;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface VesselPersistenceService
extends TuttiPersistenceServiceImplementor {
    public List<Vessel> getAllScientificVessel();

    @Cacheable(value={"fishingVessels"})
    public List<Vessel> getAllFishingVessel();

    @Cacheable(value={"vesselByCode"}, key="#vesselCode")
    public Vessel getVessel(String var1);

    public boolean isTemporaryVesselUsed(String var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fishingVessels", "vesselByCode"}, allEntries=true)
    public Collection<Vessel> importTemporaryVessel(Collection<Vessel> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache", "fishingVessels", "vesselByCode"}, allEntries=true)
    public void replaceVessel(Vessel var1, Vessel var2, boolean var3);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fishingVessels", "vesselByCode"}, allEntries=true)
    public void deleteTemporaryVessels(Collection<String> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fishingVessels", "vesselByCode"}, allEntries=true)
    public void deleteTemporaryVessel(String var1);
}

