/*
 * #%L
 * SIH-Adagio
 * $Id: javaMergeMappings.xml 12002 2014-03-26 10:17:22Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.3/mda/src/main/config/javaMergeMappings.xml $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
//
// Attention: Generated code! Do not modify by hand!
// Generated by: TypeSafeEnumeration.vsl in andromda-java-cartridge.
// Model Class:  Data::fr.ifremer.adagio.core.dao::referential::pmfm::MatrixId
// Metafacade:   org.andromda.metafacades.uml.Enumeration
// Stereotype:  Enumeration
//
package fr.ifremer.adagio.core.dao.referential.pmfm;

import fr.ifremer.adagio.core.dao.technical.AdagioEnumerationDef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import static org.nuiton.i18n.I18n.n;

/**
 * 
 */
public enum MatrixId
    implements Serializable, AdagioEnumerationDef<Integer>
{
    /** TODO: Model Documentation for Enumeration Literal VESSEL value 8 */
    VESSEL (
			"adagio.enumeration.MatrixId.VESSEL", 
			n("adagio.enumeration.MatrixId.VESSEL.description"), 
			8),
    /** TODO: Model Documentation for Enumeration Literal OPERATION value 7 */
    OPERATION (
			"adagio.enumeration.MatrixId.OPERATION", 
			n("adagio.enumeration.MatrixId.OPERATION.description"), 
			7),
    /** TODO: Model Documentation for Enumeration Literal GEAR value 2 */
    GEAR (
			"adagio.enumeration.MatrixId.GEAR", 
			n("adagio.enumeration.MatrixId.GEAR.description"), 
			2),
    /** TODO: Model Documentation for Enumeration Literal FISHING_METIER value 10 */
    FISHING_METIER (
			"adagio.enumeration.MatrixId.FISHING_METIER", 
			n("adagio.enumeration.MatrixId.FISHING_METIER.description"), 
			10),
    /** TODO: Model Documentation for Enumeration Literal PRODUCE_BATCH value 1 */
    PRODUCE_BATCH (
			"adagio.enumeration.MatrixId.PRODUCE_BATCH", 
			n("adagio.enumeration.MatrixId.PRODUCE_BATCH.description"), 
			1);

    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 647293641244600226L;

    private String key;
    private String description;
    private Integer enumValue;

    private MatrixId(String key, String description, Integer value)
    {
    	this.key = key;
    	this.description = description;
        this.enumValue = value;
    }
    
    @Override
    public void setValue(Integer newValue) {
		if (newValue != null && !this.enumValue.equals(newValue)) {
			// Update static lists
	    	values.remove(this.enumValue);
	    	literals.remove(this.enumValue);
	    	this.enumValue = newValue;
	    	values.put(this.enumValue, this);
	    	literals.add(this.enumValue);
		}
    }
    

    @Override
    public String getValueAsString()
    {
        return String.valueOf(this.enumValue);
    }

    /**
     * Retrieves an instance of MatrixId from <code>its name</code>.
     *
     * @param name the name to create the MatrixId from.
     * @return The enumeration literal named after the 'name' argument
     */
    public static MatrixId fromString(String name)
    {
        return MatrixId.valueOf(name);
    }

    /**
     * Returns an enumeration literal Integer <code>value</code>.
     * Required by JAXB2 enumeration implementation
     *
     * @return Integer with corresponding value
     */
    public Integer value()
    {
        return this.enumValue;
    }

    /**
     * Returns an instance of MatrixId from Integer <code>value</code>.
     * Required by JAXB2 enumeration implementation
     *
     * @param value the value to create the MatrixId from.
     * @return static Enumeration with corresponding value
     */
    public static MatrixId fromValue(Integer value)
    {
        for (MatrixId enumName: MatrixId.values())
        {
            if (enumName.getValue().equals(value))
            {
                return enumName;
            }
        }
        throw new IllegalArgumentException("MatrixId.fromValue(" + value.toString() + ')');
    }

    /**
     * Gets the underlying value of this type safe enumeration.
     * This method is necessary to comply with DaoBase implementation.
     * @return The name of this literal.
     */
    public Integer getValue()
    {
        return this.enumValue;
    }
    
    @Override
    public String getDescription() {
    	return description;
    }
    
    @Override
    public String getKey() {
    	return key;
    }
    
    @Override
    public Class<?> getType() {
    	return Integer.class;
    }
    
    /**
     * Returns an unmodifiable list containing the literals that are known by this enumeration.
     *
     * @return A List containing the actual literals defined by this enumeration, this list
     *         can not be modified.
     */
    public static List<Integer> literals()
    {
        return MatrixId.literals;
    }

    /**
     * Returns an unmodifiable list containing the names of the literals that are known
     * by this enumeration.
     *
     * @return A List containing the actual names of the literals defined by this
     *         enumeration, this list can not be modified.
     */
    public static List<String> names()
    {
        return MatrixId.names;
    }

    private static Map<Integer, MatrixId> values = new LinkedHashMap<Integer, MatrixId>(5, 1);
    private static List<Integer> literals = new ArrayList<Integer>(5);
    private static List<String> names = new ArrayList<String>(5);
    private static List<MatrixId> valueList = new ArrayList<MatrixId>(5);

    /**
     * Initializes the values.
     */
    static
    {
        synchronized (MatrixId.values)
        {
            MatrixId.values.put(VESSEL.enumValue, VESSEL);
            MatrixId.values.put(OPERATION.enumValue, OPERATION);
            MatrixId.values.put(GEAR.enumValue, GEAR);
            MatrixId.values.put(FISHING_METIER.enumValue, FISHING_METIER);
            MatrixId.values.put(PRODUCE_BATCH.enumValue, PRODUCE_BATCH);
        }
        synchronized (MatrixId.valueList)
        {
            MatrixId.valueList.add(VESSEL);
            MatrixId.valueList.add(OPERATION);
            MatrixId.valueList.add(GEAR);
            MatrixId.valueList.add(FISHING_METIER);
            MatrixId.valueList.add(PRODUCE_BATCH);
            // For Adagio, lists could be reload from configuration
            //MatrixId.valueList = Collections.unmodifiableList(valueList);
        }
        synchronized (MatrixId.literals)
        {
            MatrixId.literals.add(VESSEL.enumValue);
            MatrixId.literals.add(OPERATION.enumValue);
            MatrixId.literals.add(GEAR.enumValue);
            MatrixId.literals.add(FISHING_METIER.enumValue);
            MatrixId.literals.add(PRODUCE_BATCH.enumValue);
            // For Adagio, lists could be reload from configuration
            //MatrixId.literals = Collections.unmodifiableList(literals);
        }
        synchronized (MatrixId.names)
        {
            MatrixId.names.add("VESSEL");
            MatrixId.names.add("OPERATION");
            MatrixId.names.add("GEAR");
            MatrixId.names.add("FISHING_METIER");
            MatrixId.names.add("PRODUCE_BATCH");
            MatrixId.names = Collections.unmodifiableList(names);
        }
    }
    // type-safe-enumeration-object java merge-point
}