// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.scientificCruise;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * <html>
 * <head>
 * </head>
 * <body>
 * <p>
 * Campagne scientifique.
 * </p>
 * <p>
 * <br><u>D&#233;finiition :</u>
 * </p>
 * <p>
 * </p>
 * <p>
 * The period of time during which a scientific research vessel is operated
 * in furtherance of a scientific research project, beginning when the
 * vessel leaves port to undertake the project and ending when the vessel
 * completes the project as provided for in the applicable scientific
 * research plan.
 * </p>
 * <p>
 * </p>
 * <p>
 * <i>US Dept. of Commerce (1996):
 * http://caldera.sero.nmfs.gov/fishery/regs/inter600.htm#B</i>
 * </p>
 * </body>
 * </html>
 */
// HibernateEntity.vsl annotations merge-point
public abstract class ScientificCruise
    implements Serializable, Comparable<ScientificCruise>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -7030869324179181656L;

    // Generate 10 attributes
    private Integer id;

    /**
     * Identifiant interne de la campagne. Renseigné par le système dans tous les cas.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant interne de la campagne. Renseigné par le système dans tous les cas.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String synchronizationStatus;

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @return this.synchronizationStatus String
     */
    public String getSynchronizationStatus()
    {
        return this.synchronizationStatus;
    }

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @param synchronizationStatusIn String
     */
    public void setSynchronizationStatus(String synchronizationStatusIn)
    {
        this.synchronizationStatus = synchronizationStatusIn;
    }

    private String name;

    /**
     * Libellé décrivant la campagne. Ne pas renseigner si SISMER.
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Libellé décrivant la campagne. Ne pas renseigner si SISMER.
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private Date departureDateTime;

    /**
     * Date et heure de départ de la campagne scientifique.
     * @return this.departureDateTime Date
     */
    public Date getDepartureDateTime()
    {
        return this.departureDateTime;
    }

    /**
     * Date et heure de départ de la campagne scientifique.
     * @param departureDateTimeIn Date
     */
    public void setDepartureDateTime(Date departureDateTimeIn)
    {
        this.departureDateTime = departureDateTimeIn;
    }

    private Date returnDateTime;

    /**
     * Date et heure de départ de la campagne scientifique. Optionnel.
     * @return this.returnDateTime Date
     */
    public Date getReturnDateTime()
    {
        return this.returnDateTime;
    }

    /**
     * Date et heure de départ de la campagne scientifique. Optionnel.
     * @param returnDateTimeIn Date
     */
    public void setReturnDateTime(Date returnDateTimeIn)
    {
        this.returnDateTime = returnDateTimeIn;
    }

    private String reference;

    /**
     * Lien vers le serveur SISMER. Probablement la référence SISMER de la campagne CAM_CAMREF
     * (FI351997020020 par exemple)
     * @return this.reference String
     */
    public String getReference()
    {
        return this.reference;
    }

    /**
     * Lien vers le serveur SISMER. Probablement la référence SISMER de la campagne CAM_CAMREF
     * (FI351997020020 par exemple)
     * @param referenceIn String
     */
    public void setReference(String referenceIn)
    {
        this.reference = referenceIn;
    }

    private String comments;

    /**
     * Commentaire sur la campagne. Ne pas renseigner si SISMER.
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire sur la campagne. Ne pas renseigner si SISMER.
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * Date de dernière mise à jour.
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de dernière mise à jour.
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 6 associations
    private Person managerPerson;

    /**
     * Responsable de campagne
     * @return this.managerPerson Person
     */
    public Person getManagerPerson()
    {
        return this.managerPerson;
    }

    /**
     * Responsable de campagne
     * @param managerPersonIn Person
     */
    public void setManagerPerson(Person managerPersonIn)
    {
        this.managerPerson = managerPersonIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Department recorderDepartment;

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Person recorderPerson;

    /**
     * Utilisateur ayant saisie la donnée.
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Utilisateur ayant saisie la donnée.
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private Collection<FishingTrip> fishingTrips = new HashSet<FishingTrip>();

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @return this.fishingTrips Collection<FishingTrip>
     */
    public Collection<FishingTrip> getFishingTrips()
    {
        return this.fishingTrips;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param fishingTripsIn Collection<FishingTrip>
     */
    public void setFishingTrips(Collection<FishingTrip> fishingTripsIn)
    {
        this.fishingTrips = fishingTripsIn;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param elementToAdd FishingTrip
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFishingTrips(FishingTrip elementToAdd)
    {
        return this.fishingTrips.add(elementToAdd);
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param elementToRemove FishingTrip
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFishingTrips(FishingTrip elementToRemove)
    {
        return this.fishingTrips.remove(elementToRemove);
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    /**
     * Returns <code>true</code> if the argument is an ScientificCruise instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof ScientificCruise))
        {
            return false;
        }
        final ScientificCruise that = (ScientificCruise)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link ScientificCruise}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link ScientificCruise}.
         * @return new ScientificCruiseImpl()
         */
        public static ScientificCruise newInstance()
        {
            return new ScientificCruiseImpl();
        }

        /**
         * Constructs a new instance of {@link ScientificCruise}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param synchronizationStatus String
         * @param name String
         * @param departureDateTime Date
         * @param creationDate Date
         * @param managerPerson Person
         * @param vessel Vessel
         * @param recorderDepartment Department
         * @param program Program
         * @return newInstance
         */
        public static ScientificCruise newInstance(String synchronizationStatus, String name, Date departureDateTime, Date creationDate, Person managerPerson, Vessel vessel, Department recorderDepartment, Program program)
        {
            final ScientificCruise entity = new ScientificCruiseImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setName(name);
            entity.setDepartureDateTime(departureDateTime);
            entity.setCreationDate(creationDate);
            entity.setManagerPerson(managerPerson);
            entity.setVessel(vessel);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            return entity;
        }

        /**
         * Constructs a new instance of {@link ScientificCruise}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param synchronizationStatus String
         * @param name String
         * @param departureDateTime Date
         * @param returnDateTime Date
         * @param reference String
         * @param comments String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param managerPerson Person
         * @param vessel Vessel
         * @param recorderDepartment Department
         * @param recorderPerson Person
         * @param fishingTrips Collection<FishingTrip>
         * @param program Program
         * @return newInstance ScientificCruise
         */
        public static ScientificCruise newInstance(String synchronizationStatus, String name, Date departureDateTime, Date returnDateTime, String reference, String comments, Date creationDate, Timestamp updateDate, Integer remoteId, Person managerPerson, Vessel vessel, Department recorderDepartment, Person recorderPerson, Collection<FishingTrip> fishingTrips, Program program)
        {
            final ScientificCruise entity = new ScientificCruiseImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setName(name);
            entity.setDepartureDateTime(departureDateTime);
            entity.setReturnDateTime(returnDateTime);
            entity.setReference(reference);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setManagerPerson(managerPerson);
            entity.setVessel(vessel);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setRecorderPerson(recorderPerson);
            entity.setFishingTrips(fishingTrips);
            entity.setProgram(program);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(ScientificCruise o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getSynchronizationStatus() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSynchronizationStatus().compareTo(o.getSynchronizationStatus()));
            }
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDepartureDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDepartureDateTime().compareTo(o.getDepartureDateTime()));
            }
            if (this.getReturnDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getReturnDateTime().compareTo(o.getReturnDateTime()));
            }
            if (this.getReference() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getReference().compareTo(o.getReference()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// ScientificCruise.java merge-point
}