// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.measure;

import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.referential.AnalysisInstrument;
import fr.ifremer.adagio.core.dao.referential.NumericalPrecision;
import fr.ifremer.adagio.core.dao.referential.PrecisionType;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.pmfm.AggregationLevel;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import java.util.Date;

/**
 * Valeur mesurée ou analysée sur un individu (résultats de mesures sur individu) appartenant à un
 * prélèvement effectué lors d'un échantillonnage biologique, lors d'une marée, d'un vente ou d'un
 * débarquement observé. Les observations sur le prélèvement sont souvent menées en laboratoire, à
 * terre.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class SampleMeasurement
    extends MeasurementImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 4164573865635600759L;

    // Generate 2 attributes
    private Short individualNumber;

    /**
     * Numéro de l'individu sur lequel est effectué la mesure.
     * (quand plusieurs individu ont été comptés, au niveau de l'échantillon)
     * @return this.individualNumber Short
     */
    public Short getIndividualNumber()
    {
        return this.individualNumber;
    }

    /**
     * Numéro de l'individu sur lequel est effectué la mesure.
     * (quand plusieurs individu ont été comptés, au niveau de l'échantillon)
     * @param individualNumberIn Short
     */
    public void setIndividualNumber(Short individualNumberIn)
    {
        this.individualNumber = individualNumberIn;
    }

    private Boolean isReferenceMeasurement = Boolean.valueOf(true);

    /**
     * Dans le cas de plusieurs résultat de mesure au sein d'un prélèvement sur un meme individu
     * (identifié par le numéro d'individu), cela permet de distinguer la valeur de référence (celle
     * qu'il faudra exploiter) tout en gardant les autres mesure.
     * Exemple :
     * - Pour la leture d'age, plusieurs déterminations d'age sont effectuées, mais une seule est
     * conservée.
     * @return this.isReferenceMeasurement Boolean
     */
    public Boolean isIsReferenceMeasurement()
    {
        return this.isReferenceMeasurement;
    }

    /**
     * Dans le cas de plusieurs résultat de mesure au sein d'un prélèvement sur un meme individu
     * (identifié par le numéro d'individu), cela permet de distinguer la valeur de référence (celle
     * qu'il faudra exploiter) tout en gardant les autres mesure.
     * Exemple :
     * - Pour la leture d'age, plusieurs déterminations d'age sont effectuées, mais une seule est
     * conservée.
     * @param isReferenceMeasurementIn Boolean
     */
    public void setIsReferenceMeasurement(Boolean isReferenceMeasurementIn)
    {
        this.isReferenceMeasurement = isReferenceMeasurementIn;
    }

    // Generate 1 associations
    private Sample sample;

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @return this.sample Sample
     */
    public Sample getSample()
    {
        return this.sample;
    }

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @param sampleIn Sample
     */
    public void setSample(Sample sampleIn)
    {
        this.sample = sampleIn;
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>MeasurementImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.measure.Measurement#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>MeasurementImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.measure.Measurement#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link SampleMeasurement}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link SampleMeasurement}.
         * @return new SampleMeasurementImpl()
         */
        public static SampleMeasurement newInstance()
        {
            return new SampleMeasurementImpl();
        }

        /**
         * Constructs a new instance of {@link SampleMeasurement}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param qualityFlag QualityFlag
         * @param pmfm Pmfm
         * @param isReferenceMeasurement Boolean
         * @param sample Sample
         * @return newInstance
         */
        public static SampleMeasurement newInstance(QualityFlag qualityFlag, Pmfm pmfm, Boolean isReferenceMeasurement, Sample sample)
        {
            final SampleMeasurement entity = new SampleMeasurementImpl();
            entity.setQualityFlag(qualityFlag);
            entity.setPmfm(pmfm);
            entity.setIsReferenceMeasurement(isReferenceMeasurement);
            entity.setSample(sample);
            return entity;
        }

        /**
         * Constructs a new instance of {@link SampleMeasurement}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param numericalValue Float
         * @param alphanumericalValue String
         * @param digitCount Integer
         * @param precisionValue Float
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param remoteId Integer
         * @param aggregationLevel AggregationLevel
         * @param qualityFlag QualityFlag
         * @param precisionType PrecisionType
         * @param analysisInstrument AnalysisInstrument
         * @param numericalPrecision NumericalPrecision
         * @param department Department
         * @param pmfm Pmfm
         * @param qualitativeValue QualitativeValue
         * @param individualNumber Short
         * @param isReferenceMeasurement Boolean
         * @param sample Sample
         * @return newInstance SampleMeasurement
         */
        public static SampleMeasurement newInstance(Float numericalValue, String alphanumericalValue, Integer digitCount, Float precisionValue, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Integer remoteId, AggregationLevel aggregationLevel, QualityFlag qualityFlag, PrecisionType precisionType, AnalysisInstrument analysisInstrument, NumericalPrecision numericalPrecision, Department department, Pmfm pmfm, QualitativeValue qualitativeValue, Short individualNumber, Boolean isReferenceMeasurement, Sample sample)
        {
            final SampleMeasurement entity = new SampleMeasurementImpl();
            entity.setNumericalValue(numericalValue);
            entity.setAlphanumericalValue(alphanumericalValue);
            entity.setDigitCount(digitCount);
            entity.setPrecisionValue(precisionValue);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setRemoteId(remoteId);
            entity.setAggregationLevel(aggregationLevel);
            entity.setQualityFlag(qualityFlag);
            entity.setPrecisionType(precisionType);
            entity.setAnalysisInstrument(analysisInstrument);
            entity.setNumericalPrecision(numericalPrecision);
            entity.setDepartment(department);
            entity.setPmfm(pmfm);
            entity.setQualitativeValue(qualitativeValue);
            entity.setIndividualNumber(individualNumber);
            entity.setIsReferenceMeasurement(isReferenceMeasurement);
            entity.setSample(sample);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(SampleMeasurement o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getIndividualNumber() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIndividualNumber().compareTo(o.getIndividualNumber()));
            }
            if (this.isIsReferenceMeasurement() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsReferenceMeasurement().compareTo(o.isIsReferenceMeasurement()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// SampleMeasurement.java merge-point
}