/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.launcher;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class LauncherProperties {
    public static final String LAUNCHER_PROPERTIES_FILENAME = "launcher.properties";
    public static final String PROPERTY_UPDATER_JAR = "updater.jar";
    public static final String PROPERTY_UPDATER_LOGFILE = "updater.logFile";
    public static final String PROPERTY_APPLICATION_JAR = "application.jar";
    public static final String PROPERTY_APPLICATION_LOGFILE = "application.logFile";
    public static final String PROPERTY_APPLICATION_JVM_OPTIONS = "application.jvmOptions";
    public static final String PROPERTY_APPLICATION_OPTIONS = "application.options";
    private final Path basedir;
    Properties launcherProperties;

    public LauncherProperties(Path basedir) {
        this.basedir = basedir;
    }

    public void load() throws IOException {
        Throwable throwable;
        FileReader reader;
        Path applicationFile = this.basedir.resolve("tutti").resolve(LAUNCHER_PROPERTIES_FILENAME);
        Path localFile = this.basedir.resolve(LAUNCHER_PROPERTIES_FILENAME);
        if (!Files.exists(localFile, new LinkOption[0]) && !Files.exists(applicationFile, new LinkOption[0])) {
            throw new IOException("Could not find launcher.properties");
        }
        Properties p1 = new Properties();
        if (Files.isReadable(applicationFile)) {
            reader = new FileReader(applicationFile.toFile());
            throwable = null;
            try {
                p1.load(reader);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        this.launcherProperties = new Properties(p1);
        if (Files.isReadable(localFile)) {
            reader = new FileReader(localFile.toFile());
            throwable = null;
            try {
                this.launcherProperties.load(reader);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
    }

    public Path getUpdaterJarFile() {
        String jarFileName = this.launcherProperties.getProperty(PROPERTY_UPDATER_JAR);
        Path jarFile = this.basedir.resolve(jarFileName);
        return jarFile;
    }

    public Path getUpdaterLogFile() {
        String logFileName = this.launcherProperties.getProperty(PROPERTY_UPDATER_LOGFILE);
        Path logFile = this.basedir.resolve(logFileName);
        return logFile;
    }

    public Path getApplicationJarFile() {
        String jarFileName = this.launcherProperties.getProperty(PROPERTY_APPLICATION_JAR);
        Path jarFile = this.basedir.resolve(jarFileName);
        return jarFile;
    }

    public Path getApplicationLogFile() {
        String logFileName = this.launcherProperties.getProperty(PROPERTY_APPLICATION_LOGFILE);
        Path logFile = this.basedir.resolve(logFileName);
        return logFile;
    }

    public List<String> getApplicationJvmOptions() {
        List<String> options = this.getOptions(PROPERTY_APPLICATION_JVM_OPTIONS);
        return options;
    }

    public List<String> getApplicationOtherOptions() {
        List<String> options = this.getOptions(PROPERTY_APPLICATION_OPTIONS);
        return options;
    }

    protected List<String> getOptions(String key) {
        ArrayList<String> result = new ArrayList<String>();
        String options = this.launcherProperties.getProperty(key);
        if (options != null && !options.trim().isEmpty()) {
            String[] javaOptsArray;
            for (String opt : javaOptsArray = options.replaceAll("\"", "").split(" ")) {
                if (opt == null || opt.trim().isEmpty()) continue;
                result.add(opt);
            }
        }
        return result;
    }
}

