/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript.device;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.emitter.postscript.PostscriptWriter;
import org.eclipse.birt.report.engine.emitter.postscript.device.PostscriptPage;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;

public class PostscriptPageDevice
implements IPageDevice {
    private PostscriptWriter writer;
    private PostscriptPage currentPage;
    private String orientation;

    public PostscriptPageDevice(RenderOption renderOption, OutputStream output, String title, String author, String description) throws Exception {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(output);
        this.writer = new PostscriptWriter(bufferedOutputStream, title);
        String paperSize = renderOption.getStringOption("OptionPagerSize");
        String paperTray = renderOption.getStringOption("OptionPageTray");
        Object duplex = renderOption.getOption("OptionDuplex");
        int copies = renderOption.getIntOption("OptionCopies", 1);
        boolean collate = renderOption.getBooleanOption("OptionCollate", false);
        String resolution = renderOption.getStringOption("OptionResolution");
        boolean color = renderOption.getBooleanOption("OptionColor", true);
        int scale = renderOption.getIntOption("OptionScale", 100);
        boolean autoPaperSizeSelection = renderOption.getBooleanOption("OptionAutoPaperSizeSelection", false);
        boolean fitToPaper = renderOption.getBooleanOption("OptionFitToPaper", false);
        this.writer.startRenderer(author, description, paperSize, paperTray, duplex, copies, collate, resolution, color, scale, autoPaperSizeSelection, fitToPaper);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public IPage newPage(int width, int height, Color backgroundColor) {
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
        this.currentPage = new PostscriptPage(width, height, backgroundColor, this.writer, this.orientation);
        return this.currentPage;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }
}

