/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ColumnsInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;

public class XlsTable
extends XlsContainer {
    private ColumnsInfo columnsInfo;

    public XlsTable(StyleEntry entry, ContainerSizeInfo sizeInfo, XlsContainer parent) {
        super(entry, sizeInfo, parent);
    }

    public XlsTable(ColumnsInfo table, StyleEntry entry, ContainerSizeInfo sizeInfo, XlsContainer parent) {
        this(entry, sizeInfo, parent);
        this.columnsInfo = table;
    }

    public XlsTable(ColumnsInfo table, XlsContainer container) {
        this(table, container.getStyle(), container.getSizeInfo(), container);
    }

    public ContainerSizeInfo getColumnSizeInfo(int column, int span) {
        ContainerSizeInfo sizeInfo = this.getSizeInfo();
        int startCoordinate = sizeInfo.getStartCoordinate();
        int endCoordinate = sizeInfo.getEndCoordinate();
        int[] columnWidths = this.columnsInfo.getColumns();
        int i = 0;
        while (i < column) {
            startCoordinate += columnWidths[i];
            ++i;
        }
        if (startCoordinate >= endCoordinate) {
            return null;
        }
        int width = 0;
        int i2 = column;
        while (i2 < column + span) {
            width += columnWidths[i2];
            ++i2;
        }
        width = Math.min(width, endCoordinate - startCoordinate);
        return new ContainerSizeInfo(startCoordinate, width);
    }

    public ColumnsInfo getColumnsInfo() {
        return this.columnsInfo;
    }
}

