/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter;

import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;

class FilterUtil {
    private FilterUtil() {
    }

    static boolean isEqualLevels(DimLevel[] levels1, DimLevel[] levels2) {
        if (levels1 == null && levels2 == null) {
            return true;
        }
        if (levels1 == null || levels2 == null) {
            return false;
        }
        if (levels1.length != levels2.length) {
            return false;
        }
        int i = 0;
        while (i < levels1.length) {
            if (!levels1[i].equals(levels2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static int getTargetLevelIndex(ILevel[] levels, String targetLevelName) {
        int index = 0;
        index = 0;
        while (index < levels.length) {
            if (levels[index].getName().equals(targetLevelName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    static int getTargetN(long total, double N) {
        return (int)Math.round(N / 100.0 * (double)total);
    }

    static boolean shareParentLevels(Member[] members1, Member[] member2, int targetIndex) {
        assert (members1 != null && member2 != null);
        int i = 0;
        while (i < targetIndex) {
            if (members1[i] != null && member2[i] != null && !members1[i].equals(member2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

