/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.statement.DatabaseFunction;

public class UnknownType
extends LiquibaseDataType {
    public UnknownType() {
        super("UNKNOWN", 0, 2);
    }

    public UnknownType(String name) {
        super(name, 0, 2);
    }

    public UnknownType(String name, int minParameters, int maxParameters) {
        super(name, minParameters, maxParameters);
    }

    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        int dataTypeMaxParameters = this.getName().equalsIgnoreCase("enum") || this.getName().equalsIgnoreCase("set") ? Integer.MAX_VALUE : database.getDataTypeMaxParameters(this.getName());
        Object[] parameters = this.getParameters();
        if (database instanceof MySQLDatabase && (this.getName().equalsIgnoreCase("TINYBLOB") || this.getName().equalsIgnoreCase("MEDIUMBLOB") || this.getName().equalsIgnoreCase("TINYTEXT") || this.getName().equalsIgnoreCase("MEDIUMTEXT") || this.getName().equalsIgnoreCase("REAL"))) {
            parameters = new Object[]{};
        }
        if (database instanceof DB2Database && (this.getName().equalsIgnoreCase("REAL") || this.getName().equalsIgnoreCase("XML"))) {
            parameters = new Object[]{};
        }
        if (database instanceof MSSQLDatabase && (this.getName().equalsIgnoreCase("REAL") || this.getName().equalsIgnoreCase("XML") || this.getName().equalsIgnoreCase("HIERARCHYID") || this.getName().equalsIgnoreCase("DATETIMEOFFSET") || this.getName().equalsIgnoreCase("IMAGE") || this.getName().equalsIgnoreCase("NTEXT") || this.getName().equalsIgnoreCase("SMALLMONEY"))) {
            parameters = new Object[]{};
        }
        if (database instanceof OracleDatabase) {
            if (this.getName().equalsIgnoreCase("LONG") || this.getName().equalsIgnoreCase("NCLOB") || this.getName().equalsIgnoreCase("BFILE") || this.getName().equalsIgnoreCase("ROWID")) {
                parameters = new Object[]{};
            } else if (this.getName().toUpperCase().startsWith("INTERVAL ")) {
                return new DatabaseDataType(this.getName().replaceAll("\\(\\d+\\)", ""));
            }
        }
        if (dataTypeMaxParameters < parameters.length) {
            parameters = Arrays.copyOfRange(parameters, 0, dataTypeMaxParameters);
        }
        DatabaseDataType type = new DatabaseDataType(this.getName().toUpperCase(), parameters);
        type.addAdditionalInformation(this.getAdditionalInformation());
        return type;
    }

    @Override
    public String objectToSql(Object value, Database database) {
        if (value instanceof DatabaseFunction) {
            return super.objectToSql(value, database);
        }
        return "'" + super.objectToSql(value, database) + "'";
    }
}

